/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.CombineHiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class CombineHiveInputFormat<K extends WritableComparable, V extends Writable>
extends HiveInputFormat<K, V> {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.io.CombineHiveInputFormat");

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        HadoopShims.InputSplitShim[] iss;
        this.init(job);
        HadoopShims.CombineFileInputFormatShim combine = ShimLoader.getHadoopShims().getCombineFileInputFormat();
        if (combine.getInputPathsShim(job).length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<CombineHiveInputSplit> result = new ArrayList<CombineHiveInputSplit>();
        Path[] paths = combine.getInputPathsShim(job);
        for (int i = 0; i < paths.length; ++i) {
            LOG.info((Object)("CombineHiveInputSplit creating pool for " + paths[i]));
            combine.createPool(job, new CombineFilter(paths[i]));
        }
        for (HadoopShims.InputSplitShim is : iss = combine.getSplits(job, 1)) {
            CombineHiveInputSplit csplit = new CombineHiveInputSplit(job, is);
            result.add(csplit);
        }
        LOG.info((Object)("number of splits " + result.size()));
        return result.toArray(new CombineHiveInputSplit[result.size()]);
    }

    @Override
    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        CombineHiveInputSplit hsplit = (CombineHiveInputSplit)split;
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        this.initColumnsNeeded(job, inputFormatClass, hsplit.getPath(0).toString(), hsplit.getPath(0).toUri().getPath());
        return ShimLoader.getHadoopShims().getCombineFileInputFormat().getRecordReader(job, ((CombineHiveInputSplit)split).getInputSplitShim(), reporter, CombineHiveRecordReader.class);
    }

    protected static partitionDesc getPartitionDescFromPath(Map<String, partitionDesc> pathToPartitionInfo, Path dir) throws IOException {
        for (Map.Entry<String, partitionDesc> entry : pathToPartitionInfo.entrySet()) {
            try {
                if (!new URI(entry.getKey()).getPath().equals(dir.toUri().getPath())) continue;
                return entry.getValue();
            }
            catch (URISyntaxException e2) {
            }
        }
        throw new IOException("cannot find dir = " + dir.toString() + " in partToPartitionInfo!");
    }

    static class CombineFilter
    implements PathFilter {
        private String pString;

        public CombineFilter(Path p) {
            this.pString = p.toString() + File.separator;
        }

        public boolean accept(Path path) {
            return path.toString().indexOf(this.pString) == 0;
        }

        public String toString() {
            return "PathFilter:" + this.pString;
        }
    }

    public static class CombineHiveInputSplit
    implements HadoopShims.InputSplitShim {
        String inputFormatClassName;
        HadoopShims.InputSplitShim inputSplitShim;

        public CombineHiveInputSplit() throws IOException {
            this(ShimLoader.getHadoopShims().getCombineFileInputFormat().getInputSplitShim());
        }

        public CombineHiveInputSplit(HadoopShims.InputSplitShim inputSplitShim) throws IOException {
            this(inputSplitShim.getJob(), inputSplitShim);
        }

        public CombineHiveInputSplit(JobConf job, HadoopShims.InputSplitShim inputSplitShim) throws IOException {
            this.inputSplitShim = inputSplitShim;
            if (job != null) {
                LinkedHashMap<String, partitionDesc> pathToPartitionInfo = Utilities.getMapRedWork((Configuration)job).getPathToPartitionInfo();
                Path[] ipaths = inputSplitShim.getPaths();
                for (int i = 0; i < ipaths.length; ++i) {
                    partitionDesc part = null;
                    try {
                        part = CombineHiveInputFormat.getPartitionDescFromPath(pathToPartitionInfo, ipaths[i].getParent());
                    }
                    catch (IOException e) {
                        part = null;
                    }
                    if (part == null) {
                        try {
                            part = CombineHiveInputFormat.getPartitionDescFromPath(pathToPartitionInfo, ipaths[i]);
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("CombineHiveInputSplit unable to find table description for " + ipaths[i].getParent()));
                            continue;
                        }
                    }
                    if (i == 0) {
                        this.inputFormatClassName = part.getInputFileFormatClass().getName();
                        continue;
                    }
                    assert (this.inputFormatClassName.equals(part.getInputFileFormatClass().getName()));
                }
            }
        }

        public HadoopShims.InputSplitShim getInputSplitShim() {
            return this.inputSplitShim;
        }

        public String inputFormatClassName() {
            return this.inputFormatClassName;
        }

        public void setInputFormatClassName(String inputFormatClassName) {
            this.inputFormatClassName = inputFormatClassName;
        }

        @Override
        public JobConf getJob() {
            return this.inputSplitShim.getJob();
        }

        @Override
        public long getLength() {
            return this.inputSplitShim.getLength();
        }

        @Override
        public long[] getStartOffsets() {
            return this.inputSplitShim.getStartOffsets();
        }

        @Override
        public long[] getLengths() {
            return this.inputSplitShim.getLengths();
        }

        @Override
        public long getOffset(int i) {
            return this.inputSplitShim.getOffset(i);
        }

        @Override
        public long getLength(int i) {
            return this.inputSplitShim.getLength(i);
        }

        @Override
        public int getNumPaths() {
            return this.inputSplitShim.getNumPaths();
        }

        @Override
        public Path getPath(int i) {
            return this.inputSplitShim.getPath(i);
        }

        @Override
        public Path[] getPaths() {
            return this.inputSplitShim.getPaths();
        }

        @Override
        public String[] getLocations() throws IOException {
            return this.inputSplitShim.getLocations();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(((Object)this.inputSplitShim).toString());
            sb.append("InputFormatClass: " + this.inputFormatClassName);
            sb.append("\n");
            return sb.toString();
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.inputSplitShim.readFields(in);
            this.inputFormatClassName = in.readUTF();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.inputSplitShim.write(out);
            if (this.inputFormatClassName == null) {
                LinkedHashMap<String, partitionDesc> pathToPartitionInfo = Utilities.getMapRedWork((Configuration)this.getJob()).getPathToPartitionInfo();
                partitionDesc part = null;
                try {
                    part = CombineHiveInputFormat.getPartitionDescFromPath(pathToPartitionInfo, this.inputSplitShim.getPath(0).getParent());
                }
                catch (IOException e) {
                    part = null;
                }
                if (part == null) {
                    part = CombineHiveInputFormat.getPartitionDescFromPath(pathToPartitionInfo, this.inputSplitShim.getPath(0));
                }
                this.inputFormatClassName = part.getInputFileFormatClass().getName();
            }
            out.writeUTF(this.inputFormatClassName);
        }
    }
}

