/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class HiveResultSetMetaData
implements ResultSetMetaData {
    List<String> columnNames;
    List<String> columnTypes;

    public HiveResultSetMetaData(List<String> columnNames, List<String> columnTypes) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        switch (this.getColumnType(column)) {
            case -5: 
            case 12: {
                return 32;
            }
            case -6: {
                return 2;
            }
            case 16: {
                return 8;
            }
            case 4: 
            case 8: {
                return 16;
            }
        }
        return 32;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnNames.get(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames.get(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (this.columnTypes == null) {
            throw new SQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.columnTypes.size()) {
            throw new SQLException("Invalid column value: " + column);
        }
        String type = this.columnTypes.get(column - 1);
        if ("string".equals(type)) {
            return 12;
        }
        if ("bool".equals(type)) {
            return 16;
        }
        if ("double".equals(type)) {
            return 8;
        }
        if ("byte".equals(type)) {
            return -6;
        }
        if ("i32".equals(type)) {
            return 4;
        }
        if ("i64".equals(type)) {
            return -5;
        }
        throw new SQLException("Inrecognized column type: " + type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (this.columnTypes == null) {
            throw new SQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.columnTypes.size()) {
            throw new SQLException("Invalid column value: " + column);
        }
        String type = this.columnTypes.get(column - 1);
        if ("string".equals(type)) {
            return "string";
        }
        if ("double".equals(type)) {
            return "double";
        }
        if ("bool".equals(type)) {
            return "boolean";
        }
        if ("byte".equals(type)) {
            return "tinyint";
        }
        if ("i32".equals(type)) {
            return "int";
        }
        if ("i64".equals(type)) {
            return "bigint";
        }
        throw new SQLException("Inrecognized column type: " + type);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (8 == this.getColumnType(column)) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (8 == this.getColumnType(column)) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

