/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.service;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.plan.api.QueryPlan;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.service.HiveClusterStatus;
import org.apache.hadoop.hive.service.HiveInterface;
import org.apache.hadoop.hive.service.HiveServerException;
import org.apache.hadoop.hive.service.ThriftHive;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class HiveServer
extends ThriftHive {
    private static final String VERSION = "0";

    public static void main(String[] args) {
        try {
            int port = 10000;
            if (args.length >= 1) {
                port = Integer.parseInt(args[0]);
            }
            TServerSocket serverTransport = new TServerSocket(port);
            ThriftHiveProcessorFactory hfactory = new ThriftHiveProcessorFactory(null);
            TThreadPoolServer.Options options = new TThreadPoolServer.Options();
            TThreadPoolServer server = new TThreadPoolServer((TProcessorFactory)hfactory, (TServerTransport)serverTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), options);
            HiveServerHandler.LOG.info((Object)("Starting hive server on port " + port));
            server.serve();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static class ThriftHiveProcessorFactory
    extends TProcessorFactory {
        public ThriftHiveProcessorFactory(TProcessor processor) {
            super(processor);
        }

        public TProcessor getProcessor(TTransport trans) {
            try {
                HiveServerHandler handler = new HiveServerHandler();
                return new ThriftHive.Processor(handler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class HiveServerHandler
    extends HiveMetaStore.HMSHandler
    implements HiveInterface {
        private Driver driver;
        private SessionState session;
        private boolean isHiveQuery = false;
        public static final Log LOG = LogFactory.getLog((String)HiveServer.class.getName());

        public HiveServerHandler() throws MetaException {
            super(HiveServer.class.getName());
            SessionState session = new SessionState(new HiveConf(SessionState.class));
            SessionState.start((SessionState)session);
            session.in = null;
            session.out = null;
            session.err = null;
            this.driver = new Driver();
        }

        @Override
        public void execute(String cmd) throws HiveServerException, TException {
            LOG.info((Object)("Running the query: " + cmd));
            SessionState ss = SessionState.get();
            String cmd_trimmed = cmd.trim();
            String[] tokens = cmd_trimmed.split("\\s");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            int ret = 0;
            String errorMessage = "";
            String SQLState = null;
            try {
                CommandProcessor proc = CommandProcessorFactory.get((String)tokens[0]);
                if (proc != null) {
                    if (proc instanceof Driver) {
                        this.isHiveQuery = true;
                        Driver.DriverResponse response = this.driver.runCommand(cmd);
                        ret = response.getResponseCode();
                        SQLState = response.getSQLState();
                        errorMessage = response.getErrorMessage();
                    } else {
                        this.isHiveQuery = false;
                        ret = proc.run(cmd_1);
                    }
                }
            }
            catch (Exception e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Error running query: " + e.toString());
                throw ex;
            }
            if (ret != 0) {
                throw new HiveServerException("Query returned non-zero code: " + ret + ", cause: " + errorMessage, ret, SQLState);
            }
        }

        @Override
        public HiveClusterStatus getClusterStatus() throws HiveServerException, TException {
            HiveClusterStatus hcs;
            try {
                int state;
                ClusterStatus cs = this.driver.getClusterStatus();
                JobTracker.State jbs = cs.getJobTrackerState();
                switch (jbs) {
                    case INITIALIZING: {
                        state = 1;
                        break;
                    }
                    case RUNNING: {
                        state = 2;
                        break;
                    }
                    default: {
                        String errorMsg = "Unrecognized JobTracker state: " + jbs.toString();
                        throw new Exception(errorMsg);
                    }
                }
                hcs = new HiveClusterStatus(cs.getTaskTrackers(), cs.getMapTasks(), cs.getReduceTasks(), cs.getMaxMapTasks(), cs.getMaxReduceTasks(), state);
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Unable to get cluster status: " + e.toString());
                throw ex;
            }
            return hcs;
        }

        @Override
        public Schema getSchema() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                return new Schema();
            }
            try {
                Schema schema = this.driver.getSchema();
                if (schema == null) {
                    schema = new Schema();
                }
                LOG.info((Object)("Returning schema: " + schema));
                return schema;
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Unable to get schema: " + e.toString());
                throw ex;
            }
        }

        @Override
        public Schema getThriftSchema() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                return new Schema();
            }
            try {
                Schema schema = this.driver.getThriftSchema();
                if (schema == null) {
                    schema = new Schema();
                }
                LOG.info((Object)("Returning schema: " + schema));
                return schema;
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Unable to get schema: " + e.toString());
                throw ex;
            }
        }

        @Override
        public String fetchOne() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                return "";
            }
            Vector result = new Vector();
            this.driver.setMaxRows(1);
            try {
                if (this.driver.getResults(result)) {
                    return (String)result.get(0);
                }
                return "";
            }
            catch (IOException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
        }

        @Override
        public List<String> fetchN(int numRows) throws HiveServerException, TException {
            if (numRows < 0) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Invalid argument for number of rows: " + numRows);
                throw ex;
            }
            if (!this.isHiveQuery) {
                return new Vector<String>();
            }
            Vector<String> result = new Vector<String>();
            this.driver.setMaxRows(numRows);
            try {
                this.driver.getResults(result);
            }
            catch (IOException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
            return result;
        }

        @Override
        public List<String> fetchAll() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                return new Vector<String>();
            }
            Vector<String> rows = new Vector<String>();
            Vector result = new Vector();
            try {
                while (this.driver.getResults(result)) {
                    rows.addAll(result);
                    result.clear();
                }
            }
            catch (IOException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
            return rows;
        }

        public int getStatus() {
            return 0;
        }

        public String getVersion() {
            return HiveServer.VERSION;
        }

        @Override
        public QueryPlan getQueryPlan() throws HiveServerException, TException {
            QueryPlan qp = new QueryPlan();
            try {
                qp.addToQueries(this.driver.getQueryPlan());
            }
            catch (Exception e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.toString());
                throw ex;
            }
            return qp;
        }
    }
}

