/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapRedTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RecordReader;
import org.apache.hadoop.hive.ql.exec.RecordWriter;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMRFileSink1;
import org.apache.hadoop.hive.ql.optimizer.GenMROperator;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink1;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink2;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink3;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink4;
import org.apache.hadoop.hive.ql.optimizer.GenMRTableScan1;
import org.apache.hadoop.hive.ql.optimizer.GenMRUnion1;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.MapJoinFactory;
import org.apache.hadoop.hive.ql.optimizer.Optimizer;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.GenMapRedWalker;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.QBMetaData;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TableSample;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.joinCond;
import org.apache.hadoop.hive.ql.parse.joinType;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.aggregationDesc;
import org.apache.hadoop.hive.ql.plan.createTableDesc;
import org.apache.hadoop.hive.ql.plan.createTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeNullDesc;
import org.apache.hadoop.hive.ql.plan.extractDesc;
import org.apache.hadoop.hive.ql.plan.fetchWork;
import org.apache.hadoop.hive.ql.plan.fileSinkDesc;
import org.apache.hadoop.hive.ql.plan.filterDesc;
import org.apache.hadoop.hive.ql.plan.forwardDesc;
import org.apache.hadoop.hive.ql.plan.groupByDesc;
import org.apache.hadoop.hive.ql.plan.joinDesc;
import org.apache.hadoop.hive.ql.plan.lateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.limitDesc;
import org.apache.hadoop.hive.ql.plan.loadFileDesc;
import org.apache.hadoop.hive.ql.plan.loadTableDesc;
import org.apache.hadoop.hive.ql.plan.mapredWork;
import org.apache.hadoop.hive.ql.plan.moveWork;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.ql.plan.reduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.scriptDesc;
import org.apache.hadoop.hive.ql.plan.selectDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.ql.plan.tableScanDesc;
import org.apache.hadoop.hive.ql.plan.udtfDesc;
import org.apache.hadoop.hive.ql.plan.unionDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public class SemanticAnalyzer
extends BaseSemanticAnalyzer {
    private HashMap<TableScanOperator, exprNodeDesc> opToPartPruner = new HashMap();
    private HashMap<String, Operator<? extends Serializable>> topOps;
    private HashMap<String, Operator<? extends Serializable>> topSelOps;
    private LinkedHashMap<Operator<? extends Serializable>, OpParseContext> opParseCtx;
    private List<loadTableDesc> loadTableWork;
    private List<loadFileDesc> loadFileWork;
    private Map<JoinOperator, QBJoinTree> joinContext;
    private HashMap<TableScanOperator, Table> topToTable;
    private QB qb;
    private ASTNode ast;
    private int destTableId = 1;
    private UnionProcContext uCtx = null;
    List<MapJoinOperator> listMapJoinOpsNoReducer;
    private HashMap<TableScanOperator, filterDesc.sampleDesc> opToSamplePruner = new HashMap();
    Map<GroupByOperator, Set<String>> groupOpToInputTables;
    Map<String, PrunedPartitionList> prunedPartitions;

    public SemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
        this.topOps = new HashMap();
        this.topSelOps = new HashMap();
        this.loadTableWork = new ArrayList<loadTableDesc>();
        this.loadFileWork = new ArrayList<loadFileDesc>();
        this.opParseCtx = new LinkedHashMap();
        this.joinContext = new HashMap<JoinOperator, QBJoinTree>();
        this.topToTable = new HashMap();
        this.listMapJoinOpsNoReducer = new ArrayList<MapJoinOperator>();
        this.groupOpToInputTables = new HashMap<GroupByOperator, Set<String>>();
        this.prunedPartitions = new HashMap<String, PrunedPartitionList>();
    }

    @Override
    protected void reset() {
        super.reset();
        this.loadTableWork.clear();
        this.loadFileWork.clear();
        this.topOps.clear();
        this.topSelOps.clear();
        this.destTableId = 1;
        this.idToTableNameMap.clear();
        this.qb = null;
        this.ast = null;
        this.uCtx = null;
        this.joinContext.clear();
        this.opParseCtx.clear();
        this.groupOpToInputTables.clear();
        this.prunedPartitions.clear();
    }

    public void init(ParseContext pctx) {
        this.opToPartPruner = pctx.getOpToPartPruner();
        this.opToSamplePruner = pctx.getOpToSamplePruner();
        this.topOps = pctx.getTopOps();
        this.topSelOps = pctx.getTopSelOps();
        this.opParseCtx = pctx.getOpParseCtx();
        this.loadTableWork = pctx.getLoadTableWork();
        this.loadFileWork = pctx.getLoadFileWork();
        this.joinContext = pctx.getJoinContext();
        this.ctx = pctx.getContext();
        this.destTableId = pctx.getDestTableId();
        this.idToTableNameMap = pctx.getIdToTableNameMap();
        this.uCtx = pctx.getUCtx();
        this.listMapJoinOpsNoReducer = pctx.getListMapJoinOpsNoReducer();
        this.qb = pctx.getQB();
        this.groupOpToInputTables = pctx.getGroupOpToInputTables();
        this.prunedPartitions = pctx.getPrunedPartitions();
    }

    public ParseContext getParseContext() {
        return new ParseContext(this.conf, this.qb, this.ast, this.opToPartPruner, this.topOps, this.topSelOps, this.opParseCtx, this.joinContext, this.topToTable, this.loadTableWork, this.loadFileWork, this.ctx, this.idToTableNameMap, this.destTableId, this.uCtx, this.listMapJoinOpsNoReducer, this.groupOpToInputTables, this.prunedPartitions, this.opToSamplePruner);
    }

    public void doPhase1QBExpr(ASTNode ast, QBExpr qbexpr, String id, String alias) throws SemanticException {
        assert (ast.getToken() != null);
        switch (ast.getToken().getType()) {
            case 5: {
                QB qb = new QB(id, alias, true);
                this.doPhase1(ast, qb, this.initPhase1Ctx());
                qbexpr.setOpcode(QBExpr.Opcode.NULLOP);
                qbexpr.setQB(qb);
                break;
            }
            case 55: {
                qbexpr.setOpcode(QBExpr.Opcode.UNION);
                assert (ast.getChild(0) != null);
                QBExpr qbexpr1 = new QBExpr(alias + "-subquery1");
                this.doPhase1QBExpr((ASTNode)ast.getChild(0), qbexpr1, id + "-subquery1", alias + "-subquery1");
                qbexpr.setQBExpr1(qbexpr1);
                assert (ast.getChild(0) != null);
                QBExpr qbexpr2 = new QBExpr(alias + "-subquery2");
                this.doPhase1QBExpr((ASTNode)ast.getChild(1), qbexpr2, id + "-subquery2", alias + "-subquery2");
                qbexpr.setQBExpr2(qbexpr2);
            }
        }
    }

    private LinkedHashMap<String, ASTNode> doPhase1GetAggregationsFromSelect(ASTNode selExpr) {
        LinkedHashMap<String, ASTNode> aggregationTrees = new LinkedHashMap<String, ASTNode>();
        for (int i = 0; i < selExpr.getChildCount(); ++i) {
            ASTNode sel = (ASTNode)selExpr.getChild(i).getChild(0);
            this.doPhase1GetAllAggregations(sel, aggregationTrees);
        }
        return aggregationTrees;
    }

    private void doPhase1GetAllAggregations(ASTNode expressionTree, HashMap<String, ASTNode> aggregations) {
        if (expressionTree.getToken().getType() == 20 || expressionTree.getToken().getType() == 21) {
            String functionName;
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(0).getType() == 160 && FunctionRegistry.getGenericUDAFResolver(functionName = SemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText())) != null) {
                aggregations.put(expressionTree.toStringTree(), expressionTree);
                return;
            }
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            this.doPhase1GetAllAggregations((ASTNode)expressionTree.getChild(i), aggregations);
        }
    }

    private ASTNode doPhase1GetDistinctFuncExpr(HashMap<String, ASTNode> aggregationTrees) throws SemanticException {
        ASTNode expr = null;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            assert (value != null);
            if (value.getToken().getType() != 21) continue;
            if (expr == null) {
                expr = value;
                continue;
            }
            throw new SemanticException(ErrorMsg.UNSUPPORTED_MULTIPLE_DISTINCTS.getMsg());
        }
        return expr;
    }

    private String processTable(QB qb, ASTNode tabref) throws SemanticException {
        boolean tableSamplePresent = false;
        int aliasIndex = 0;
        if (tabref.getChildCount() == 2) {
            ASTNode ct = (ASTNode)tabref.getChild(1);
            if (ct.getToken().getType() == 118) {
                tableSamplePresent = true;
            } else {
                aliasIndex = 1;
            }
        } else if (tabref.getChildCount() == 3) {
            aliasIndex = 2;
            tableSamplePresent = true;
        }
        ASTNode tableTree = (ASTNode)tabref.getChild(0);
        String alias = SemanticAnalyzer.unescapeIdentifier(tabref.getChild(aliasIndex).getText());
        if (qb.exists(alias)) {
            throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(tabref.getChild(aliasIndex)));
        }
        if (tableSamplePresent) {
            ASTNode sampleClause = (ASTNode)tabref.getChild(1);
            ArrayList<ASTNode> sampleCols = new ArrayList<ASTNode>();
            if (sampleClause.getChildCount() > 2) {
                for (int i = 2; i < sampleClause.getChildCount(); ++i) {
                    sampleCols.add((ASTNode)sampleClause.getChild(i));
                }
            }
            if (sampleCols.size() > 2) {
                throw new SemanticException(ErrorMsg.SAMPLE_RESTRICTION.getMsg(tabref.getChild(0)));
            }
            qb.getParseInfo().setTabSample(alias, new TableSample(SemanticAnalyzer.unescapeIdentifier(sampleClause.getChild(0).getText()), SemanticAnalyzer.unescapeIdentifier(sampleClause.getChild(1).getText()), sampleCols));
        }
        String table_name = SemanticAnalyzer.unescapeIdentifier(tabref.getChild(0).getText());
        qb.setTabAlias(alias, table_name);
        qb.getParseInfo().setSrcForAlias(alias, tableTree);
        return alias;
    }

    private String processSubQuery(QB qb, ASTNode subq) throws SemanticException {
        if (subq.getChildCount() != 2) {
            throw new SemanticException(ErrorMsg.NO_SUBQUERY_ALIAS.getMsg(subq));
        }
        ASTNode subqref = (ASTNode)subq.getChild(0);
        String alias = SemanticAnalyzer.unescapeIdentifier(subq.getChild(1).getText());
        QBExpr qbexpr = new QBExpr(alias);
        this.doPhase1QBExpr(subqref, qbexpr, qb.getId(), alias);
        if (qb.exists(alias)) {
            throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(subq.getChild(1)));
        }
        qb.setSubqAlias(alias, qbexpr);
        return alias;
    }

    private boolean isJoinToken(ASTNode node) {
        return node.getToken().getType() == 56 || node.getToken().getType() == 57 || node.getToken().getType() == 58 || node.getToken().getType() == 59 || node.getToken().getType() == 142 || node.getToken().getType() == 60;
    }

    private void processJoin(QB qb, ASTNode join) throws SemanticException {
        int numChildren = join.getChildCount();
        if (numChildren != 2 && numChildren != 3 && join.getToken().getType() != 60) {
            throw new SemanticException("Join with multiple children");
        }
        for (int num = 0; num < numChildren; ++num) {
            ASTNode child = (ASTNode)join.getChild(num);
            if (child.getToken().getType() == 15) {
                this.processTable(qb, child);
                continue;
            }
            if (child.getToken().getType() == 16) {
                this.processSubQuery(qb, child);
                continue;
            }
            if (child.getToken().getType() == 143) {
                throw new SemanticException(ErrorMsg.LATERAL_VIEW_WITH_JOIN.getMsg(join));
            }
            if (!this.isJoinToken(child)) continue;
            this.processJoin(qb, child);
        }
    }

    private String processLateralView(QB qb, ASTNode lateralView) throws SemanticException {
        int numChildren = lateralView.getChildCount();
        assert (numChildren == 2);
        ASTNode next = (ASTNode)lateralView.getChild(1);
        String alias = null;
        switch (next.getToken().getType()) {
            case 15: {
                alias = this.processTable(qb, next);
                break;
            }
            case 16: {
                alias = this.processSubQuery(qb, next);
                break;
            }
            case 143: {
                alias = this.processLateralView(qb, next);
                break;
            }
            default: {
                throw new SemanticException(ErrorMsg.LATERAL_VIEW_INVALID_CHILD.getMsg(lateralView));
            }
        }
        qb.getParseInfo().addLateralViewForAlias(alias, lateralView);
        return alias;
    }

    public void doPhase1(ASTNode ast, QB qb, Phase1Ctx ctx_1) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        boolean skipRecursion = false;
        if (ast.getToken() != null) {
            skipRecursion = true;
            switch (ast.getToken().getType()) {
                case 7: {
                    qb.countSelDi();
                }
                case 6: {
                    qb.countSel();
                    qbp.setSelExprForClause(ctx_1.dest, ast);
                    if (((ASTNode)ast.getChild(0)).getToken().getType() == 133) {
                        qbp.setHints((ASTNode)ast.getChild(0));
                    }
                    LinkedHashMap<String, ASTNode> aggregations = this.doPhase1GetAggregationsFromSelect(ast);
                    qbp.setAggregationExprsForClause(ctx_1.dest, aggregations);
                    qbp.setDistinctFuncExprForClause(ctx_1.dest, this.doPhase1GetDistinctFuncExpr(aggregations));
                    break;
                }
                case 22: {
                    qbp.setWhrExprForClause(ctx_1.dest, ast);
                    break;
                }
                case 17: {
                    ASTNode ch;
                    ctx_1.dest = "insclause-" + ctx_1.nextNum;
                    ++ctx_1.nextNum;
                    if (qbp.getIsSubQ() && ((ch = (ASTNode)ast.getChild(0)).getToken().getType() != 13 || ((ASTNode)ch.getChild(0)).getToken().getType() != 119)) {
                        throw new SemanticException(ErrorMsg.NO_INSERT_INSUBQUERY.getMsg(ast));
                    }
                    qbp.setDestForClause(ctx_1.dest, (ASTNode)ast.getChild(0));
                    break;
                }
                case 9: {
                    int child_count = ast.getChildCount();
                    if (child_count != 1) {
                        throw new SemanticException("Multiple Children " + child_count);
                    }
                    ASTNode frm = (ASTNode)ast.getChild(0);
                    if (frm.getToken().getType() == 15) {
                        this.processTable(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 16) {
                        this.processSubQuery(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 143) {
                        this.processLateralView(qb, frm);
                        break;
                    }
                    if (!this.isJoinToken(frm)) break;
                    this.processJoin(qb, frm);
                    qbp.setJoinExpr(frm);
                    break;
                }
                case 52: {
                    qbp.setClusterByExprForClause(ctx_1.dest, ast);
                    break;
                }
                case 53: {
                    qbp.setDistributeByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) != null) {
                        throw new SemanticException(ErrorMsg.CLUSTERBY_DISTRIBUTEBY_CONFLICT.getMsg(ast));
                    }
                    if (qbp.getOrderByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(ErrorMsg.ORDERBY_DISTRIBUTEBY_CONFLICT.getMsg(ast));
                }
                case 54: {
                    qbp.setSortByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) != null) {
                        throw new SemanticException(ErrorMsg.CLUSTERBY_SORTBY_CONFLICT.getMsg(ast));
                    }
                    if (qbp.getOrderByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(ErrorMsg.ORDERBY_SORTBY_CONFLICT.getMsg(ast));
                }
                case 51: {
                    qbp.setOrderByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(ErrorMsg.CLUSTERBY_ORDERBY_CONFLICT.getMsg(ast));
                }
                case 50: {
                    if (qbp.getSelForClause(ctx_1.dest).getToken().getType() == 7) {
                        throw new SemanticException(ErrorMsg.SELECT_DISTINCT_WITH_GROUPBY.getMsg(ast));
                    }
                    qbp.setGroupByExprForClause(ctx_1.dest, ast);
                    skipRecursion = true;
                    break;
                }
                case 130: {
                    qbp.setDestLimit(ctx_1.dest, new Integer(ast.getChild(0).getText()));
                    break;
                }
                case 55: {
                    if (!qbp.getIsSubQ()) {
                        throw new SemanticException(ErrorMsg.UNION_NOTIN_SUBQ.getMsg());
                    }
                }
                default: {
                    skipRecursion = false;
                }
            }
        }
        if (!skipRecursion) {
            int child_count = ast.getChildCount();
            for (int child_pos = 0; child_pos < child_count; ++child_pos) {
                this.doPhase1((ASTNode)ast.getChild(child_pos), qb, ctx_1);
            }
        }
    }

    private void getMetaData(QBExpr qbexpr) throws SemanticException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            this.getMetaData(qbexpr.getQB());
        } else {
            this.getMetaData(qbexpr.getQBExpr1());
            this.getMetaData(qbexpr.getQBExpr2());
        }
    }

    public void getMetaData(QB qb) throws SemanticException {
        try {
            this.LOG.info((Object)"Get metadata for source tables");
            for (String alias : qb.getTabAliases()) {
                String tab_name = qb.getTabNameForAlias(alias);
                Table tab = null;
                try {
                    tab = this.db.getTable("default", tab_name);
                }
                catch (InvalidTableException ite) {
                    throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(qb.getParseInfo().getSrcForAlias(alias)));
                }
                if (!InputFormat.class.isAssignableFrom(tab.getInputFormatClass())) {
                    throw new SemanticException(ErrorMsg.INVALID_INPUT_FORMAT_TYPE.getMsg(qb.getParseInfo().getSrcForAlias(alias)));
                }
                qb.getMetaData().setSrcForAlias(alias, tab);
            }
            this.LOG.info((Object)"Get metadata for subqueries");
            for (String alias : qb.getSubqAliases()) {
                QBExpr qbexpr = qb.getSubqForAlias(alias);
                this.getMetaData(qbexpr);
            }
            this.LOG.info((Object)"Get metadata for destination tables");
            QBParseInfo qbp = qb.getParseInfo();
            block10: for (String name : qbp.getClauseNamesForDest()) {
                ASTNode ast = qbp.getDestForClause(name);
                switch (ast.getToken().getType()) {
                    case 10: {
                        BaseSemanticAnalyzer.tableSpec ts = new BaseSemanticAnalyzer.tableSpec(this.db, this.conf, ast);
                        if (!HiveOutputFormat.class.isAssignableFrom(ts.tableHandle.getOutputFormatClass())) {
                            throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg(ast));
                        }
                        if (ts.partSpec == null) {
                            qb.getMetaData().setDestForAlias(name, ts.tableHandle);
                            continue block10;
                        }
                        qb.getMetaData().setDestForAlias(name, ts.partHandle);
                        continue block10;
                    }
                    case 13: 
                    case 14: {
                        String fname = SemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
                        if (!qb.getParseInfo().getIsSubQ() && ((ASTNode)ast.getChild(0)).getToken().getType() == 119) {
                            fname = this.ctx.getMRTmpFileURI();
                            this.ctx.setResDir(new Path(fname));
                            if (qb.isCTAS()) {
                                qb.setIsQuery(false);
                            } else {
                                qb.setIsQuery(true);
                            }
                        }
                        qb.getMetaData().setDestForAlias(name, fname, ast.getToken().getType() == 13);
                        continue block10;
                    }
                }
                throw new SemanticException("Unknown Token Type " + ast.getToken().getType());
            }
        }
        catch (HiveException e) {
            this.LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private boolean isPresent(String[] list, String elem) {
        for (String s : list) {
            if (!s.equals(elem)) continue;
            return true;
        }
        return false;
    }

    private void parseJoinCondPopulateAlias(QBJoinTree joinTree, ASTNode condn, Vector<String> leftAliases, Vector<String> rightAliases, ArrayList<String> fields) throws SemanticException {
        switch (condn.getToken().getType()) {
            case 19: {
                String tableOrCol = SemanticAnalyzer.unescapeIdentifier(condn.getChild(0).getText().toLowerCase());
                if (this.isPresent(joinTree.getLeftAliases(), tableOrCol)) {
                    if (leftAliases.contains(tableOrCol)) break;
                    leftAliases.add(tableOrCol);
                    break;
                }
                if (this.isPresent(joinTree.getRightAliases(), tableOrCol)) {
                    if (rightAliases.contains(tableOrCol)) break;
                    rightAliases.add(tableOrCol);
                    break;
                }
                throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(condn.getChild(0)));
            }
            case 160: {
                if (fields == null) break;
                fields.add(SemanticAnalyzer.unescapeIdentifier(condn.getToken().getText().toLowerCase()));
                break;
            }
            case 122: 
            case 151: 
            case 209: 
            case 306: 
            case 307: {
                break;
            }
            case 20: {
                for (int i = 1; i < condn.getChildCount(); ++i) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(i), leftAliases, rightAliases, null);
                }
                break;
            }
            default: {
                if (condn.getChildCount() == 1) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null);
                    break;
                }
                if (condn.getChildCount() == 2) {
                    ArrayList<String> fields1 = null;
                    if (!joinTree.getNoSemiJoin() && condn.getToken().getType() == 190) {
                        fields1 = new ArrayList<String>();
                        int rhssize = rightAliases.size();
                        this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null);
                        String rhsAlias = null;
                        if (rightAliases.size() > rhssize) {
                            rhsAlias = rightAliases.get(rightAliases.size() - 1);
                        }
                        this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(1), leftAliases, rightAliases, fields1);
                        if (rhsAlias == null || fields1.size() <= 0) break;
                        joinTree.addRHSSemijoinColumns(rhsAlias, condn);
                        break;
                    }
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null);
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(1), leftAliases, rightAliases, fields1);
                    break;
                }
                throw new SemanticException(condn.toStringTree() + " encountered with " + condn.getChildCount() + " children");
            }
        }
    }

    private void populateAliases(Vector<String> leftAliases, Vector<String> rightAliases, ASTNode condn, QBJoinTree joinTree, Vector<String> leftSrc) throws SemanticException {
        if (leftAliases.size() != 0 && rightAliases.size() != 0) {
            throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_1.getMsg(condn));
        }
        if (rightAliases.size() != 0) {
            assert (rightAliases.size() == 1);
            joinTree.getExpressions().get(1).add(condn);
        } else if (leftAliases.size() != 0) {
            joinTree.getExpressions().get(0).add(condn);
            for (String s : leftAliases) {
                if (leftSrc.contains(s)) continue;
                leftSrc.add(s);
            }
        } else {
            throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_2.getMsg(condn));
        }
    }

    private void parseJoinCondition(QBJoinTree joinTree, ASTNode joinCond2, Vector<String> leftSrc) throws SemanticException {
        if (joinCond2 == null) {
            return;
        }
        switch (joinCond2.getToken().getType()) {
            case 305: {
                throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_3.getMsg(joinCond2));
            }
            case 304: {
                this.parseJoinCondition(joinTree, (ASTNode)joinCond2.getChild(0), leftSrc);
                this.parseJoinCondition(joinTree, (ASTNode)joinCond2.getChild(1), leftSrc);
                break;
            }
            case 216: {
                ASTNode leftCondn = (ASTNode)joinCond2.getChild(0);
                Vector<String> leftCondAl1 = new Vector<String>();
                Vector<String> leftCondAl2 = new Vector<String>();
                this.parseJoinCondPopulateAlias(joinTree, leftCondn, leftCondAl1, leftCondAl2, null);
                ASTNode rightCondn = (ASTNode)joinCond2.getChild(1);
                Vector<String> rightCondAl1 = new Vector<String>();
                Vector<String> rightCondAl2 = new Vector<String>();
                this.parseJoinCondPopulateAlias(joinTree, rightCondn, rightCondAl1, rightCondAl2, null);
                if (leftCondAl1.size() != 0 && leftCondAl2.size() != 0 || rightCondAl1.size() != 0 && rightCondAl2.size() != 0) {
                    throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_1.getMsg(joinCond2));
                }
                if (leftCondAl1.size() != 0) {
                    if (rightCondAl1.size() != 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                        joinTree.getFilters().get(0).add(joinCond2);
                        break;
                    }
                    if (rightCondAl2.size() == 0) break;
                    this.populateAliases(leftCondAl1, leftCondAl2, leftCondn, joinTree, leftSrc);
                    this.populateAliases(rightCondAl1, rightCondAl2, rightCondn, joinTree, leftSrc);
                    break;
                }
                if (leftCondAl2.size() != 0) {
                    if (rightCondAl2.size() != 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                        joinTree.getFilters().get(1).add(joinCond2);
                        break;
                    }
                    if (rightCondAl1.size() == 0) break;
                    this.populateAliases(leftCondAl1, leftCondAl2, leftCondn, joinTree, leftSrc);
                    this.populateAliases(rightCondAl1, rightCondAl2, rightCondn, joinTree, leftSrc);
                    break;
                }
                if (rightCondAl1.size() != 0) {
                    joinTree.getFilters().get(0).add(joinCond2);
                    break;
                }
                joinTree.getFilters().get(1).add(joinCond2);
                break;
            }
            default: {
                int ci;
                boolean isFunction = joinCond2.getType() == 20;
                int childrenBegin = isFunction ? 1 : 0;
                ArrayList leftAlias = new ArrayList(joinCond2.getChildCount() - childrenBegin);
                ArrayList rightAlias = new ArrayList(joinCond2.getChildCount() - childrenBegin);
                for (ci = 0; ci < joinCond2.getChildCount() - childrenBegin; ++ci) {
                    Vector left = new Vector();
                    Vector vector = new Vector();
                    leftAlias.add(left);
                    rightAlias.add(vector);
                }
                for (ci = childrenBegin; ci < joinCond2.getChildCount(); ++ci) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)joinCond2.getChild(ci), (Vector)leftAlias.get(ci - childrenBegin), (Vector)rightAlias.get(ci - childrenBegin), null);
                }
                boolean leftAliasNull = true;
                for (Vector vector : leftAlias) {
                    if (vector.size() == 0) continue;
                    leftAliasNull = false;
                    break;
                }
                boolean rightAliasNull = true;
                for (Vector vector : rightAlias) {
                    if (vector.size() == 0) continue;
                    rightAliasNull = false;
                    break;
                }
                if (!leftAliasNull && !rightAliasNull) {
                    throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_1.getMsg(joinCond2));
                }
                if (!leftAliasNull) {
                    joinTree.getFilters().get(0).add(joinCond2);
                    break;
                }
                joinTree.getFilters().get(1).add(joinCond2);
            }
        }
    }

    public <T extends Serializable> Operator<T> putOpInsertMap(Operator<T> op, RowResolver rr) {
        OpParseContext ctx = new OpParseContext(rr);
        this.opParseCtx.put(op, ctx);
        return op;
    }

    private Operator genFilterPlan(String dest, QB qb, Operator input) throws SemanticException {
        ASTNode whereExpr = qb.getParseInfo().getWhrForClause(dest);
        return this.genFilterPlan(qb, (ASTNode)whereExpr.getChild(0), input);
    }

    private Operator genFilterPlan(QB qb, ASTNode condn, Operator input) throws SemanticException {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRR();
        Operator<filterDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new filterDesc(this.genExprNodeDesc(condn, inputRR), false), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        this.LOG.debug((Object)("Created Filter Plan for " + qb.getId() + " row schema: " + inputRR.toString()));
        return output;
    }

    private Integer genColListRegex(String colRegex, String tabAlias, String alias, ASTNode sel, ArrayList<exprNodeDesc> col_list, RowResolver input, Integer pos, RowResolver output) throws SemanticException {
        if (tabAlias != null && !input.hasTableAlias(tabAlias)) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(sel));
        }
        Pattern regex = null;
        try {
            regex = Pattern.compile(colRegex, 2);
        }
        catch (PatternSyntaxException e) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(sel, e.getMessage()));
        }
        int matched = 0;
        for (ColumnInfo colInfo : input.getColumnInfos()) {
            String name = colInfo.getInternalName();
            String[] tmp = input.reverseLookup(name);
            if (tabAlias != null && !tmp[0].equalsIgnoreCase(tabAlias) || !regex.matcher(tmp[1]).matches()) continue;
            exprNodeColumnDesc expr = new exprNodeColumnDesc(colInfo.getType(), name, colInfo.getTabAlias(), colInfo.getIsPartitionCol());
            col_list.add(expr);
            output.put(tmp[0], tmp[1], new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsPartitionCol()));
            pos = pos + 1;
            ++matched;
        }
        if (matched == 0) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(sel));
        }
        return pos;
    }

    public static String getColumnInternalName(int pos) {
        return HiveConf.getColumnInternalName(pos);
    }

    private String getFixedCmd(String cmd) {
        Set<String> files;
        SessionState ss = SessionState.get();
        if (ss == null) {
            return cmd;
        }
        if (ss.getConf().get("mapred.job.tracker", "local").equals("local") && (files = ss.list_resource(SessionState.ResourceType.FILE, null)) != null && !files.isEmpty()) {
            int end = cmd.indexOf(" ");
            String prog = end == -1 ? cmd : cmd.substring(0, end);
            String args = end == -1 ? "" : cmd.substring(end, cmd.length());
            for (String oneFile : files) {
                Path p = new Path(oneFile);
                if (!p.getName().equals(prog)) continue;
                cmd = oneFile + args;
                break;
            }
        }
        return cmd;
    }

    private tableDesc getTableDescFromSerDe(ASTNode child, String cols, String colTypes, boolean defaultCols) throws SemanticException {
        if (child.getType() == 46) {
            String serdeName = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
            Class<?> serdeClass = null;
            try {
                serdeClass = Class.forName(serdeName, true, JavaUtils.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new SemanticException(e);
            }
            tableDesc tblDesc = PlanUtils.getTableDesc(serdeClass, Integer.toString(9), cols, colTypes, defaultCols, true);
            if (child.getChildCount() == 2) {
                ASTNode prop = (ASTNode)((ASTNode)child.getChild(1)).getChild(0);
                for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
                    String key = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
                    String value = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
                    tblDesc.getProperties().setProperty(key, value);
                }
            }
            return tblDesc;
        }
        if (child.getType() == 47) {
            tableDesc tblDesc = PlanUtils.getDefaultTableDesc(Integer.toString(1), cols, colTypes, defaultCols);
            int numChildRowFormat = child.getChildCount();
            block9: for (int numC = 0; numC < numChildRowFormat; ++numC) {
                ASTNode rowChild = (ASTNode)child.getChild(numC);
                switch (rowChild.getToken().getType()) {
                    case 106: {
                        String fieldDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("field.delim", fieldDelim);
                        tblDesc.getProperties().setProperty("serialization.format", fieldDelim);
                        if (rowChild.getChildCount() < 2) continue block9;
                        String fieldEscape = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(1).getText());
                        tblDesc.getProperties().setProperty("escape.delim", fieldEscape);
                        continue block9;
                    }
                    case 107: {
                        tblDesc.getProperties().setProperty("colelction.delim", SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText()));
                        continue block9;
                    }
                    case 108: {
                        tblDesc.getProperties().setProperty("mapkey.delim", SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText()));
                        continue block9;
                    }
                    case 109: {
                        String lineDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("line.delim", lineDelim);
                        if (lineDelim.equals("\n") || lineDelim.equals("10")) continue block9;
                        throw new SemanticException(ErrorMsg.LINES_TERMINATED_BY_NON_NEWLINE.getMsg());
                    }
                    default: {
                        assert (false);
                        continue block9;
                    }
                }
            }
            return tblDesc;
        }
        return null;
    }

    private void failIfColAliasExists(Set<String> nameSet, String name) throws SemanticException {
        if (nameSet.contains(name)) {
            throw new SemanticException(ErrorMsg.COLUMN_ALIAS_ALREADY_EXISTS.getMsg(name));
        }
        nameSet.add(name);
    }

    private Operator genScriptPlan(ASTNode trfm, QB qb, Operator input) throws SemanticException {
        Class<?> serde;
        int i;
        ArrayList<ColumnInfo> outputCols = new ArrayList<ColumnInfo>();
        int inputSerDeNum = 1;
        int inputRecordWriterNum = 2;
        int outputSerDeNum = 4;
        int outputRecordReaderNum = 5;
        int outputColsNum = 6;
        boolean outputColNames = false;
        boolean outputColSchemas = false;
        int execPos = 3;
        boolean defaultOutputCols = false;
        if (trfm.getChildCount() > outputColsNum) {
            ASTNode outCols = (ASTNode)trfm.getChild(outputColsNum);
            if (outCols.getType() == 49) {
                outputColNames = true;
            } else if (outCols.getType() == 100) {
                outputColSchemas = true;
            }
        }
        if (!outputColNames && !outputColSchemas) {
            String intName = SemanticAnalyzer.getColumnInternalName(0);
            ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoFactory.stringTypeInfo, null, false);
            colInfo.setAlias("key");
            outputCols.add(colInfo);
            intName = SemanticAnalyzer.getColumnInternalName(1);
            colInfo = new ColumnInfo(intName, TypeInfoFactory.stringTypeInfo, null, false);
            colInfo.setAlias("value");
            outputCols.add(colInfo);
            defaultOutputCols = true;
        } else {
            ASTNode collist = (ASTNode)trfm.getChild(outputColsNum);
            int ccount = collist.getChildCount();
            HashSet<String> colAliasNamesDuplicateCheck = new HashSet<String>();
            if (outputColNames) {
                for (i = 0; i < ccount; ++i) {
                    String colAlias = SemanticAnalyzer.unescapeIdentifier(((ASTNode)collist.getChild(i)).getText());
                    this.failIfColAliasExists(colAliasNamesDuplicateCheck, colAlias);
                    String intName = SemanticAnalyzer.getColumnInternalName(i);
                    ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoFactory.stringTypeInfo, null, false);
                    colInfo.setAlias(colAlias);
                    outputCols.add(colInfo);
                }
            } else {
                for (i = 0; i < ccount; ++i) {
                    ASTNode child = (ASTNode)collist.getChild(i);
                    assert (child.getType() == 101);
                    String colAlias = SemanticAnalyzer.unescapeIdentifier(((ASTNode)child.getChild(0)).getText());
                    this.failIfColAliasExists(colAliasNamesDuplicateCheck, colAlias);
                    String intName = SemanticAnalyzer.getColumnInternalName(i);
                    ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoUtils.getTypeInfoFromTypeString(SemanticAnalyzer.getTypeStringFromAST((ASTNode)child.getChild(1))), null, false);
                    colInfo.setAlias(colAlias);
                    outputCols.add(colInfo);
                }
            }
        }
        RowResolver out_rwsch = new RowResolver();
        StringBuilder columns = new StringBuilder();
        StringBuilder columnTypes = new StringBuilder();
        for (i = 0; i < outputCols.size(); ++i) {
            if (i != 0) {
                columns.append(",");
                columnTypes.append(",");
            }
            columns.append(((ColumnInfo)outputCols.get(i)).getInternalName());
            columnTypes.append(((ColumnInfo)outputCols.get(i)).getType().getTypeName());
            out_rwsch.put(qb.getParseInfo().getAlias(), ((ColumnInfo)outputCols.get(i)).getAlias(), (ColumnInfo)outputCols.get(i));
        }
        StringBuilder inpColumns = new StringBuilder();
        StringBuilder inpColumnTypes = new StringBuilder();
        Vector<ColumnInfo> inputSchema = this.opParseCtx.get(input).getRR().getColumnInfos();
        for (int i2 = 0; i2 < inputSchema.size(); ++i2) {
            if (i2 != 0) {
                inpColumns.append(",");
                inpColumnTypes.append(",");
            }
            inpColumns.append(inputSchema.get(i2).getInternalName());
            inpColumnTypes.append(inputSchema.get(i2).getType().getTypeName());
        }
        String defaultSerdeName = this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTSERDE);
        try {
            serde = Class.forName(defaultSerdeName, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
        tableDesc inInfo = trfm.getChild(inputSerDeNum).getChildCount() > 0 ? this.getTableDescFromSerDe((ASTNode)((ASTNode)trfm.getChild(inputSerDeNum)).getChild(0), inpColumns.toString(), inpColumnTypes.toString(), false) : PlanUtils.getTableDesc(serde, Integer.toString(9), inpColumns.toString(), inpColumnTypes.toString(), false, true);
        tableDesc outInfo = trfm.getChild(outputSerDeNum).getChildCount() > 0 ? this.getTableDescFromSerDe((ASTNode)((ASTNode)trfm.getChild(outputSerDeNum)).getChild(0), columns.toString(), columnTypes.toString(), false) : PlanUtils.getTableDesc(serde, Integer.toString(9), columns.toString(), columnTypes.toString(), defaultOutputCols);
        Class<? extends RecordReader> outRecordReader = this.getRecordReader((ASTNode)trfm.getChild(outputRecordReaderNum));
        Class<? extends RecordWriter> inRecordWriter = this.getRecordWriter((ASTNode)trfm.getChild(inputRecordWriterNum));
        Operator<scriptDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new scriptDesc(this.getFixedCmd(SemanticAnalyzer.stripQuotes(trfm.getChild(execPos).getText())), inInfo, inRecordWriter, outInfo, outRecordReader), new RowSchema(out_rwsch.getColumnInfos()), input), out_rwsch);
        return output;
    }

    private Class<? extends RecordReader> getRecordReader(ASTNode node) throws SemanticException {
        String name = node.getChildCount() == 0 ? this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTRECORDREADER) : SemanticAnalyzer.unescapeSQLString(node.getChild(0).getText());
        try {
            return Class.forName(name, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
    }

    private Class<? extends RecordWriter> getRecordWriter(ASTNode node) throws SemanticException {
        String name = node.getChildCount() == 0 ? this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTRECORDWRITER) : SemanticAnalyzer.unescapeSQLString(node.getChild(0).getText());
        try {
            return Class.forName(name, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
    }

    static List<ASTNode> getGroupByForClause(QBParseInfo parseInfo, String dest) {
        if (parseInfo.getSelForClause(dest).getToken().getType() == 7) {
            ASTNode selectExprs = parseInfo.getSelForClause(dest);
            ArrayList<ASTNode> result = new ArrayList<ASTNode>(selectExprs == null ? 0 : selectExprs.getChildCount());
            if (selectExprs != null) {
                for (int i = 0; i < selectExprs.getChildCount(); ++i) {
                    ASTNode grpbyExpr = (ASTNode)selectExprs.getChild(i).getChild(0);
                    result.add(grpbyExpr);
                }
            }
            return result;
        }
        ASTNode grpByExprs = parseInfo.getGroupByForClause(dest);
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(grpByExprs == null ? 0 : grpByExprs.getChildCount());
        if (grpByExprs != null) {
            for (int i = 0; i < grpByExprs.getChildCount(); ++i) {
                ASTNode grpbyExpr = (ASTNode)grpByExprs.getChild(i);
                result.add(grpbyExpr);
            }
        }
        return result;
    }

    private static String[] getColAlias(ASTNode selExpr, String defaultName, RowResolver inputRR) {
        String colAlias = null;
        String tabAlias = null;
        String[] colRef = new String[2];
        if (selExpr.getChildCount() == 2) {
            colAlias = SemanticAnalyzer.unescapeIdentifier(selExpr.getChild(1).getText());
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        ASTNode root = (ASTNode)selExpr.getChild(0);
        if (root.getType() == 19) {
            colAlias = root.getChild(0).getText();
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        if (root.getType() == 190) {
            ASTNode col;
            String t;
            ASTNode tab = (ASTNode)root.getChild(0);
            if (tab.getType() == 19 && inputRR.hasTableAlias(t = SemanticAnalyzer.unescapeIdentifier(tab.getChild(0).getText()))) {
                tabAlias = t;
            }
            if ((col = (ASTNode)root.getChild(1)).getType() == 160) {
                colAlias = SemanticAnalyzer.unescapeIdentifier(col.getText());
            }
        }
        if (colAlias == null) {
            colAlias = defaultName;
        }
        colRef[0] = tabAlias;
        colRef[1] = colAlias;
        return colRef;
    }

    private static boolean isRegex(String pattern) {
        for (int i = 0; i < pattern.length(); ++i) {
            if (Character.isLetterOrDigit(pattern.charAt(i)) || pattern.charAt(i) == '_') continue;
            return true;
        }
        return false;
    }

    private Operator<?> genSelectPlan(String dest, QB qb, Operator<?> input) throws SemanticException {
        ASTNode selExprList = qb.getParseInfo().getSelForClause(dest);
        Operator<?> op = this.genSelectPlan(selExprList, qb, input);
        this.LOG.debug((Object)("Created Select Plan for clause: " + dest));
        return op;
    }

    private Operator<?> genSelectPlan(ASTNode selExprList, QB qb, Operator<?> input) throws SemanticException {
        int startPosn;
        boolean isInTransform;
        boolean hintPresent;
        this.LOG.debug((Object)("tree: " + selExprList.toStringTree()));
        ArrayList<exprNodeDesc> col_list = new ArrayList<exprNodeDesc>();
        RowResolver out_rwsch = new RowResolver();
        ASTNode trfm = null;
        String alias = qb.getParseInfo().getAlias();
        Integer pos = 0;
        RowResolver inputRR = this.opParseCtx.get(input).getRR();
        boolean selectStar = false;
        int posn = 0;
        boolean bl = hintPresent = selExprList.getChild(0).getType() == 133;
        if (hintPresent) {
            ++posn;
        }
        boolean bl2 = isInTransform = selExprList.getChild(posn).getChild(0).getType() == 44;
        if (isInTransform) {
            trfm = (ASTNode)selExprList.getChild(posn).getChild(0);
        }
        boolean isUDTF = false;
        String udtfTableAlias = null;
        ArrayList<String> udtfColAliases = new ArrayList<String>();
        ASTNode udtfExpr = (ASTNode)selExprList.getChild(posn).getChild(0);
        GenericUDTF genericUDTF = null;
        if (udtfExpr.getType() == 20) {
            String funcName = TypeCheckProcFactory.DefaultExprProcessor.getFunctionText(udtfExpr, true);
            FunctionInfo fi = FunctionRegistry.getFunctionInfo(funcName);
            if (fi != null) {
                genericUDTF = fi.getGenericUDTF();
            }
            boolean bl3 = isUDTF = genericUDTF != null;
        }
        if (isUDTF) {
            if (selExprList.getChildCount() > 1) {
                throw new SemanticException(ErrorMsg.UDTF_MULTIPLE_EXPR.getMsg());
            }
            ASTNode selExpr = (ASTNode)selExprList.getChild(posn);
            if (selExpr.getChildCount() < 2) {
                throw new SemanticException(ErrorMsg.UDTF_REQUIRE_AS.getMsg());
            }
            block4: for (int i = 1; i < selExpr.getChildCount(); ++i) {
                ASTNode selExprChild = (ASTNode)selExpr.getChild(i);
                switch (selExprChild.getType()) {
                    case 160: {
                        udtfColAliases.add(SemanticAnalyzer.unescapeIdentifier(selExprChild.getText()));
                        continue block4;
                    }
                    case 144: {
                        assert (selExprChild.getChildCount() == 1);
                        udtfTableAlias = SemanticAnalyzer.unescapeIdentifier(selExprChild.getChild(0).getText());
                        continue block4;
                    }
                    default: {
                        assert (false);
                        continue block4;
                    }
                }
            }
            this.LOG.debug((Object)("UDTF table alias is " + udtfTableAlias));
            this.LOG.debug((Object)("UDTF col aliases are " + udtfColAliases));
        }
        ASTNode exprList = isInTransform ? (ASTNode)trfm.getChild(0) : (isUDTF ? udtfExpr : selExprList);
        this.LOG.debug((Object)("genSelectPlan: input = " + inputRR.toString()));
        for (int i = startPosn = isUDTF ? posn + 1 : posn; i < exprList.getChildCount(); ++i) {
            ASTNode expr;
            String colAlias;
            String tabAlias;
            boolean hasAsClause;
            ASTNode child = (ASTNode)exprList.getChild(i);
            boolean bl4 = hasAsClause = !isInTransform && child.getChildCount() == 2;
            if (!isInTransform && !isUDTF && child.getChildCount() > 2) {
                throw new SemanticException(ErrorMsg.INVALID_AS.getMsg());
            }
            if (isInTransform || isUDTF) {
                tabAlias = null;
                colAlias = "_C" + i;
                expr = child;
            } else {
                String[] colRef = SemanticAnalyzer.getColAlias(child, "_C" + i, inputRR);
                tabAlias = colRef[0];
                colAlias = colRef[1];
                expr = (ASTNode)child.getChild(0);
            }
            if (expr.getType() == 18) {
                pos = this.genColListRegex(".*", expr.getChildCount() == 0 ? null : SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText().toLowerCase()), alias, expr, col_list, inputRR, pos, out_rwsch);
                selectStar = true;
                continue;
            }
            if (expr.getType() == 19 && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()))) {
                pos = this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), null, alias, expr, col_list, inputRR, pos, out_rwsch);
                continue;
            }
            if (expr.getType() == 190 && expr.getChild(0).getType() == 19 && inputRR.hasTableAlias(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase())) && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()))) {
                pos = this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase()), alias, expr, col_list, inputRR, pos, out_rwsch);
                continue;
            }
            exprNodeDesc exp = this.genExprNodeDesc(expr, inputRR);
            col_list.add(exp);
            if (!StringUtils.isEmpty(alias) && out_rwsch.get(null, colAlias) != null) {
                throw new SemanticException(ErrorMsg.AMBIGUOUS_COLUMN.getMsg(expr.getChild(1)));
            }
            out_rwsch.put(tabAlias, colAlias, new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), exp.getTypeInfo(), tabAlias, false));
            pos = pos + 1;
        }
        selectStar = selectStar && exprList.getChildCount() == posn + 1;
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        for (int i = 0; i < col_list.size(); ++i) {
            if (col_list.get(i) instanceof exprNodeNullDesc) {
                col_list.set(i, new exprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, null));
            }
            String outputCol = SemanticAnalyzer.getColumnInternalName(i);
            colExprMap.put(outputCol, col_list.get(i));
            columnNames.add(outputCol);
        }
        Operator output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new selectDesc(col_list, columnNames, selectStar), new RowSchema(out_rwsch.getColumnInfos()), input), out_rwsch);
        output.setColumnExprMap(colExprMap);
        if (isInTransform) {
            output = this.genScriptPlan(trfm, qb, output);
        }
        if (isUDTF) {
            output = this.genUDTFPlan(genericUDTF, udtfTableAlias, udtfColAliases, qb, output);
        }
        this.LOG.debug((Object)("Created Select Plan row schema: " + out_rwsch.toString()));
        return output;
    }

    static ArrayList<TypeInfo> getTypeInfo(ArrayList<exprNodeDesc> exprs) {
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        for (exprNodeDesc expr : exprs) {
            result.add(expr.getTypeInfo());
        }
        return result;
    }

    static ObjectInspector[] getStandardObjectInspector(ArrayList<TypeInfo> exprs) {
        ObjectInspector[] result = new ObjectInspector[exprs.size()];
        for (int i = 0; i < exprs.size(); ++i) {
            result[i] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(exprs.get(i));
        }
        return result;
    }

    static GenericUDAFEvaluator getGenericUDAFEvaluator(String aggName, ArrayList<exprNodeDesc> aggParameters, ASTNode aggTree) throws SemanticException {
        ArrayList<TypeInfo> originalParameterTypeInfos = SemanticAnalyzer.getTypeInfo(aggParameters);
        GenericUDAFEvaluator result = FunctionRegistry.getGenericUDAFEvaluator(aggName, originalParameterTypeInfos);
        if (null == result) {
            String reason = "Looking for UDAF Evaluator\"" + aggName + "\" with parameters " + originalParameterTypeInfos;
            throw new SemanticException(ErrorMsg.INVALID_FUNCTION_SIGNATURE.getMsg((ASTNode)aggTree.getChild(0), reason));
        }
        return result;
    }

    static GenericUDAFInfo getGenericUDAFInfo(GenericUDAFEvaluator evaluator, GenericUDAFEvaluator.Mode emode, ArrayList<exprNodeDesc> aggParameters) throws SemanticException {
        GenericUDAFInfo r = new GenericUDAFInfo();
        r.genericUDAFEvaluator = evaluator;
        ObjectInspector returnOI = null;
        try {
            ObjectInspector[] aggObjectInspectors = SemanticAnalyzer.getStandardObjectInspector(SemanticAnalyzer.getTypeInfo(aggParameters));
            returnOI = r.genericUDAFEvaluator.init(emode, aggObjectInspectors);
            r.returnType = TypeInfoUtils.getTypeInfoFromObjectInspector(returnOI);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        r.convertedParameters = aggParameters;
        return r;
    }

    private static GenericUDAFEvaluator.Mode groupByDescModeToUDAFMode(groupByDesc.Mode mode, boolean isDistinct) {
        switch (mode) {
            case COMPLETE: {
                return GenericUDAFEvaluator.Mode.COMPLETE;
            }
            case PARTIAL1: {
                return GenericUDAFEvaluator.Mode.PARTIAL1;
            }
            case PARTIAL2: {
                return GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case PARTIALS: {
                return isDistinct ? GenericUDAFEvaluator.Mode.PARTIAL1 : GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case FINAL: {
                return GenericUDAFEvaluator.Mode.FINAL;
            }
            case HASH: {
                return GenericUDAFEvaluator.Mode.PARTIAL1;
            }
            case MERGEPARTIAL: {
                return isDistinct ? GenericUDAFEvaluator.Mode.COMPLETE : GenericUDAFEvaluator.Mode.FINAL;
            }
        }
        throw new RuntimeException("internal error in groupByDescModeToUDAFMode");
    }

    private Operator genGroupByPlanGroupByOperator(QBParseInfo parseInfo, String dest, Operator reduceSinkOperatorInfo, groupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(reduceSinkOperatorInfo).getRR();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<exprNodeDesc> groupByKeys = new ArrayList<exprNodeDesc>();
        ArrayList<aggregationDesc> aggregations = new ArrayList<aggregationDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            String text = grpbyExpr.toStringTree();
            ColumnInfo exprInfo = groupByInputRowResolver.get("", text);
            if (exprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(grpbyExpr));
            }
            groupByKeys.add(new exprNodeColumnDesc(exprInfo.getType(), exprInfo.getInternalName(), "", false));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            groupByOutputRowResolver.put("", grpbyExpr.toStringTree(), new ColumnInfo(field, exprInfo.getType(), null, false));
            colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        assert (aggregationTrees != null);
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            String aggName = value.getChild(0).getText();
            ArrayList<exprNodeDesc> aggParameters = new ArrayList<exprNodeDesc>();
            for (int i = 1; i < value.getChildCount(); ++i) {
                String text = value.getChild(i).toStringTree();
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                ColumnInfo paraExprInfo = groupByInputRowResolver.get("", text);
                if (paraExprInfo == null) {
                    throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(paraExpr));
                }
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                aggParameters.add(new exprNodeColumnDesc(paraExprInfo.getType(), paraExprInfo.getInternalName(), paraExprInfo.getTabAlias(), paraExprInfo.getIsPartitionCol()));
            }
            boolean isDistinct = value.getType() == 21;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value);
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new aggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.put("", value.toStringTree(), new ColumnInfo(field, udaf.returnType, "", false));
            if (genericUDAFEvaluators == null) continue;
            genericUDAFEvaluators.put(entry.getKey(), genericUDAFEvaluator);
        }
        Operator<groupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new groupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false), new RowSchema(groupByOutputRowResolver.getColumnInfos()), reduceSinkOperatorInfo), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private Operator genGroupByPlanGroupByOperator1(QBParseInfo parseInfo, String dest, Operator reduceSinkOperatorInfo, groupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, boolean distPartAgg) throws SemanticException {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        RowResolver groupByInputRowResolver = this.opParseCtx.get(reduceSinkOperatorInfo).getRR();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<exprNodeDesc> groupByKeys = new ArrayList<exprNodeDesc>();
        ArrayList<aggregationDesc> aggregations = new ArrayList<aggregationDesc>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            String text = grpbyExpr.toStringTree();
            ColumnInfo exprInfo = groupByInputRowResolver.get("", text);
            if (exprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(grpbyExpr));
            }
            groupByKeys.add(new exprNodeColumnDesc(exprInfo.getType(), exprInfo.getInternalName(), exprInfo.getTabAlias(), exprInfo.getIsPartitionCol()));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            groupByOutputRowResolver.put("", grpbyExpr.toStringTree(), new ColumnInfo(field, exprInfo.getType(), "", false));
            colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            boolean partialAggDone;
            ASTNode value = entry.getValue();
            String aggName = value.getChild(0).getText();
            ArrayList<exprNodeDesc> aggParameters = new ArrayList<exprNodeDesc>();
            boolean bl = partialAggDone = !distPartAgg && value.getToken().getType() != 21;
            if (!partialAggDone) {
                for (int i = 1; i < value.getChildCount(); ++i) {
                    String text = value.getChild(i).toStringTree();
                    ASTNode paraExpr = (ASTNode)value.getChild(i);
                    ColumnInfo paraExprInfo = groupByInputRowResolver.get("", text);
                    if (paraExprInfo == null) {
                        throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(paraExpr));
                    }
                    String paraExpression = paraExprInfo.getInternalName();
                    assert (paraExpression != null);
                    aggParameters.add(new exprNodeColumnDesc(paraExprInfo.getType(), paraExprInfo.getInternalName(), paraExprInfo.getTabAlias(), paraExprInfo.getIsPartitionCol()));
                }
            } else {
                String text = entry.getKey();
                ColumnInfo paraExprInfo = groupByInputRowResolver.get("", text);
                if (paraExprInfo == null) {
                    throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(value));
                }
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                aggParameters.add(new exprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsPartitionCol()));
            }
            boolean isDistinct = value.getType() == 21;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = null;
            if (distPartAgg) {
                genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value);
                assert (genericUDAFEvaluator != null);
                genericUDAFEvaluators.put(entry.getKey(), genericUDAFEvaluator);
            } else {
                genericUDAFEvaluator = genericUDAFEvaluators.get(entry.getKey());
                assert (genericUDAFEvaluator != null);
            }
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new aggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, mode != groupByDesc.Mode.FINAL && isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.put("", value.toStringTree(), new ColumnInfo(field, udaf.returnType, "", false));
        }
        Operator<groupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new groupByDesc(mode, outputColumnNames, groupByKeys, aggregations, distPartAgg), new RowSchema(groupByOutputRowResolver.getColumnInfos()), reduceSinkOperatorInfo), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private Operator genGroupByPlanMapGroupByOperator(QB qb, String dest, Operator inputOperatorInfo, groupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRR();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<exprNodeDesc> groupByKeys = new ArrayList<exprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<aggregationDesc> aggregations = new ArrayList<aggregationDesc>();
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            exprNodeDesc grpByExprNode = this.genExprNodeDesc(grpbyExpr, groupByInputRowResolver);
            groupByKeys.add(grpByExprNode);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            groupByOutputRowResolver.put("", grpbyExpr.toStringTree(), new ColumnInfo(field, grpByExprNode.getTypeInfo(), "", false));
            colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
        }
        if (parseInfo.getDistinctFuncExprForClause(dest) != null) {
            ASTNode value = parseInfo.getDistinctFuncExprForClause(dest);
            int numDistn = 0;
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode parameter = (ASTNode)value.getChild(i);
                String text = parameter.toStringTree();
                if (groupByOutputRowResolver.get("", text) != null) continue;
                exprNodeDesc distExprNode = this.genExprNodeDesc(parameter, groupByInputRowResolver);
                groupByKeys.add(distExprNode);
                String field = SemanticAnalyzer.getColumnInternalName(grpByExprs.size() + ++numDistn - 1);
                outputColumnNames.add(field);
                groupByOutputRowResolver.put("", text, new ColumnInfo(field, distExprNode.getTypeInfo(), "", false));
                colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
            }
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        assert (aggregationTrees != null);
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            String aggName = value.getChild(0).getText();
            ArrayList<exprNodeDesc> aggParameters = new ArrayList<exprNodeDesc>();
            ArrayList aggClasses = new ArrayList();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                exprNodeDesc paraExprNode = this.genExprNodeDesc(paraExpr, groupByInputRowResolver);
                aggParameters.add(paraExprNode);
            }
            boolean isDistinct = value.getType() == 21;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value);
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new aggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.put("", value.toStringTree(), new ColumnInfo(field, udaf.returnType, "", false));
            if (genericUDAFEvaluators == null) continue;
            genericUDAFEvaluators.put(entry.getKey(), genericUDAFEvaluator);
        }
        Operator<groupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new groupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false), new RowSchema(groupByOutputRowResolver.getColumnInfos()), inputOperatorInfo), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private Operator genGroupByPlanReduceSinkOperator(QB qb, String dest, Operator inputOperatorInfo, int numPartitionFields, int numReducers, boolean mapAggrDone) throws SemanticException {
        ColumnInfo colInfo;
        String field;
        String text;
        RowResolver reduceSinkInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRR();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        ArrayList<exprNodeDesc> reduceKeys = new ArrayList<exprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            exprNodeDesc inputExpr = this.genExprNodeDesc(grpbyExpr, reduceSinkInputRowResolver);
            reduceKeys.add(inputExpr);
            text = grpbyExpr.toStringTree();
            if (reduceSinkOutputRowResolver.get("", text) != null) {
                throw new SemanticException(ErrorMsg.DUPLICATE_GROUPBY_KEY.getMsg(grpbyExpr));
            }
            outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
            field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
            colInfo = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), null, false);
            reduceSinkOutputRowResolver.put("", text, colInfo);
            colExprMap.put(colInfo.getInternalName(), inputExpr);
        }
        if (parseInfo.getDistinctFuncExprForClause(dest) != null) {
            ASTNode value = parseInfo.getDistinctFuncExprForClause(dest);
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode parameter = (ASTNode)value.getChild(i);
                text = parameter.toStringTree();
                if (reduceSinkOutputRowResolver.get("", text) != null) continue;
                reduceKeys.add(this.genExprNodeDesc(parameter, reduceSinkInputRowResolver));
                outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
                field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
                colInfo = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), null, false);
                reduceSinkOutputRowResolver.put("", text, colInfo);
                colExprMap.put(colInfo.getInternalName(), reduceKeys.get(reduceKeys.size() - 1));
            }
        }
        ArrayList<exprNodeDesc> reduceValues = new ArrayList<exprNodeDesc>();
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        if (!mapAggrDone) {
            for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
                ASTNode value = entry.getValue();
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode parameter = (ASTNode)value.getChild(i);
                    String text2 = parameter.toStringTree();
                    if (reduceSinkOutputRowResolver.get("", text2) != null) continue;
                    reduceValues.add(this.genExprNodeDesc(parameter, reduceSinkInputRowResolver));
                    outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
                    String field2 = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                    reduceSinkOutputRowResolver.put("", text2, new ColumnInfo(field2, reduceValues.get(reduceValues.size() - 1).getTypeInfo(), null, false));
                }
            }
        } else {
            int inputField = reduceKeys.size();
            for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
                TypeInfo type = reduceSinkInputRowResolver.getColumnInfos().get(inputField).getType();
                reduceValues.add(new exprNodeColumnDesc(type, SemanticAnalyzer.getColumnInternalName(inputField), "", false));
                ++inputField;
                outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
                String field3 = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                reduceSinkOutputRowResolver.put("", entry.getValue().toStringTree(), new ColumnInfo(field3, type, null, false));
            }
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, true, -1, numPartitionFields, numReducers), new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), inputOperatorInfo), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private Operator genGroupByPlanReduceSinkOperator2MR(QBParseInfo parseInfo, String dest, Operator groupByOperatorInfo, int numPartitionFields, int numReducers) throws SemanticException {
        RowResolver reduceSinkInputRowResolver2 = this.opParseCtx.get(groupByOperatorInfo).getRR();
        RowResolver reduceSinkOutputRowResolver2 = new RowResolver();
        reduceSinkOutputRowResolver2.setIsExprResolver(true);
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        ArrayList<exprNodeDesc> reduceKeys = new ArrayList<exprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            TypeInfo typeInfo = reduceSinkInputRowResolver2.get("", grpbyExpr.toStringTree()).getType();
            exprNodeColumnDesc inputExpr = new exprNodeColumnDesc(typeInfo, field, "", false);
            reduceKeys.add(inputExpr);
            ColumnInfo colInfo = new ColumnInfo(Utilities.ReduceField.KEY.toString() + "." + field, typeInfo, "", false);
            reduceSinkOutputRowResolver2.put("", grpbyExpr.toStringTree(), colInfo);
            colExprMap.put(colInfo.getInternalName(), inputExpr);
        }
        ArrayList<exprNodeDesc> reduceValues = new ArrayList<exprNodeDesc>();
        int inputField = reduceKeys.size();
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            String field = SemanticAnalyzer.getColumnInternalName(inputField);
            ASTNode t = entry.getValue();
            TypeInfo typeInfo = reduceSinkInputRowResolver2.get("", t.toStringTree()).getType();
            reduceValues.add(new exprNodeColumnDesc(typeInfo, field, "", false));
            ++inputField;
            String col = SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
            outputColumnNames.add(col);
            reduceSinkOutputRowResolver2.put("", t.toStringTree(), new ColumnInfo(Utilities.ReduceField.VALUE.toString() + "." + col, typeInfo, "", false));
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, true, -1, numPartitionFields, numReducers), new RowSchema(reduceSinkOutputRowResolver2.getColumnInfos()), groupByOperatorInfo), reduceSinkOutputRowResolver2);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private Operator genGroupByPlanGroupByOperator2MR(QBParseInfo parseInfo, String dest, Operator reduceSinkOperatorInfo2, groupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators) throws SemanticException {
        RowResolver groupByInputRowResolver2 = this.opParseCtx.get(reduceSinkOperatorInfo2).getRR();
        RowResolver groupByOutputRowResolver2 = new RowResolver();
        groupByOutputRowResolver2.setIsExprResolver(true);
        ArrayList<exprNodeDesc> groupByKeys = new ArrayList<exprNodeDesc>();
        ArrayList<aggregationDesc> aggregations = new ArrayList<aggregationDesc>();
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            String text = grpbyExpr.toStringTree();
            ColumnInfo exprInfo = groupByInputRowResolver2.get("", text);
            if (exprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(grpbyExpr));
            }
            String expression = exprInfo.getInternalName();
            groupByKeys.add(new exprNodeColumnDesc(exprInfo.getType(), expression, exprInfo.getTabAlias(), exprInfo.getIsPartitionCol()));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            groupByOutputRowResolver2.put("", grpbyExpr.toStringTree(), new ColumnInfo(field, exprInfo.getType(), "", false));
            colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ArrayList<exprNodeDesc> aggParameters = new ArrayList<exprNodeDesc>();
            ASTNode value = entry.getValue();
            String text = entry.getKey();
            ColumnInfo paraExprInfo = groupByInputRowResolver2.get("", text);
            if (paraExprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(value));
            }
            String paraExpression = paraExprInfo.getInternalName();
            assert (paraExpression != null);
            aggParameters.add(new exprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsPartitionCol()));
            String aggName = value.getChild(0).getText();
            boolean isDistinct = value.getType() == 21;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = genericUDAFEvaluators.get(entry.getKey());
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new aggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, mode != groupByDesc.Mode.FINAL && value.getToken().getType() == 21, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver2.put("", value.toStringTree(), new ColumnInfo(field, udaf.returnType, "", false));
        }
        Operator<groupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new groupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false), new RowSchema(groupByOutputRowResolver2.getColumnInfos()), reduceSinkOperatorInfo2), groupByOutputRowResolver2);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private Operator genGroupByPlan1MR(String dest, QB qb, Operator input) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        int numReducers = -1;
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        Operator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, input, grpByExprs.size(), numReducers, false);
        Operator groupByOperatorInfo = this.genGroupByPlanGroupByOperator(parseInfo, dest, reduceSinkOperatorInfo, groupByDesc.Mode.COMPLETE, null);
        return groupByOperatorInfo;
    }

    static ArrayList<GenericUDAFEvaluator> getUDAFEvaluators(ArrayList<aggregationDesc> aggs) {
        ArrayList<GenericUDAFEvaluator> result = new ArrayList<GenericUDAFEvaluator>();
        for (int i = 0; i < aggs.size(); ++i) {
            result.add(aggs.get(i).getGenericUDAFEvaluator());
        }
        return result;
    }

    private Operator genGroupByPlan2MRMultiGroupBy(String dest, QB qb, Operator input) throws SemanticException {
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        QBParseInfo parseInfo = qb.getParseInfo();
        Operator groupByOperatorInfo = this.genGroupByPlanGroupByOperator1(parseInfo, dest, input, groupByDesc.Mode.HASH, genericUDAFEvaluators, true);
        int numReducers = -1;
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo, grpByExprs.size(), numReducers);
        Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, groupByDesc.Mode.FINAL, genericUDAFEvaluators);
        return groupByOperatorInfo2;
    }

    private Operator genGroupByPlan2MR(String dest, QB qb, Operator input) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        Operator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, input, parseInfo.getDistinctFuncExprForClause(dest) == null ? -1 : Integer.MAX_VALUE, -1, false);
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanGroupByOperator(parseInfo, dest, reduceSinkOperatorInfo, groupByDesc.Mode.PARTIAL1, genericUDAFEvaluators);
        int numReducers = -1;
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo, grpByExprs.size(), numReducers);
        Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, groupByDesc.Mode.FINAL, genericUDAFEvaluators);
        return groupByOperatorInfo2;
    }

    private boolean optimizeMapAggrGroupBy(String dest, QB qb) {
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(qb.getParseInfo(), dest);
        if (grpByExprs != null && !grpByExprs.isEmpty()) {
            return false;
        }
        return qb.getParseInfo().getDistinctFuncExprForClause(dest) == null;
    }

    private Operator genGroupByPlanMapAggr1MR(String dest, QB qb, Operator inputOperatorInfo) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanMapGroupByOperator(qb, dest, inputOperatorInfo, groupByDesc.Mode.HASH, genericUDAFEvaluators);
        this.groupOpToInputTables.put(groupByOperatorInfo, this.opParseCtx.get(inputOperatorInfo).getRR().getTableNames());
        int numReducers = -1;
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        Operator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs.size(), numReducers, true);
        return this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, groupByDesc.Mode.MERGEPARTIAL, genericUDAFEvaluators, false);
    }

    private Operator genGroupByPlanMapAggr2MR(String dest, QB qb, Operator inputOperatorInfo) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanMapGroupByOperator(qb, dest, inputOperatorInfo, groupByDesc.Mode.HASH, genericUDAFEvaluators);
        this.groupOpToInputTables.put(groupByOperatorInfo, this.opParseCtx.get(inputOperatorInfo).getRR().getTableNames());
        if (!this.optimizeMapAggrGroupBy(dest, qb)) {
            Operator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, parseInfo.getDistinctFuncExprForClause(dest) == null ? -1 : Integer.MAX_VALUE, -1, true);
            Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, groupByDesc.Mode.PARTIALS, genericUDAFEvaluators, false);
            int numReducers = -1;
            List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
            if (grpByExprs.isEmpty()) {
                numReducers = 1;
            }
            Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo2, grpByExprs.size(), numReducers);
            return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, groupByDesc.Mode.FINAL, genericUDAFEvaluators);
        }
        Operator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, SemanticAnalyzer.getGroupByForClause(parseInfo, dest).size(), 1, true);
        return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo, groupByDesc.Mode.FINAL, genericUDAFEvaluators);
    }

    private Operator genConversionOps(String dest, QB qb, Operator input) throws SemanticException {
        Integer dest_type = qb.getMetaData().getDestTypeForAlias(dest);
        Table dest_tab = null;
        switch (dest_type) {
            case 1: {
                dest_tab = qb.getMetaData().getDestTableForAlias(dest);
                break;
            }
            case 2: {
                dest_tab = qb.getMetaData().getDestPartitionForAlias(dest).getTable();
                break;
            }
            default: {
                return input;
            }
        }
        return input;
    }

    private Operator genFileSinkPlan(String dest, QB qb, Operator input) throws SemanticException {
        String queryTmpdir;
        Path dest_path;
        RowResolver inputRR = this.opParseCtx.get(input).getRR();
        QBMetaData qbm = qb.getMetaData();
        Integer dest_type = qbm.getDestTypeForAlias(dest);
        tableDesc table_desc = null;
        int currentTableId = 0;
        boolean isLocal = false;
        switch (dest_type) {
            case 1: {
                Table dest_tab = qbm.getDestTableForAlias(dest);
                List parts = dest_tab.getTTable().getPartitionKeys();
                if (parts != null && parts.size() > 0) {
                    throw new SemanticException(ErrorMsg.NEED_PARTITION_ERROR.getMsg());
                }
                dest_path = dest_tab.getPath();
                queryTmpdir = this.ctx.getExternalTmpFileURI(dest_path.toUri());
                table_desc = Utilities.getTableDesc(dest_tab);
                this.idToTableNameMap.put(String.valueOf(this.destTableId), dest_tab.getName());
                currentTableId = this.destTableId++;
                this.loadTableWork.add(new loadTableDesc(queryTmpdir, this.ctx.getExternalTmpFileURI(dest_path.toUri()), table_desc, new HashMap<String, String>()));
                if (this.outputs.add(new WriteEntity(dest_tab))) break;
                throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(dest_tab.getName()));
            }
            case 2: {
                Partition dest_part = qbm.getDestPartitionForAlias(dest);
                Table dest_tab = dest_part.getTable();
                dest_path = dest_part.getPath()[0];
                queryTmpdir = this.ctx.getExternalTmpFileURI(dest_path.toUri());
                table_desc = Utilities.getTableDesc(dest_tab);
                this.idToTableNameMap.put(String.valueOf(this.destTableId), dest_tab.getName());
                currentTableId = this.destTableId++;
                this.loadTableWork.add(new loadTableDesc(queryTmpdir, this.ctx.getExternalTmpFileURI(dest_path.toUri()), table_desc, dest_part.getSpec()));
                if (this.outputs.add(new WriteEntity(dest_part))) break;
                throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(dest_tab.getName() + "@" + dest_part.getName()));
            }
            case 5: {
                isLocal = true;
            }
            case 3: {
                dest_path = new Path(qbm.getDestFileForAlias(dest));
                String destStr = dest_path.toString();
                if (isLocal) {
                    queryTmpdir = this.ctx.getMRTmpFileURI();
                } else {
                    try {
                        Path qPath = FileUtils.makeQualified(dest_path, this.conf);
                        queryTmpdir = this.ctx.getExternalTmpFileURI(qPath.toUri());
                    }
                    catch (Exception e) {
                        throw new SemanticException("Error creating temporary folder on: " + dest_path, e);
                    }
                }
                String cols = new String();
                String colTypes = new String();
                Vector<ColumnInfo> colInfos = inputRR.getColumnInfos();
                ArrayList<FieldSchema> field_schemas = null;
                createTableDesc tblDesc = qb.getTableDesc();
                if (tblDesc != null) {
                    field_schemas = new ArrayList<FieldSchema>();
                }
                boolean first = true;
                for (ColumnInfo colInfo : colInfos) {
                    String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
                    if (nm[1] != null) {
                        colInfo.setAlias(nm[1]);
                    }
                    if (field_schemas != null) {
                        FieldSchema col = new FieldSchema();
                        if (nm[1] != null) {
                            col.setName(colInfo.getAlias());
                        } else {
                            col.setName(colInfo.getInternalName());
                        }
                        col.setType(colInfo.getType().getTypeName());
                        field_schemas.add(col);
                    }
                    if (!first) {
                        cols = cols.concat(",");
                        colTypes = colTypes.concat(":");
                    }
                    first = false;
                    cols = cols.concat(colInfo.getInternalName());
                    String tName = colInfo.getType().getTypeName();
                    if (tName.equals("void")) {
                        colTypes = colTypes.concat("string");
                        continue;
                    }
                    colTypes = colTypes.concat(tName);
                }
                if (tblDesc != null) {
                    tblDesc.setCols(field_schemas);
                }
                if (!this.ctx.isMRTmpFileURI(destStr)) {
                    this.idToTableNameMap.put(String.valueOf(this.destTableId), destStr);
                    currentTableId = this.destTableId++;
                }
                boolean isDfsDir = dest_type == 3;
                this.loadFileWork.add(new loadFileDesc(queryTmpdir, destStr, isDfsDir, cols, colTypes));
                table_desc = tblDesc == null ? PlanUtils.getDefaultTableDesc(Integer.toString(1), cols, colTypes, false) : PlanUtils.getTableDesc(tblDesc, cols, colTypes);
                if (this.outputs.add(new WriteEntity(destStr, !isDfsDir))) break;
                throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(destStr));
            }
            default: {
                throw new SemanticException("Unknown destination type: " + dest_type);
            }
        }
        input = this.genConversionSelectOperator(dest, qb, input, table_desc);
        inputRR = this.opParseCtx.get(input).getRR();
        Vector<ColumnInfo> vecCol = new Vector<ColumnInfo>();
        try {
            StructObjectInspector rowObjectInspector = (StructObjectInspector)table_desc.getDeserializer().getObjectInspector();
            List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
            for (int i = 0; i < fields.size(); ++i) {
                vecCol.add(new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), "", false));
            }
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage());
        }
        RowSchema fsRS = new RowSchema(vecCol);
        Operator<fileSinkDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new fileSinkDesc(queryTmpdir, table_desc, this.conf.getBoolVar(HiveConf.ConfVars.COMPRESSRESULT), currentTableId), fsRS, input), inputRR);
        this.LOG.debug((Object)("Created FileSink Plan for clause: " + dest + "dest_path: " + dest_path + " row schema: " + inputRR.toString()));
        return output;
    }

    Operator genConversionSelectOperator(String dest, QB qb, Operator input, tableDesc table_desc) throws SemanticException {
        StructObjectInspector oi = null;
        try {
            Deserializer deserializer = table_desc.getDeserializerClass().newInstance();
            deserializer.initialize(this.conf, table_desc.getProperties());
            oi = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
        List<? extends StructField> tableFields = oi.getAllStructFieldRefs();
        Vector<ColumnInfo> rowFields = this.opParseCtx.get(input).getRR().getColumnInfos();
        if (tableFields.size() != rowFields.size()) {
            String reason = "Table " + dest + " has " + tableFields.size() + " columns but query has " + rowFields.size() + " columns.";
            throw new SemanticException(ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(qb.getParseInfo().getDestForClause(dest), reason));
        }
        boolean converted = false;
        int columnNumber = tableFields.size();
        ArrayList<exprNodeDesc> expressions = new ArrayList<exprNodeDesc>(columnNumber);
        boolean isMetaDataSerDe = table_desc.getDeserializerClass().equals(MetadataTypedColumnsetSerDe.class);
        boolean isLazySimpleSerDe = table_desc.getDeserializerClass().equals(LazySimpleSerDe.class);
        if (!isMetaDataSerDe) {
            for (int i = 0; i < columnNumber; ++i) {
                ObjectInspector tableFieldOI = tableFields.get(i).getFieldObjectInspector();
                TypeInfo tableFieldTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(tableFieldOI);
                TypeInfo rowFieldTypeInfo = rowFields.get(i).getType();
                exprNodeDesc column = new exprNodeColumnDesc(rowFieldTypeInfo, rowFields.get(i).getInternalName(), "", false);
                if (!(tableFieldTypeInfo.equals(rowFieldTypeInfo) || isLazySimpleSerDe && tableFieldTypeInfo.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && tableFieldTypeInfo.equals(TypeInfoFactory.stringTypeInfo))) {
                    converted = true;
                    column = tableFieldTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE ? null : TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc(tableFieldTypeInfo.getTypeName(), column);
                    if (column == null) {
                        String reason = "Cannot convert column " + i + " from " + rowFieldTypeInfo + " to " + tableFieldTypeInfo + ".";
                        throw new SemanticException(ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(qb.getParseInfo().getDestForClause(dest), reason));
                    }
                }
                expressions.add(column);
            }
        }
        if (converted) {
            RowResolver rowResolver = new RowResolver();
            ArrayList<String> colName = new ArrayList<String>();
            for (int i = 0; i < expressions.size(); ++i) {
                String name = SemanticAnalyzer.getColumnInternalName(i);
                rowResolver.put("", name, new ColumnInfo(name, expressions.get(i).getTypeInfo(), "", false));
                colName.add(name);
            }
            Operator<selectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new selectDesc(expressions, colName), new RowSchema(rowResolver.getColumnInfos()), input), rowResolver);
            return output;
        }
        return input;
    }

    private Operator genLimitPlan(String dest, QB qb, Operator input, int limit) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRR();
        Operator<limitDesc> limitMap = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new limitDesc(limit), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        this.LOG.debug((Object)("Created LimitOperator Plan for clause: " + dest + " row schema: " + inputRR.toString()));
        return limitMap;
    }

    /*
     * WARNING - void declaration
     */
    private Operator genUDTFPlan(GenericUDTF genericUDTF, String outputTableAlias, ArrayList<String> colAliases, QB qb, Operator input) throws SemanticException {
        void var17_20;
        int numSuppliedAliases;
        QBParseInfo qbp = qb.getParseInfo();
        if (!qbp.getDestToGroupBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_GROUP_BY.getMsg());
        }
        if (!qbp.getDestToDistributeBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_DISTRIBUTE_BY.getMsg());
        }
        if (!qbp.getDestToSortBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_SORT_BY.getMsg());
        }
        if (!qbp.getDestToClusterBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_CLUSTER_BY.getMsg());
        }
        if (!qbp.getAliasToLateralViews().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_LATERAL_VIEW.getMsg());
        }
        this.LOG.debug((Object)("Table alias: " + outputTableAlias + " Col aliases: " + colAliases));
        RowResolver selectRR = this.opParseCtx.get(input).getRR();
        Vector<ColumnInfo> inputCols = selectRR.getColumnInfos();
        ArrayList<String> colNames = new ArrayList<String>();
        ObjectInspector[] colOIs = new ObjectInspector[inputCols.size()];
        for (int i = 0; i < inputCols.size(); ++i) {
            colNames.add(inputCols.get(i).getInternalName());
            colOIs[i] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(inputCols.get(i).getType());
        }
        StructObjectInspector outputOI = genericUDTF.initialize(colOIs);
        int numUdtfCols = outputOI.getAllStructFieldRefs().size();
        if (numUdtfCols != (numSuppliedAliases = colAliases.size())) {
            throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg("expected " + numUdtfCols + " aliases " + "but got " + numSuppliedAliases));
        }
        ArrayList<ColumnInfo> udtfCols = new ArrayList<ColumnInfo>();
        Iterator<String> colAliasesIter = colAliases.iterator();
        for (StructField structField : outputOI.getAllStructFieldRefs()) {
            String colAlias = colAliasesIter.next();
            assert (colAlias != null);
            ColumnInfo col = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()), outputTableAlias, false);
            udtfCols.add(col);
        }
        RowResolver out_rwsch = new RowResolver();
        boolean bl = false;
        while (var17_20 < udtfCols.size()) {
            out_rwsch.put(outputTableAlias, colAliases.get((int)var17_20), (ColumnInfo)udtfCols.get((int)var17_20));
            ++var17_20;
        }
        Operator<udtfDesc> operator = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new udtfDesc(genericUDTF), new RowSchema(out_rwsch.getColumnInfos()), input), out_rwsch);
        return operator;
    }

    private Operator genLimitMapRedPlan(String dest, QB qb, Operator input, int limit, boolean extraMRStep) throws SemanticException {
        Operator curr = this.genLimitPlan(dest, qb, input, limit);
        if (!extraMRStep) {
            return curr;
        }
        curr = this.genReduceSinkPlan(dest, qb, curr, 1);
        return this.genLimitPlan(dest, qb, curr, limit);
    }

    private Operator genReduceSinkPlan(String dest, QB qb, Operator input, int numReducers) throws SemanticException {
        ASTNode sortExprs;
        RowResolver inputRR = this.opParseCtx.get(input).getRR();
        ASTNode partitionExprs = qb.getParseInfo().getClusterByForClause(dest);
        if (partitionExprs == null) {
            partitionExprs = qb.getParseInfo().getDistributeByForClause(dest);
        }
        ArrayList<exprNodeDesc> partitionCols = new ArrayList<exprNodeDesc>();
        if (partitionExprs != null) {
            int ccount = partitionExprs.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                ASTNode cl = (ASTNode)partitionExprs.getChild(i);
                partitionCols.add(this.genExprNodeDesc(cl, inputRR));
            }
        }
        if ((sortExprs = qb.getParseInfo().getClusterByForClause(dest)) == null) {
            sortExprs = qb.getParseInfo().getSortByForClause(dest);
        }
        if (sortExprs == null && (sortExprs = qb.getParseInfo().getOrderByForClause(dest)) != null) {
            assert (numReducers == 1);
            Integer limit = qb.getParseInfo().getDestLimit(dest);
            if (this.conf.getVar(HiveConf.ConfVars.HIVEMAPREDMODE).equalsIgnoreCase("strict") && limit == null) {
                throw new SemanticException(ErrorMsg.NO_LIMIT_WITH_ORDERBY.getMsg(sortExprs));
            }
        }
        ArrayList<exprNodeDesc> sortCols = new ArrayList<exprNodeDesc>();
        StringBuilder order = new StringBuilder();
        if (sortExprs != null) {
            int ccount = sortExprs.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                ASTNode cl = (ASTNode)sortExprs.getChild(i);
                if (cl.getType() == 120) {
                    order.append("+");
                    cl = (ASTNode)cl.getChild(0);
                } else if (cl.getType() == 121) {
                    order.append("-");
                    cl = (ASTNode)cl.getChild(0);
                } else {
                    order.append("+");
                }
                exprNodeDesc exprNode = this.genExprNodeDesc(cl, inputRR);
                sortCols.add(exprNode);
            }
        }
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        ArrayList<exprNodeDesc> valueCols = new ArrayList<exprNodeDesc>();
        for (ColumnInfo colInfo : inputRR.getColumnInfos()) {
            valueCols.add(new exprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsPartitionCol()));
            colExprMap.put(colInfo.getInternalName(), valueCols.get(valueCols.size() - 1));
        }
        ArrayList<String> outputColumns = new ArrayList<String>();
        for (int i = 0; i < valueCols.size(); ++i) {
            outputColumns.add(SemanticAnalyzer.getColumnInternalName(i));
        }
        Operator<reduceSinkDesc> interim = this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(sortCols, valueCols, outputColumns, false, -1, partitionCols, order.toString(), numReducers), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        interim.setColumnExprMap(colExprMap);
        RowResolver out_rwsch = new RowResolver();
        RowResolver interim_rwsch = inputRR;
        Integer pos = 0;
        for (ColumnInfo colInfo : interim_rwsch.getColumnInfos()) {
            String[] info = interim_rwsch.reverseLookup(colInfo.getInternalName());
            out_rwsch.put(info[0], info[1], new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), info[0], false));
            pos = pos + 1;
        }
        Operator<extractDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new extractDesc(new exprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, Utilities.ReduceField.VALUE.toString(), "", false)), new RowSchema(out_rwsch.getColumnInfos()), interim), out_rwsch);
        this.LOG.debug((Object)("Created ReduceSink Plan for clause: " + dest + " row schema: " + out_rwsch.toString()));
        return output;
    }

    private Operator genJoinOperatorChildren(QBJoinTree join, Operator left, Operator[] right, HashSet<Integer> omitOpts) throws SemanticException {
        RowResolver outputRS = new RowResolver();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        Operator[] rightOps = new Operator[right.length];
        int outputPos = 0;
        HashMap<String, Byte> reversedExprs = new HashMap<String, Byte>();
        HashMap<Byte, List<exprNodeDesc>> exprMap = new HashMap<Byte, List<exprNodeDesc>>();
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        HashMap<Integer, Set<String>> posToAliasMap = new HashMap<Integer, Set<String>>();
        for (int pos = 0; pos < right.length; ++pos) {
            Operator input = right[pos];
            if (input == null) {
                input = left;
            }
            ArrayList<exprNodeColumnDesc> keyDesc = new ArrayList<exprNodeColumnDesc>();
            Byte tag = (byte)((reduceSinkDesc)input.getConf()).getTag();
            if (omitOpts == null || !omitOpts.contains(pos)) {
                RowResolver inputRS = this.opParseCtx.get(input).getRR();
                Iterator<String> keysIter = inputRS.getTableNames().iterator();
                HashSet<String> aliases = (HashSet<String>)posToAliasMap.get(pos);
                if (aliases == null) {
                    aliases = new HashSet<String>();
                    posToAliasMap.put(pos, aliases);
                }
                while (keysIter.hasNext()) {
                    String key = keysIter.next();
                    aliases.add(key);
                    HashMap<String, ColumnInfo> map = inputRS.getFieldMap(key);
                    for (String field : map.keySet()) {
                        ColumnInfo valueInfo = inputRS.get(key, field);
                        keyDesc.add(new exprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), valueInfo.getTabAlias(), valueInfo.getIsPartitionCol()));
                        if (outputRS.get(key, field) != null) continue;
                        String colName = SemanticAnalyzer.getColumnInternalName(outputPos);
                        ++outputPos;
                        outputColumnNames.add(colName);
                        colExprMap.put(colName, (exprNodeDesc)keyDesc.get(keyDesc.size() - 1));
                        outputRS.put(key, field, new ColumnInfo(colName, valueInfo.getType(), key, false));
                        reversedExprs.put(colName, tag);
                    }
                }
            }
            exprMap.put(tag, keyDesc);
            rightOps[pos] = input;
        }
        org.apache.hadoop.hive.ql.plan.joinCond[] joinCondns = new org.apache.hadoop.hive.ql.plan.joinCond[join.getJoinCond().length];
        for (int i = 0; i < join.getJoinCond().length; ++i) {
            joinCond condn = join.getJoinCond()[i];
            joinCondns[i] = new org.apache.hadoop.hive.ql.plan.joinCond(condn);
        }
        joinDesc desc = new joinDesc(exprMap, outputColumnNames, joinCondns);
        desc.setReversedExprs(reversedExprs);
        JoinOperator joinOp = (JoinOperator)OperatorFactory.getAndMakeChild(desc, new RowSchema(outputRS.getColumnInfos()), rightOps);
        joinOp.setColumnExprMap(colExprMap);
        joinOp.setPosToAliasMap(posToAliasMap);
        return this.putOpInsertMap(joinOp, outputRS);
    }

    private Operator genJoinReduceSinkChild(QB qb, QBJoinTree joinTree, Operator child, String srcName, int pos) throws SemanticException {
        RowResolver inputRS = this.opParseCtx.get(child).getRR();
        RowResolver outputRS = new RowResolver();
        ArrayList<String> outputColumns = new ArrayList<String>();
        ArrayList<exprNodeDesc> reduceKeys = new ArrayList<exprNodeDesc>();
        Vector<ASTNode> exprs = joinTree.getExpressions().get(pos);
        for (int i = 0; i < exprs.size(); ++i) {
            ASTNode expr = exprs.get(i);
            reduceKeys.add(this.genExprNodeDesc(expr, inputRS));
        }
        ArrayList<exprNodeDesc> reduceValues = new ArrayList<exprNodeDesc>();
        Iterator<String> tblNamesIter = inputRS.getTableNames().iterator();
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        while (tblNamesIter.hasNext()) {
            String src = tblNamesIter.next();
            HashMap<String, ColumnInfo> fMap = inputRS.getFieldMap(src);
            for (Map.Entry<String, ColumnInfo> entry : fMap.entrySet()) {
                String field = entry.getKey();
                ColumnInfo valueInfo = entry.getValue();
                exprNodeColumnDesc inputExpr = new exprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), valueInfo.getTabAlias(), valueInfo.getIsPartitionCol());
                reduceValues.add(inputExpr);
                if (outputRS.get(src, field) != null) continue;
                String col = SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                outputColumns.add(col);
                ColumnInfo newColInfo = new ColumnInfo(Utilities.ReduceField.VALUE.toString() + "." + col, valueInfo.getType(), src, false);
                colExprMap.put(newColInfo.getInternalName(), inputExpr);
                outputRS.put(src, field, newColInfo);
            }
        }
        int numReds = -1;
        if (reduceKeys.size() == 0) {
            numReds = 1;
            if (this.conf.getVar(HiveConf.ConfVars.HIVEMAPREDMODE).equalsIgnoreCase("strict")) {
                throw new SemanticException(ErrorMsg.NO_CARTESIAN_PRODUCT.getMsg());
            }
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumns, false, joinTree.getNextTag(), reduceKeys.size(), numReds), new RowSchema(outputRS.getColumnInfos()), child), outputRS);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private Operator genJoinOperator(QB qb, QBJoinTree joinTree, HashMap<String, Operator> map) throws SemanticException {
        QBJoinTree leftChild = joinTree.getJoinSrc();
        Operator joinSrcOp = null;
        if (leftChild != null) {
            Operator joinOp = this.genJoinOperator(qb, leftChild, map);
            Vector<ASTNode> filter = joinTree.getFilters().get(0);
            for (ASTNode cond : filter) {
                joinOp = this.genFilterPlan(qb, cond, joinOp);
            }
            joinSrcOp = this.genJoinReduceSinkChild(qb, joinTree, joinOp, null, 0);
        }
        Operator[] srcOps = new Operator[joinTree.getBaseSrc().length];
        HashSet<Integer> omitOpts = null;
        int pos = 0;
        for (String src : joinTree.getBaseSrc()) {
            if (src != null) {
                Operator srcOp = map.get(src);
                ArrayList<ASTNode> fields = joinTree.getRHSSemijoinColumns(src);
                if (fields != null) {
                    if (omitOpts == null) {
                        omitOpts = new HashSet<Integer>();
                    }
                    omitOpts.add(pos);
                    srcOp = this.insertSelectForSemijoin(fields, srcOp);
                    srcOp = this.genMapGroupByForSemijoin(qb, fields, srcOp, groupByDesc.Mode.HASH);
                }
                srcOps[pos] = this.genJoinReduceSinkChild(qb, joinTree, srcOp, src, pos);
                ++pos;
                continue;
            }
            assert (pos == 0);
            srcOps[pos++] = null;
        }
        this.genJoinOperatorTypeCheck(joinSrcOp, srcOps);
        JoinOperator joinOp = (JoinOperator)this.genJoinOperatorChildren(joinTree, joinSrcOp, srcOps, omitOpts);
        this.joinContext.put(joinOp, joinTree);
        return joinOp;
    }

    private Operator insertSelectForSemijoin(ArrayList<ASTNode> fields, Operator input) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRR();
        ArrayList<exprNodeDesc> colList = new ArrayList<exprNodeDesc>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ASTNode field : fields) {
            exprNodeColumnDesc exprNode = (exprNodeColumnDesc)this.genExprNodeDesc(field, inputRR);
            colList.add(exprNode);
            columnNames.add(exprNode.getColumn());
        }
        Operator<selectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new selectDesc(colList, columnNames, false), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        output.setColumnExprMap(input.getColumnExprMap());
        return output;
    }

    private Operator genMapGroupByForSemijoin(QB qb, ArrayList<ASTNode> fields, Operator inputOperatorInfo, groupByDesc.Mode mode) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRR();
        RowResolver groupByOutputRowResolver = new RowResolver();
        ArrayList<exprNodeDesc> groupByKeys = new ArrayList<exprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<aggregationDesc> aggregations = new ArrayList<aggregationDesc>();
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        QBParseInfo parseInfo = qb.getParseInfo();
        groupByOutputRowResolver.setIsExprResolver(true);
        for (int i = 0; i < fields.size(); ++i) {
            ASTNode colName = fields.get(i);
            exprNodeDesc grpByExprNode = this.genExprNodeDesc(colName, groupByInputRowResolver);
            groupByKeys.add(grpByExprNode);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            ColumnInfo colInfo2 = new ColumnInfo(field, grpByExprNode.getTypeInfo(), "", false);
            groupByOutputRowResolver.put("", colName.toStringTree(), colInfo2);
            colExprMap.put(field, grpByExprNode);
        }
        Operator<groupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new groupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false), new RowSchema(groupByOutputRowResolver.getColumnInfos()), inputOperatorInfo), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private Operator genReduceSinkForSemijoin(QB qb, ArrayList<ASTNode> fields, Operator inputOperatorInfo) throws SemanticException {
        RowResolver reduceSinkInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRR();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        ArrayList<exprNodeDesc> reduceKeys = new ArrayList<exprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        for (int i = 0; i < fields.size(); ++i) {
            ASTNode colName = fields.get(i);
            exprNodeDesc inputExpr = this.genExprNodeDesc(colName, reduceSinkInputRowResolver);
            reduceKeys.add(inputExpr);
            if (reduceSinkOutputRowResolver.get("", colName.toStringTree()) != null) {
                throw new SemanticException(ErrorMsg.DUPLICATE_GROUPBY_KEY.getMsg());
            }
            outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
            String field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
            ColumnInfo colInfo1 = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), null, false);
            reduceSinkOutputRowResolver.put("", colName.toStringTree(), colInfo1);
            colExprMap.put(colInfo1.getInternalName(), inputExpr);
        }
        ArrayList<exprNodeDesc> reduceValues = new ArrayList<exprNodeDesc>();
        int numPartitionFields = fields.size();
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, true, -1, numPartitionFields, -1), new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), inputOperatorInfo), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private void genJoinOperatorTypeCheck(Operator left, Operator[] right) throws SemanticException {
        Operator oi;
        int i;
        ArrayList<ArrayList<exprNodeDesc>> keys = new ArrayList<ArrayList<exprNodeDesc>>();
        int keyLength = 0;
        for (i = 0; i < right.length; ++i) {
            oi = i == 0 && right[i] == null ? left : right[i];
            reduceSinkDesc now = (reduceSinkDesc)((ReduceSinkOperator)oi).getConf();
            if (i == 0) {
                keyLength = now.getKeyCols().size();
            } else assert (keyLength == now.getKeyCols().size());
            keys.add(now.getKeyCols());
        }
        for (int k = 0; k < keyLength; ++k) {
            int i2;
            TypeInfo commonType = ((exprNodeDesc)((ArrayList)keys.get(0)).get(k)).getTypeInfo();
            for (i2 = 1; i2 < right.length; ++i2) {
                TypeInfo a = commonType;
                TypeInfo b = ((exprNodeDesc)((ArrayList)keys.get(i2)).get(k)).getTypeInfo();
                if ((commonType = FunctionRegistry.getCommonClassForComparison(a, b)) != null) continue;
                throw new SemanticException("Cannot do equality join on different types: " + a.getTypeName() + " and " + b.getTypeName());
            }
            for (i2 = 0; i2 < right.length; ++i2) {
                if (commonType.equals(((exprNodeDesc)((ArrayList)keys.get(i2)).get(k)).getTypeInfo())) continue;
                ((ArrayList)keys.get(i2)).set(k, TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc(commonType.getTypeName(), (exprNodeDesc)((ArrayList)keys.get(i2)).get(k)));
            }
        }
        for (i = 0; i < right.length; ++i) {
            oi = i == 0 && right[i] == null ? left : right[i];
            reduceSinkDesc now = (reduceSinkDesc)((ReduceSinkOperator)oi).getConf();
            now.setKeySerializeInfo(PlanUtils.getReduceKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(now.getKeyCols(), "joinkey"), now.getOrder()));
        }
    }

    private Operator genJoinPlan(QB qb, HashMap<String, Operator> map) throws SemanticException {
        QBJoinTree joinTree = qb.getQbJoinTree();
        Operator joinOp = this.genJoinOperator(qb, joinTree, map);
        return joinOp;
    }

    private void pushJoinFilters(QB qb, QBJoinTree joinTree, HashMap<String, Operator> map) throws SemanticException {
        Vector<Vector<ASTNode>> filters = joinTree.getFilters();
        if (joinTree.getJoinSrc() != null) {
            this.pushJoinFilters(qb, joinTree.getJoinSrc(), map);
        }
        int pos = 0;
        for (String src : joinTree.getBaseSrc()) {
            if (src != null) {
                Operator srcOp = map.get(src);
                Vector<ASTNode> filter = filters.get(pos);
                for (ASTNode cond : filter) {
                    srcOp = this.genFilterPlan(qb, cond, srcOp);
                }
                map.put(src, srcOp);
            }
            ++pos;
        }
    }

    private List<String> getMapSideJoinTables(QB qb) {
        ArrayList<String> cols = new ArrayList<String>();
        ASTNode hints = qb.getParseInfo().getHints();
        for (int pos = 0; pos < hints.getChildCount(); ++pos) {
            ASTNode hint = (ASTNode)hints.getChild(pos);
            if (((ASTNode)hint.getChild(0)).getToken().getType() != 135) continue;
            ASTNode hintTblNames = (ASTNode)hint.getChild(1);
            int numCh = hintTblNames.getChildCount();
            for (int tblPos = 0; tblPos < numCh; ++tblPos) {
                String tblName = ((ASTNode)hintTblNames.getChild(tblPos)).getText().toLowerCase();
                if (cols.contains(tblName)) continue;
                cols.add(tblName);
            }
        }
        return cols;
    }

    private QBJoinTree genUniqueJoinTree(QB qb, ASTNode joinParseTree) throws SemanticException {
        QBJoinTree joinTree = new QBJoinTree();
        joinTree.setNoOuterJoin(false);
        joinTree.setExpressions(new Vector<Vector<ASTNode>>());
        joinTree.setFilters(new Vector<Vector<ASTNode>>());
        Vector<String> rightAliases = new Vector<String>();
        Vector<String> leftAliases = new Vector<String>();
        Vector<String> baseSrc = new Vector<String>();
        Vector<Boolean> preserved = new Vector<Boolean>();
        boolean lastPreserved = false;
        int cols = -1;
        block6: for (int i = 0; i < joinParseTree.getChildCount(); ++i) {
            ASTNode child = (ASTNode)joinParseTree.getChild(i);
            switch (child.getToken().getType()) {
                case 15: {
                    String alias;
                    String table_name = SemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    String string = alias = child.getChildCount() == 1 ? table_name : SemanticAnalyzer.unescapeIdentifier(child.getChild(child.getChildCount() - 1).getText().toLowerCase());
                    if (i == 0) {
                        leftAliases.add(alias);
                        joinTree.setLeftAlias(alias);
                    } else {
                        rightAliases.add(alias);
                    }
                    baseSrc.add(alias);
                    preserved.add(lastPreserved);
                    lastPreserved = false;
                    continue block6;
                }
                case 48: {
                    if (cols == -1 && child.getChildCount() != 0) {
                        cols = child.getChildCount();
                    } else if (child.getChildCount() != cols) {
                        throw new SemanticException("Tables with different or invalid number of keys in UNIQUEJOIN");
                    }
                    Vector<ASTNode> expressions = new Vector<ASTNode>();
                    Vector filt = new Vector();
                    for (Node exp : child.getChildren()) {
                        expressions.add((ASTNode)exp);
                    }
                    joinTree.getExpressions().add(expressions);
                    joinTree.getFilters().add(filt);
                    continue block6;
                }
                case 260: {
                    lastPreserved = true;
                    continue block6;
                }
                case 16: {
                    throw new SemanticException("Subqueries are not supported in UNIQUEJOIN");
                }
                default: {
                    throw new SemanticException("Unexpected UNIQUEJOIN structure");
                }
            }
        }
        joinTree.setBaseSrc(baseSrc.toArray(new String[0]));
        joinTree.setLeftAliases(leftAliases.toArray(new String[0]));
        joinTree.setRightAliases(rightAliases.toArray(new String[0]));
        joinCond[] condn = new joinCond[preserved.size()];
        for (int i = 0; i < condn.length; ++i) {
            condn[i] = new joinCond((Boolean)preserved.get(i));
        }
        joinTree.setJoinCond(condn);
        if (qb.getParseInfo().getHints() != null) {
            this.parseStreamTables(joinTree, qb);
        }
        return joinTree;
    }

    private QBJoinTree genJoinTree(QB qb, ASTNode joinParseTree) throws SemanticException {
        String[] children;
        String[] leftAliases;
        String alias;
        String table_name;
        QBJoinTree joinTree = new QBJoinTree();
        joinCond[] condn = new joinCond[1];
        switch (joinParseTree.getToken().getType()) {
            case 57: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new joinCond(0, 1, joinType.LEFTOUTER);
                break;
            }
            case 58: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new joinCond(0, 1, joinType.RIGHTOUTER);
                break;
            }
            case 59: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new joinCond(0, 1, joinType.FULLOUTER);
                break;
            }
            case 142: {
                joinTree.setNoSemiJoin(false);
                condn[0] = new joinCond(0, 1, joinType.LEFTSEMI);
                break;
            }
            default: {
                condn[0] = new joinCond(0, 1, joinType.INNER);
                joinTree.setNoOuterJoin(true);
            }
        }
        joinTree.setJoinCond(condn);
        ASTNode left = (ASTNode)joinParseTree.getChild(0);
        ASTNode right = (ASTNode)joinParseTree.getChild(1);
        if (left.getToken().getType() == 15 || left.getToken().getType() == 16) {
            table_name = SemanticAnalyzer.unescapeIdentifier(left.getChild(0).getText());
            alias = left.getChildCount() == 1 ? table_name : SemanticAnalyzer.unescapeIdentifier(left.getChild(left.getChildCount() - 1).getText().toLowerCase());
            joinTree.setLeftAlias(alias);
            leftAliases = new String[]{alias};
            joinTree.setLeftAliases(leftAliases);
            children = new String[2];
            children[0] = alias;
            joinTree.setBaseSrc(children);
        } else if (this.isJoinToken(left)) {
            QBJoinTree leftTree = this.genJoinTree(qb, left);
            joinTree.setJoinSrc(leftTree);
            String[] leftChildAliases = leftTree.getLeftAliases();
            leftAliases = new String[leftChildAliases.length + 1];
            for (int i = 0; i < leftChildAliases.length; ++i) {
                leftAliases[i] = leftChildAliases[i];
            }
            leftAliases[leftChildAliases.length] = leftTree.getRightAliases()[0];
            joinTree.setLeftAliases(leftAliases);
        } else assert (false);
        if (right.getToken().getType() == 15 || right.getToken().getType() == 16) {
            table_name = SemanticAnalyzer.unescapeIdentifier(right.getChild(0).getText());
            alias = right.getChildCount() == 1 ? table_name : SemanticAnalyzer.unescapeIdentifier(right.getChild(right.getChildCount() - 1).getText().toLowerCase());
            String[] rightAliases = new String[]{alias};
            joinTree.setRightAliases(rightAliases);
            children = joinTree.getBaseSrc();
            if (children == null) {
                children = new String[2];
            }
            children[1] = alias;
            joinTree.setBaseSrc(children);
            if (!joinTree.getNoSemiJoin()) {
                joinTree.addRHSSemijoin(alias);
            }
        } else assert (false);
        Vector<Vector<ASTNode>> expressions = new Vector<Vector<ASTNode>>();
        expressions.add(new Vector());
        expressions.add(new Vector());
        joinTree.setExpressions(expressions);
        Vector<Vector<ASTNode>> filters = new Vector<Vector<ASTNode>>();
        filters.add(new Vector());
        filters.add(new Vector());
        joinTree.setFilters(filters);
        ASTNode joinCond2 = (ASTNode)joinParseTree.getChild(2);
        Vector<String> leftSrc = new Vector<String>();
        this.parseJoinCondition(joinTree, joinCond2, leftSrc);
        if (leftSrc.size() == 1) {
            joinTree.setLeftAlias(leftSrc.get(0));
        }
        if (qb.getParseInfo().getHints() != null) {
            List<String> mapSideTables = this.getMapSideJoinTables(qb);
            List<String> mapAliases = joinTree.getMapAliases();
            for (String mapTbl : mapSideTables) {
                boolean mapTable = false;
                for (String leftAlias : joinTree.getLeftAliases()) {
                    if (!mapTbl.equalsIgnoreCase(leftAlias)) continue;
                    mapTable = true;
                }
                for (String rightAlias : joinTree.getRightAliases()) {
                    if (!mapTbl.equalsIgnoreCase(rightAlias)) continue;
                    mapTable = true;
                }
                if (!mapTable) continue;
                if (mapAliases == null) {
                    mapAliases = new ArrayList<String>();
                }
                mapAliases.add(mapTbl);
                joinTree.setMapSideJoin(true);
            }
            joinTree.setMapAliases(mapAliases);
            this.parseStreamTables(joinTree, qb);
        }
        return joinTree;
    }

    private void parseStreamTables(QBJoinTree joinTree, QB qb) {
        List<String> streamAliases = joinTree.getStreamAliases();
        for (Node hintNode : qb.getParseInfo().getHints().getChildren()) {
            ASTNode hint = (ASTNode)hintNode;
            if (hint.getChild(0).getType() != 136) continue;
            for (int i = 0; i < hint.getChild(1).getChildCount(); ++i) {
                if (streamAliases == null) {
                    streamAliases = new ArrayList<String>();
                }
                streamAliases.add(hint.getChild(1).getChild(i).getText());
            }
        }
        joinTree.setStreamAliases(streamAliases);
    }

    private void mergeJoins(QB qb, QBJoinTree parent, QBJoinTree node, QBJoinTree target, int pos) {
        int i;
        int i2;
        int i3;
        String[] nodeRightAliases = node.getRightAliases();
        String[] trgtRightAliases = target.getRightAliases();
        String[] rightAliases = new String[nodeRightAliases.length + trgtRightAliases.length];
        for (i3 = 0; i3 < trgtRightAliases.length; ++i3) {
            rightAliases[i3] = trgtRightAliases[i3];
        }
        for (i3 = 0; i3 < nodeRightAliases.length; ++i3) {
            rightAliases[i3 + trgtRightAliases.length] = nodeRightAliases[i3];
        }
        target.setRightAliases(rightAliases);
        String[] nodeBaseSrc = node.getBaseSrc();
        String[] trgtBaseSrc = target.getBaseSrc();
        String[] baseSrc = new String[nodeBaseSrc.length + trgtBaseSrc.length - 1];
        for (i2 = 0; i2 < trgtBaseSrc.length; ++i2) {
            baseSrc[i2] = trgtBaseSrc[i2];
        }
        for (i2 = 1; i2 < nodeBaseSrc.length; ++i2) {
            baseSrc[i2 + trgtBaseSrc.length - 1] = nodeBaseSrc[i2];
        }
        target.setBaseSrc(baseSrc);
        Vector<Vector<ASTNode>> expr = target.getExpressions();
        for (int i4 = 0; i4 < nodeRightAliases.length; ++i4) {
            expr.add(node.getExpressions().get(i4 + 1));
        }
        Vector<Vector<ASTNode>> filter = target.getFilters();
        for (int i5 = 0; i5 < nodeRightAliases.length; ++i5) {
            filter.add(node.getFilters().get(i5 + 1));
        }
        if (node.getFilters().get(0).size() != 0) {
            Vector<ASTNode> filterPos = filter.get(pos);
            filterPos.addAll((Collection<ASTNode>)node.getFilters().get(0));
        }
        if (qb.getQbJoinTree() == node) {
            qb.setQbJoinTree(node.getJoinSrc());
        } else {
            parent.setJoinSrc(node.getJoinSrc());
        }
        if (node.getNoOuterJoin() && target.getNoOuterJoin()) {
            target.setNoOuterJoin(true);
        } else {
            target.setNoOuterJoin(false);
        }
        if (node.getNoSemiJoin() && target.getNoSemiJoin()) {
            target.setNoSemiJoin(true);
        } else {
            target.setNoSemiJoin(false);
        }
        target.mergeRHSSemijoin(node);
        joinCond[] nodeCondns = node.getJoinCond();
        int nodeCondnsSize = nodeCondns.length;
        joinCond[] targetCondns = target.getJoinCond();
        int targetCondnsSize = targetCondns.length;
        joinCond[] newCondns = new joinCond[nodeCondnsSize + targetCondnsSize];
        for (i = 0; i < targetCondnsSize; ++i) {
            newCondns[i] = targetCondns[i];
        }
        for (i = 0; i < nodeCondnsSize; ++i) {
            joinCond nodeCondn = nodeCondns[i];
            if (nodeCondn.getLeft() == 0) {
                nodeCondn.setLeft(pos);
            } else {
                nodeCondn.setLeft(nodeCondn.getLeft() + targetCondnsSize);
            }
            nodeCondn.setRight(nodeCondn.getRight() + targetCondnsSize);
            newCondns[targetCondnsSize + i] = nodeCondn;
        }
        target.setJoinCond(newCondns);
        if (target.isMapSideJoin()) {
            assert (node.isMapSideJoin());
            List<String> mapAliases = target.getMapAliases();
            for (String mapTbl : node.getMapAliases()) {
                if (mapAliases.contains(mapTbl)) continue;
                mapAliases.add(mapTbl);
            }
            target.setMapAliases(mapAliases);
        }
    }

    private int findMergePos(QBJoinTree node, QBJoinTree target) {
        int i;
        int res = -1;
        String leftAlias = node.getLeftAlias();
        if (leftAlias == null) {
            return -1;
        }
        Vector<ASTNode> nodeCondn = node.getExpressions().get(0);
        Vector<ASTNode> targetCondn = null;
        if (leftAlias.equals(target.getLeftAlias())) {
            targetCondn = target.getExpressions().get(0);
            res = 0;
        } else {
            for (i = 0; i < target.getRightAliases().length; ++i) {
                if (!leftAlias.equals(target.getRightAliases()[i])) continue;
                targetCondn = target.getExpressions().get(i + 1);
                res = i + 1;
                break;
            }
        }
        if (targetCondn == null || nodeCondn.size() != targetCondn.size()) {
            return -1;
        }
        for (i = 0; i < nodeCondn.size(); ++i) {
            if (nodeCondn.get(i).toStringTree().equals(targetCondn.get(i).toStringTree())) continue;
            return -1;
        }
        return res;
    }

    private boolean mergeJoinNodes(QB qb, QBJoinTree parent, QBJoinTree node, QBJoinTree target) {
        if (target == null) {
            return false;
        }
        int res = this.findMergePos(node, target);
        if (res != -1) {
            this.mergeJoins(qb, parent, node, target, res);
            return true;
        }
        return this.mergeJoinNodes(qb, parent, node, target.getJoinSrc());
    }

    private void mergeJoinTree(QB qb) {
        QBJoinTree root = qb.getQbJoinTree();
        QBJoinTree parent = null;
        while (root != null) {
            boolean merged = this.mergeJoinNodes(qb, parent, root, root.getJoinSrc());
            if (parent == null) {
                if (merged) {
                    root = qb.getQbJoinTree();
                    continue;
                }
                parent = root;
                root = root.getJoinSrc();
                continue;
            }
            parent = parent.getJoinSrc();
            root = parent.getJoinSrc();
        }
    }

    private Operator insertSelectAllPlanForGroupBy(String dest, Operator input) throws SemanticException {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRR();
        Vector<ColumnInfo> columns = inputRR.getColumnInfos();
        ArrayList<exprNodeDesc> colList = new ArrayList<exprNodeDesc>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo col = columns.get(i);
            colList.add(new exprNodeColumnDesc(col.getType(), col.getInternalName(), col.getTabAlias(), col.getIsPartitionCol()));
            columnNames.add(col.getInternalName());
        }
        Operator<selectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new selectDesc(colList, columnNames, true), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        output.setColumnExprMap(input.getColumnExprMap());
        return output;
    }

    private List<ASTNode> getCommonDistinctExprs(QB qb, Operator input) {
        RowResolver inputRR = this.opParseCtx.get(input).getRR();
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>();
        ks.addAll(qbp.getClauseNames());
        if (ks.size() <= 1) {
            return null;
        }
        ArrayList<exprNodeDesc> oldList = null;
        ArrayList<ASTNode> oldASTList = null;
        for (String dest : ks) {
            Operator curr = input;
            if (qbp.getWhrForClause(dest) != null) {
                return null;
            }
            if (qbp.getAggregationExprsForClause(dest).size() == 0 && SemanticAnalyzer.getGroupByForClause(qbp, dest).size() == 0) {
                return null;
            }
            ASTNode value = qbp.getDistinctFuncExprForClause(dest);
            if (value == null) {
                return null;
            }
            ArrayList<exprNodeDesc> currDestList = new ArrayList<exprNodeDesc>();
            ArrayList<ASTNode> currASTList = new ArrayList<ASTNode>();
            try {
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode parameter = (ASTNode)value.getChild(i);
                    currDestList.add(this.genExprNodeDesc(parameter, inputRR));
                    currASTList.add(parameter);
                }
            }
            catch (SemanticException e) {
                return null;
            }
            if (oldList == null) {
                oldList = currDestList;
                oldASTList = currASTList;
                continue;
            }
            if (oldList.size() != currDestList.size()) {
                return null;
            }
            for (int pos = 0; pos < oldList.size(); ++pos) {
                if (((exprNodeDesc)oldList.get(pos)).isSame(currDestList.get(pos))) continue;
                return null;
            }
        }
        return oldASTList;
    }

    private Operator createCommonReduceSink(QB qb, Operator input) throws SemanticException {
        List<ASTNode> distExprs = this.getCommonDistinctExprs(qb, input);
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>();
        ks.addAll(qbp.getClauseNames());
        RowResolver inputRR = this.opParseCtx.get(input).getRR();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        ArrayList<exprNodeDesc> reduceKeys = new ArrayList<exprNodeDesc>();
        ArrayList<exprNodeDesc> reduceValues = new ArrayList<exprNodeDesc>();
        HashMap<String, exprNodeDesc> colExprMap = new HashMap<String, exprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (ASTNode distn : distExprs) {
            exprNodeDesc distExpr = this.genExprNodeDesc(distn, inputRR);
            reduceKeys.add(distExpr);
            String text = distn.toStringTree();
            if (reduceSinkOutputRowResolver.get("", text) != null) continue;
            outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
            String field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
            ColumnInfo colInfo = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), "", false);
            reduceSinkOutputRowResolver.put("", text, colInfo);
            colExprMap.put(colInfo.getInternalName(), distExpr);
        }
        for (String dest : ks) {
            List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(qbp, dest);
            for (int i = 0; i < grpByExprs.size(); ++i) {
                ASTNode grpbyExpr = grpByExprs.get(i);
                String text = grpbyExpr.toStringTree();
                if (reduceSinkOutputRowResolver.get("", text) != null) continue;
                exprNodeDesc grpByExprNode = this.genExprNodeDesc(grpbyExpr, inputRR);
                reduceValues.add(grpByExprNode);
                String field = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                ColumnInfo colInfo = new ColumnInfo(field, reduceValues.get(reduceValues.size() - 1).getTypeInfo(), "", false);
                reduceSinkOutputRowResolver.put("", text, colInfo);
                outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
            }
            HashMap<String, ASTNode> aggregationTrees = qbp.getAggregationExprsForClause(dest);
            assert (aggregationTrees != null);
            for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
                ASTNode value = entry.getValue();
                String aggName = value.getChild(0).getText();
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode paraExpr = (ASTNode)value.getChild(i);
                    String text = paraExpr.toStringTree();
                    if (reduceSinkOutputRowResolver.get("", text) != null) continue;
                    exprNodeDesc paraExprNode = this.genExprNodeDesc(paraExpr, inputRR);
                    reduceValues.add(paraExprNode);
                    String field = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                    ColumnInfo colInfo = new ColumnInfo(field, reduceValues.get(reduceValues.size() - 1).getTypeInfo(), "", false);
                    reduceSinkOutputRowResolver.put("", text, colInfo);
                    outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
                }
            }
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, true, -1, reduceKeys.size(), -1), new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), input), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private Operator genBodyPlan(QB qb, Operator input) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>();
        ks.addAll(qbp.getClauseNames());
        boolean optimizeMultiGroupBy = this.getCommonDistinctExprs(qb, input) != null;
        Operator curr = null;
        if (optimizeMultiGroupBy) {
            curr = this.createCommonReduceSink(qb, input);
            RowResolver currRR = this.opParseCtx.get(curr).getRR();
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new forwardDesc(), new RowSchema(currRR.getColumnInfos()), curr), currRR);
            for (String dest : ks) {
                curr = input;
                curr = this.genGroupByPlan2MRMultiGroupBy(dest, qb, curr);
                curr = this.genSelectPlan(dest, qb, curr);
                Integer limit = qbp.getDestLimit(dest);
                if (limit != null) {
                    curr = this.genLimitMapRedPlan(dest, qb, curr, limit, true);
                    qb.getParseInfo().setOuterQueryLimit(limit);
                }
                curr = this.genFileSinkPlan(dest, qb, curr);
            }
        } else {
            for (String dest : ks) {
                curr = input;
                if (qbp.getWhrForClause(dest) != null) {
                    curr = this.genFilterPlan(dest, qb, curr);
                }
                if (qbp.getAggregationExprsForClause(dest).size() != 0 || SemanticAnalyzer.getGroupByForClause(qbp, dest).size() > 0) {
                    curr = this.insertSelectAllPlanForGroupBy(dest, curr);
                    curr = this.conf.getVar(HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE).equalsIgnoreCase("true") ? (this.conf.getVar(HiveConf.ConfVars.HIVEGROUPBYSKEW).equalsIgnoreCase("false") ? this.genGroupByPlanMapAggr1MR(dest, qb, curr) : this.genGroupByPlanMapAggr2MR(dest, qb, curr)) : (this.conf.getVar(HiveConf.ConfVars.HIVEGROUPBYSKEW).equalsIgnoreCase("true") ? this.genGroupByPlan2MR(dest, qb, curr) : this.genGroupByPlan1MR(dest, qb, curr));
                }
                curr = this.genSelectPlan(dest, qb, curr);
                Integer limit = qbp.getDestLimit(dest);
                if (qbp.getClusterByForClause(dest) != null || qbp.getDistributeByForClause(dest) != null || qbp.getOrderByForClause(dest) != null || qbp.getSortByForClause(dest) != null) {
                    int numReducers = -1;
                    if (qbp.getOrderByForClause(dest) != null) {
                        numReducers = 1;
                    }
                    curr = this.genReduceSinkPlan(dest, qb, curr, numReducers);
                }
                if (qbp.getIsSubQ()) {
                    if (limit != null) {
                        curr = this.genLimitMapRedPlan(dest, qb, curr, limit, qbp.getOrderByForClause(dest) == null);
                    }
                } else {
                    curr = this.genConversionOps(dest, qb, curr);
                    if (limit != null) {
                        boolean extraMRStep = true;
                        if (qb.getIsQuery() && qbp.getClusterByForClause(dest) == null && qbp.getSortByForClause(dest) == null) {
                            extraMRStep = false;
                        }
                        curr = this.genLimitMapRedPlan(dest, qb, curr, limit, extraMRStep);
                        qb.getParseInfo().setOuterQueryLimit(limit);
                    }
                    curr = this.genFileSinkPlan(dest, qb, curr);
                }
                if (qb.getParseInfo().getAlias() == null) continue;
                RowResolver rr = this.opParseCtx.get(curr).getRR();
                RowResolver newRR = new RowResolver();
                String alias = qb.getParseInfo().getAlias();
                for (ColumnInfo colInfo : rr.getColumnInfos()) {
                    String name = colInfo.getInternalName();
                    String[] tmp = rr.reverseLookup(name);
                    newRR.put(alias, tmp[1], colInfo);
                }
                this.opParseCtx.get(curr).setRR(newRR);
            }
        }
        this.LOG.debug((Object)("Created Body Plan for Query Block " + qb.getId()));
        return curr;
    }

    private Operator genUnionPlan(String unionalias, String leftalias, Operator leftOp, String rightalias, Operator rightOp) throws SemanticException {
        RowResolver leftRR = this.opParseCtx.get(leftOp).getRR();
        RowResolver rightRR = this.opParseCtx.get(rightOp).getRR();
        HashMap<String, ColumnInfo> leftmap = leftRR.getFieldMap(leftalias);
        HashMap<String, ColumnInfo> rightmap = rightRR.getFieldMap(rightalias);
        if (leftmap.size() != rightmap.size()) {
            throw new SemanticException("Schema of both sides of union should match.");
        }
        for (Map.Entry<String, ColumnInfo> lEntry : leftmap.entrySet()) {
            String field = lEntry.getKey();
            ColumnInfo lInfo = lEntry.getValue();
            ColumnInfo rInfo = rightmap.get(field);
            if (rInfo == null) {
                throw new SemanticException("Schema of both sides of union should match. " + rightalias + " does not have the field " + field);
            }
            if (lInfo == null) {
                throw new SemanticException("Schema of both sides of union should match. " + leftalias + " does not have the field " + field);
            }
            if (!lInfo.getInternalName().equals(rInfo.getInternalName())) {
                throw new SemanticException("Schema of both sides of union should match: " + field + ":" + lInfo.getInternalName() + " " + rInfo.getInternalName());
            }
            if (lInfo.getType().getTypeName().equals(rInfo.getType().getTypeName())) continue;
            throw new SemanticException("Schema of both sides of union should match: Column " + field + " is of type " + lInfo.getType().getTypeName() + " on first table and type " + rInfo.getType().getTypeName() + " on second table");
        }
        RowResolver unionoutRR = new RowResolver();
        for (Map.Entry<String, ColumnInfo> lEntry : leftmap.entrySet()) {
            String field = lEntry.getKey();
            ColumnInfo lInfo = lEntry.getValue();
            unionoutRR.put(unionalias, field, lInfo);
        }
        if (leftOp instanceof UnionOperator || rightOp instanceof UnionOperator) {
            unionDesc uDesc;
            List<Operator<Serializable>> parent;
            ArrayList<Operator<? extends Serializable>> child;
            if (leftOp instanceof UnionOperator) {
                child = new ArrayList<Operator<? extends Serializable>>();
                child.add(leftOp);
                rightOp.setChildOperators(child);
                parent = leftOp.getParentOperators();
                parent.add(rightOp);
                uDesc = (unionDesc)((UnionOperator)leftOp).getConf();
                uDesc.setNumInputs(uDesc.getNumInputs() + 1);
                return this.putOpInsertMap(leftOp, unionoutRR);
            }
            child = new ArrayList();
            child.add(rightOp);
            leftOp.setChildOperators(child);
            parent = rightOp.getParentOperators();
            parent.add(leftOp);
            uDesc = (unionDesc)((UnionOperator)rightOp).getConf();
            uDesc.setNumInputs(uDesc.getNumInputs() + 1);
            return this.putOpInsertMap(rightOp, unionoutRR);
        }
        Operator<unionDesc> unionforward = OperatorFactory.getAndMakeChild(new unionDesc(), new RowSchema(unionoutRR.getColumnInfos()), new Operator[0]);
        ArrayList<Operator<? extends Serializable>> child = new ArrayList<Operator<? extends Serializable>>();
        child.add(unionforward);
        rightOp.setChildOperators(child);
        child = new ArrayList();
        child.add(unionforward);
        leftOp.setChildOperators(child);
        ArrayList<Operator<? extends Serializable>> parent = new ArrayList<Operator<? extends Serializable>>();
        parent.add(leftOp);
        parent.add(rightOp);
        unionforward.setParentOperators(parent);
        return this.putOpInsertMap(unionforward, unionoutRR);
    }

    private exprNodeDesc genSamplePredicate(TableSample ts, List<String> bucketCols, boolean useBucketCols, String alias, RowResolver rwsch, QBMetaData qbm, exprNodeDesc planExpr) throws SemanticException {
        exprNodeConstantDesc numeratorExpr = new exprNodeConstantDesc(TypeInfoFactory.intTypeInfo, ts.getNumerator() - 1);
        exprNodeConstantDesc denominatorExpr = new exprNodeConstantDesc(TypeInfoFactory.intTypeInfo, ts.getDenominator());
        exprNodeConstantDesc intMaxExpr = new exprNodeConstantDesc(TypeInfoFactory.intTypeInfo, Integer.MAX_VALUE);
        ArrayList<exprNodeDesc> args = new ArrayList<exprNodeDesc>();
        if (planExpr != null) {
            args.add(planExpr);
        } else if (useBucketCols) {
            for (String col : bucketCols) {
                ColumnInfo ci = rwsch.get(alias, col);
                args.add(new exprNodeColumnDesc(ci.getType(), ci.getInternalName(), ci.getTabAlias(), ci.getIsPartitionCol()));
            }
        } else {
            for (ASTNode expr : ts.getExprs()) {
                args.add(this.genExprNodeDesc(expr, rwsch));
            }
        }
        exprNodeDesc equalsExpr = null;
        exprNodeGenericFuncDesc hashfnExpr = new exprNodeGenericFuncDesc(TypeInfoFactory.intTypeInfo, new GenericUDFHash(), args);
        assert (hashfnExpr != null);
        this.LOG.info((Object)("hashfnExpr = " + hashfnExpr));
        exprNodeDesc andExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("&", hashfnExpr, intMaxExpr);
        assert (andExpr != null);
        this.LOG.info((Object)("andExpr = " + andExpr));
        exprNodeDesc modExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("%", andExpr, denominatorExpr);
        assert (modExpr != null);
        this.LOG.info((Object)("modExpr = " + modExpr));
        this.LOG.info((Object)("numeratorExpr = " + numeratorExpr));
        equalsExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("==", modExpr, numeratorExpr);
        this.LOG.info((Object)("equalsExpr = " + equalsExpr));
        assert (equalsExpr != null);
        return equalsExpr;
    }

    private Operator genTablePlan(String alias, QB qb) throws SemanticException {
        RowResolver rwsch;
        String alias_id = qb.getId() == null ? alias : qb.getId() + ":" + alias;
        Table tab = qb.getMetaData().getSrcForAlias(alias);
        Operator<? extends Serializable> top = this.topOps.get(alias_id);
        Operator<? extends Serializable> dummySel = this.topSelOps.get(alias_id);
        if (dummySel != null) {
            top = dummySel;
        }
        if (top == null) {
            rwsch = new RowResolver();
            try {
                StructObjectInspector rowObjectInspector = (StructObjectInspector)tab.getDeserializer().getObjectInspector();
                List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    rwsch.put(alias, fields.get(i).getFieldName(), new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), alias, false));
                }
            }
            catch (SerDeException e) {
                throw new RuntimeException(e);
            }
            for (FieldSchema part_col : tab.getPartCols()) {
                this.LOG.trace((Object)("Adding partition col: " + part_col));
                rwsch.put(alias, part_col.getName(), new ColumnInfo(part_col.getName(), TypeInfoFactory.stringTypeInfo, alias, true));
            }
            top = this.putOpInsertMap(OperatorFactory.get(new tableScanDesc(alias), new RowSchema(rwsch.getColumnInfos()), new Operator[0]), rwsch);
            this.topOps.put(alias_id, top);
            this.topToTable.put((TableScanOperator)top, tab);
        } else {
            rwsch = this.opParseCtx.get(top).getRR();
            top.setChildOperators(null);
        }
        Operator<? extends Serializable> tableOp = top;
        TableSample ts = qb.getParseInfo().getTabSample(alias);
        if (ts != null) {
            int num = ts.getNumerator();
            int den = ts.getDenominator();
            ArrayList<ASTNode> sampleExprs = ts.getExprs();
            List<String> tabBucketCols = tab.getBucketCols();
            int numBuckets = tab.getNumBuckets();
            if (tabBucketCols.size() == 0 && sampleExprs.size() == 0) {
                throw new SemanticException(ErrorMsg.NON_BUCKETED_TABLE.getMsg() + " " + tab.getName());
            }
            if (num > den) {
                throw new SemanticException(ErrorMsg.BUCKETED_NUMBERATOR_BIGGER_DENOMINATOR.getMsg() + " " + tab.getName());
            }
            boolean colsEqual = true;
            if (sampleExprs.size() != tabBucketCols.size() && sampleExprs.size() != 0) {
                colsEqual = false;
            }
            for (int i = 0; i < sampleExprs.size() && colsEqual; ++i) {
                boolean colFound = false;
                for (int j = 0; j < tabBucketCols.size() && !colFound && sampleExprs.get(i).getToken().getType() == 19; ++j) {
                    if (!((ASTNode)sampleExprs.get(i).getChild(0)).getText().equalsIgnoreCase(tabBucketCols.get(j))) continue;
                    colFound = true;
                }
                colsEqual = colsEqual && colFound;
            }
            ts.setInputPruning(sampleExprs == null || sampleExprs.size() == 0 || colsEqual);
            if (!(sampleExprs != null && sampleExprs.size() != 0 && !colsEqual || num != den && den % numBuckets != 0 && numBuckets % den != 0)) {
                this.LOG.info((Object)"No need for sample filter");
                exprNodeDesc samplePredicate = this.genSamplePredicate(ts, tabBucketCols, colsEqual, alias, rwsch, qb.getMetaData(), null);
                tableOp = OperatorFactory.getAndMakeChild(new filterDesc(samplePredicate, true, new filterDesc.sampleDesc(ts.getNumerator(), ts.getDenominator(), tabBucketCols, true)), top);
            } else {
                this.LOG.info((Object)"Need sample filter");
                exprNodeDesc samplePredicate = this.genSamplePredicate(ts, tabBucketCols, colsEqual, alias, rwsch, qb.getMetaData(), null);
                tableOp = OperatorFactory.getAndMakeChild(new filterDesc(samplePredicate, true), top);
            }
        } else {
            boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
            if (testMode) {
                String tabName = tab.getName();
                String unSampleTblList = this.conf.getVar(HiveConf.ConfVars.HIVETESTMODENOSAMPLE);
                String[] unSampleTbls = unSampleTblList.split(",");
                boolean unsample = false;
                for (String unSampleTbl : unSampleTbls) {
                    if (!tabName.equalsIgnoreCase(unSampleTbl)) continue;
                    unsample = true;
                }
                if (!unsample) {
                    int numBuckets = tab.getNumBuckets();
                    if (numBuckets > 0) {
                        TableSample tsSample = new TableSample(1, numBuckets);
                        tsSample.setInputPruning(true);
                        qb.getParseInfo().setTabSample(alias, tsSample);
                        exprNodeDesc samplePred = this.genSamplePredicate(tsSample, tab.getBucketCols(), true, alias, rwsch, qb.getMetaData(), null);
                        tableOp = OperatorFactory.getAndMakeChild(new filterDesc(samplePred, true, new filterDesc.sampleDesc(tsSample.getNumerator(), tsSample.getDenominator(), tab.getBucketCols(), true)), top);
                        this.LOG.info((Object)"No need for sample filter");
                    } else {
                        int freq = this.conf.getIntVar(HiveConf.ConfVars.HIVETESTMODESAMPLEFREQ);
                        TableSample tsSample = new TableSample(1, freq);
                        tsSample.setInputPruning(false);
                        qb.getParseInfo().setTabSample(alias, tsSample);
                        this.LOG.info((Object)"Need sample filter");
                        exprNodeDesc randFunc = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("rand", new exprNodeConstantDesc(460476415));
                        exprNodeDesc samplePred = this.genSamplePredicate(tsSample, null, false, alias, rwsch, qb.getMetaData(), randFunc);
                        tableOp = OperatorFactory.getAndMakeChild(new filterDesc(samplePred, true), top);
                    }
                }
            }
        }
        Operator<? extends Serializable> output = this.putOpInsertMap(tableOp, rwsch);
        this.LOG.debug((Object)("Created Table Plan for " + alias + " " + tableOp.toString()));
        return output;
    }

    private Operator genPlan(QBExpr qbexpr) throws SemanticException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            return this.genPlan(qbexpr.getQB());
        }
        if (qbexpr.getOpcode() == QBExpr.Opcode.UNION) {
            Operator qbexpr1Ops = this.genPlan(qbexpr.getQBExpr1());
            Operator qbexpr2Ops = this.genPlan(qbexpr.getQBExpr2());
            return this.genUnionPlan(qbexpr.getAlias(), qbexpr.getQBExpr1().getAlias(), qbexpr1Ops, qbexpr.getQBExpr2().getAlias(), qbexpr2Ops);
        }
        return null;
    }

    public Operator genPlan(QB qb) throws SemanticException {
        HashMap<String, Operator> aliasToOpInfo = new HashMap<String, Operator>();
        for (String alias : qb.getSubqAliases()) {
            QBExpr qbexpr = qb.getSubqForAlias(alias);
            aliasToOpInfo.put(alias, this.genPlan(qbexpr));
            qbexpr.setAlias(alias);
        }
        for (String alias : qb.getTabAliases()) {
            aliasToOpInfo.put(alias, this.genTablePlan(alias, qb));
        }
        this.genLateralViewPlans(aliasToOpInfo, qb);
        Operator srcOpInfo = null;
        if (qb.getParseInfo().getJoinExpr() != null) {
            QBJoinTree joinTree;
            ASTNode joinExpr = qb.getParseInfo().getJoinExpr();
            if (joinExpr.getToken().getType() == 60) {
                joinTree = this.genUniqueJoinTree(qb, joinExpr);
                qb.setQbJoinTree(joinTree);
            } else {
                joinTree = this.genJoinTree(qb, joinExpr);
                qb.setQbJoinTree(joinTree);
                this.mergeJoinTree(qb);
            }
            this.pushJoinFilters(qb, qb.getQbJoinTree(), aliasToOpInfo);
            srcOpInfo = this.genJoinPlan(qb, aliasToOpInfo);
        } else {
            srcOpInfo = aliasToOpInfo.values().iterator().next();
        }
        Operator bodyOpInfo = this.genBodyPlan(qb, srcOpInfo);
        this.LOG.debug((Object)("Created Plan for Query Block " + qb.getId()));
        this.qb = qb;
        return bodyOpInfo;
    }

    void genLateralViewPlans(HashMap<String, Operator> aliasToOpInfo, QB qb) throws SemanticException {
        Map<String, ArrayList<ASTNode>> aliasToLateralViews = qb.getParseInfo().getAliasToLateralViews();
        for (Map.Entry<String, Operator> e : aliasToOpInfo.entrySet()) {
            String alias = e.getKey();
            ArrayList<ASTNode> lateralViews = aliasToLateralViews.get(alias);
            if (lateralViews == null) continue;
            Operator<lateralViewJoinDesc> op = e.getValue();
            for (ASTNode lateralViewTree : aliasToLateralViews.get(alias)) {
                Operator<lateralViewJoinDesc> lateralViewJoin;
                RowResolver allPathRR = this.opParseCtx.get(op).getRR();
                Operator<selectDesc> allPath = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new selectDesc(true), new RowSchema(allPathRR.getColumnInfos()), op), allPathRR);
                QB blankQb = new QB(null, null, false);
                Operator<?> udtfPath = this.genSelectPlan((ASTNode)lateralViewTree.getChild(0), blankQb, op);
                RowResolver udtfPathRR = this.opParseCtx.get(udtfPath).getRR();
                RowResolver lateralViewRR = new RowResolver();
                ArrayList<String> outputInternalColNames = new ArrayList<String>();
                this.LVmergeRowResolvers(allPathRR, lateralViewRR, outputInternalColNames);
                this.LVmergeRowResolvers(udtfPathRR, lateralViewRR, outputInternalColNames);
                op = lateralViewJoin = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new lateralViewJoinDesc(outputInternalColNames), new RowSchema(lateralViewRR.getColumnInfos()), allPath, udtfPath), lateralViewRR);
            }
            e.setValue(op);
        }
    }

    private void LVmergeRowResolvers(RowResolver source, RowResolver dest, ArrayList<String> outputInternalColNames) {
        Vector<ColumnInfo> cols = source.getColumnInfos();
        for (ColumnInfo c : cols) {
            String internalName = SemanticAnalyzer.getColumnInternalName(outputInternalColNames.size());
            outputInternalColNames.add(internalName);
            ColumnInfo newCol = new ColumnInfo(internalName, c.getType(), c.getTabAlias(), c.getIsPartitionCol());
            String[] tableCol = source.reverseLookup(c.getInternalName());
            String tableAlias = tableCol[0];
            String colAlias = tableCol[1];
            dest.put(tableAlias, colAlias, newCol);
        }
    }

    private Operator<? extends Serializable> getReduceSink(Operator<? extends Serializable> top) {
        if (top.getClass() == ReduceSinkOperator.class) {
            assert (top.getChildOperators().size() == 1);
            return top;
        }
        List<Operator<Serializable>> childOps = top.getChildOperators();
        if (childOps == null) {
            return null;
        }
        for (int i = 0; i < childOps.size(); ++i) {
            Operator<? extends Serializable> reducer = this.getReduceSink(childOps.get(i));
            if (reducer == null) continue;
            return reducer;
        }
        return null;
    }

    private void genMapRedTasks(QB qb) throws SemanticException {
        fetchWork fetch = null;
        ArrayList<Task<? extends Serializable>> mvTask = new ArrayList<Task<? extends Serializable>>();
        Task<Object> fetchTask = null;
        QBParseInfo qbParseInfo = qb.getParseInfo();
        if (qb.isSelectStarQuery() && qbParseInfo.getDestToClusterBy().isEmpty() && qbParseInfo.getDestToDistributeBy().isEmpty() && qbParseInfo.getDestToOrderBy().isEmpty() && qbParseInfo.getDestToSortBy().isEmpty()) {
            TableScanOperator ts;
            boolean noMapRed = false;
            Iterator<Map.Entry<String, Table>> iter = qb.getMetaData().getAliasToTable().entrySet().iterator();
            Table tab = iter.next().getValue();
            if (!tab.isPartitioned()) {
                if (qbParseInfo.getDestToWhereExpr().isEmpty()) {
                    fetch = new fetchWork(tab.getPath().toString(), Utilities.getTableDesc(tab), qb.getParseInfo().getOuterQueryLimit());
                    noMapRed = true;
                    this.inputs.add(new ReadEntity(tab));
                }
            } else if (this.topOps.size() == 1 && PartitionPruner.onlyContainsPartnCols(this.topToTable.get(ts = (TableScanOperator)this.topOps.values().toArray()[0]), this.opToPartPruner.get(ts))) {
                PrunedPartitionList partsList = null;
                try {
                    partsList = PartitionPruner.prune(this.topToTable.get(ts), this.opToPartPruner.get(ts), this.conf, (String)this.topOps.keySet().toArray()[0], this.prunedPartitions);
                }
                catch (HiveException e) {
                    this.LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    throw new SemanticException(e.getMessage(), e);
                }
                if (partsList.getUnknownPartns().size() == 0) {
                    ArrayList<String> listP = new ArrayList<String>();
                    ArrayList<partitionDesc> partP = new ArrayList<partitionDesc>();
                    Set<Partition> parts = partsList.getConfirmedPartns();
                    for (Partition part : parts) {
                        listP.add(part.getPartitionPath().toString());
                        try {
                            partP.add(Utilities.getPartitionDesc(part));
                        }
                        catch (HiveException e) {
                            throw new SemanticException(e.getMessage(), e);
                        }
                        this.inputs.add(new ReadEntity(part));
                    }
                    fetch = new fetchWork(listP, partP, qb.getParseInfo().getOuterQueryLimit());
                    noMapRed = true;
                }
            }
            if (noMapRed) {
                fetchTask = TaskFactory.get(fetch, this.conf, new Task[0]);
                this.setFetchTask(fetchTask);
                this.rootTasks.clear();
                return;
            }
        }
        if (qb.getIsQuery()) {
            if (!this.loadTableWork.isEmpty() || this.loadFileWork.size() != 1) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            String cols = this.loadFileWork.get(0).getColumns();
            String colTypes = this.loadFileWork.get(0).getColumnTypes();
            fetch = new fetchWork(new Path(this.loadFileWork.get(0).getSourceDir()).toString(), new tableDesc(LazySimpleSerDe.class, TextInputFormat.class, IgnoreKeyTextOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "columns", cols, "columns.types", colTypes)), qb.getParseInfo().getOuterQueryLimit());
            fetchTask = TaskFactory.get(fetch, this.conf, new Task[0]);
            this.setFetchTask(fetchTask);
        } else {
            ArrayList mv = new ArrayList();
            for (loadTableDesc ltd : this.loadTableWork) {
                mvTask.add(TaskFactory.get(new moveWork(null, null, ltd, null, false), this.conf, new Task[0]));
            }
            boolean oneLoadFile = true;
            for (loadFileDesc lfd : this.loadFileWork) {
                if (qb.isCTAS()) {
                    assert (oneLoadFile);
                    String location = qb.getTableDesc().getLocation();
                    if (location == null) {
                        location = this.conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
                        assert (location.length() > 0);
                        if (location.charAt(location.length() - 1) != '/') {
                            location = location + '/';
                        }
                        location = location + qb.getTableDesc().getTableName().toLowerCase();
                    }
                    lfd.setTargetDir(location);
                    oneLoadFile = false;
                }
                mvTask.add(TaskFactory.get(new moveWork(null, null, null, lfd, false), this.conf, new Task[0]));
            }
        }
        GenMRProcContext procCtx = new GenMRProcContext(this.conf, new HashMap<Operator<? extends Serializable>, Task<? extends Serializable>>(), new ArrayList<Operator<? extends Serializable>>(), this.getParseContext(), mvTask, this.rootTasks, new LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx>(), this.inputs, this.outputs);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp(new String("R1"), "TS%"), new GenMRTableScan1());
        opRules.put(new RuleRegExp(new String("R2"), "TS%.*RS%"), new GenMRRedSink1());
        opRules.put(new RuleRegExp(new String("R3"), "RS%.*RS%"), new GenMRRedSink2());
        opRules.put(new RuleRegExp(new String("R4"), "FS%"), new GenMRFileSink1());
        opRules.put(new RuleRegExp(new String("R5"), "UNION%"), new GenMRUnion1());
        opRules.put(new RuleRegExp(new String("R6"), "UNION%.*RS%"), new GenMRRedSink3());
        opRules.put(new RuleRegExp(new String("R6"), "MAPJOIN%.*RS%"), new GenMRRedSink4());
        opRules.put(new RuleRegExp(new String("R7"), "TS%.*MAPJOIN%"), MapJoinFactory.getTableScanMapJoin());
        opRules.put(new RuleRegExp(new String("R8"), "RS%.*MAPJOIN%"), MapJoinFactory.getReduceSinkMapJoin());
        opRules.put(new RuleRegExp(new String("R9"), "UNION%.*MAPJOIN%"), MapJoinFactory.getUnionMapJoin());
        opRules.put(new RuleRegExp(new String("R10"), "MAPJOIN%.*MAPJOIN%"), MapJoinFactory.getMapJoinMapJoin());
        opRules.put(new RuleRegExp(new String("R11"), "MAPJOIN%SEL%"), MapJoinFactory.getMapJoin());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new GenMROperator(), opRules, procCtx);
        GenMapRedWalker ogw = new GenMapRedWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.topOps.values());
        ogw.startWalking(topNodes, null);
        for (Task rootTask : this.rootTasks) {
            this.breakTaskTree(rootTask);
        }
        for (Task rootTask : this.rootTasks) {
            this.setKeyDescTaskTree(rootTask);
        }
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVEJOBPROGRESS)) {
            for (Task rootTask : this.rootTasks) {
                this.generateCountersTask(rootTask);
            }
        }
        if (qb.isCTAS()) {
            createTableDesc crtTblDesc = qb.getTableDesc();
            this.validateCreateTable(crtTblDesc);
            this.getOutputs().clear();
            Task<DDLWork> crtTblTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTblDesc), this.conf, new Task[0]);
            HashSet<Task<? extends Serializable>> leaves = new HashSet<Task<? extends Serializable>>();
            this.getLeafTasks(this.rootTasks, leaves);
            assert (leaves.size() > 0);
            for (Task<? extends Serializable> task : leaves) {
                task.addDependentTask(crtTblTask);
            }
        }
    }

    private void getLeafTasks(List<Task<? extends Serializable>> rootTasks, HashSet<Task<? extends Serializable>> leaves) {
        for (Task<? extends Serializable> root : rootTasks) {
            this.getLeafTasks(root, leaves);
        }
    }

    private void getLeafTasks(Task<? extends Serializable> task, HashSet<Task<? extends Serializable>> leaves) {
        if (task.getChildTasks() == null) {
            if (!leaves.contains(task)) {
                leaves.add(task);
            }
        } else {
            this.getLeafTasks(task.getChildTasks(), leaves);
        }
    }

    private void generateCountersTask(Task<? extends Serializable> task) {
        if (task instanceof MapRedTask || task instanceof ExecDriver) {
            Operator<?> reducer;
            LinkedHashMap<String, Operator<? extends Serializable>> opMap = ((mapredWork)task.getWork()).getAliasToWork();
            if (!opMap.isEmpty()) {
                for (Operator operator : ((HashMap)opMap).values()) {
                    this.generateCountersOperator(operator);
                }
            }
            if ((reducer = ((mapredWork)task.getWork()).getReducer()) != null) {
                this.LOG.info((Object)("Generating counters for operator " + reducer));
                this.generateCountersOperator(reducer);
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task task2 : listTasks) {
                this.generateCountersTask(task2);
            }
        }
        Operator.resetLastEnumUsed();
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            this.generateCountersTask(childTask);
        }
    }

    private void generateCountersOperator(Operator<? extends Serializable> op) {
        op.assignCounterNameToEnum();
        if (op.getChildOperators() == null) {
            return;
        }
        for (Operator<Serializable> child : op.getChildOperators()) {
            this.generateCountersOperator(child);
        }
    }

    private void breakTaskTree(Task<? extends Serializable> task) {
        if (task instanceof MapRedTask || task instanceof ExecDriver) {
            LinkedHashMap<String, Operator<? extends Serializable>> opMap = ((mapredWork)task.getWork()).getAliasToWork();
            if (!opMap.isEmpty()) {
                for (Operator operator : ((HashMap)opMap).values()) {
                    this.breakOperatorTree(operator);
                }
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task task2 : listTasks) {
                this.breakTaskTree(task2);
            }
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            this.breakTaskTree(childTask);
        }
    }

    private void breakOperatorTree(Operator<? extends Serializable> topOp) {
        if (topOp instanceof ReduceSinkOperator) {
            topOp.setChildOperators(null);
        }
        if (topOp.getChildOperators() == null) {
            return;
        }
        for (Operator<Serializable> op : topOp.getChildOperators()) {
            this.breakOperatorTree(op);
        }
    }

    private void setKeyDescTaskTree(Task<? extends Serializable> task) {
        if (task instanceof MapRedTask || task instanceof ExecDriver) {
            mapredWork work = (mapredWork)task.getWork();
            work.deriveExplainAttributes();
            LinkedHashMap<String, Operator<? extends Serializable>> opMap = work.getAliasToWork();
            if (!opMap.isEmpty()) {
                for (Operator op : ((HashMap)opMap).values()) {
                    GenMapRedUtils.setKeyAndValueDesc(work, op);
                }
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task<? extends Serializable> tsk : listTasks) {
                this.setKeyDescTaskTree(tsk);
            }
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            this.setKeyDescTaskTree(childTask);
        }
    }

    public Phase1Ctx initPhase1Ctx() {
        Phase1Ctx ctx_1 = new Phase1Ctx();
        ctx_1.nextNum = 0;
        ctx_1.dest = "reduce";
        return ctx_1;
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        QB qb;
        this.reset();
        this.qb = qb = new QB(null, null, false);
        this.ast = ast;
        ASTNode child = ast;
        this.LOG.info((Object)"Starting Semantic Analysis");
        if (ast.getToken().getType() == 79 && (child = this.analyzeCreateTable(ast, qb)) == null) {
            return;
        }
        this.doPhase1(child, qb, this.initPhase1Ctx());
        this.LOG.info((Object)"Completed phase 1 of Semantic Analysis");
        this.getMetaData(qb);
        this.LOG.info((Object)"Completed getting MetaData in Semantic Analysis");
        this.genPlan(qb);
        ParseContext pCtx = new ParseContext(this.conf, qb, child, this.opToPartPruner, this.topOps, this.topSelOps, this.opParseCtx, this.joinContext, this.topToTable, this.loadTableWork, this.loadFileWork, this.ctx, this.idToTableNameMap, this.destTableId, this.uCtx, this.listMapJoinOpsNoReducer, this.groupOpToInputTables, this.prunedPartitions, this.opToSamplePruner);
        Optimizer optm = new Optimizer();
        optm.setPctx(pCtx);
        optm.initialize(this.conf);
        pCtx = optm.optimize();
        this.init(pCtx);
        qb = pCtx.getQB();
        this.genMapRedTasks(qb);
        this.LOG.info((Object)"Completed plan generation");
    }

    public exprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input) throws SemanticException {
        ColumnInfo colInfo = input.get("", expr.toStringTree());
        if (colInfo != null) {
            return new exprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsPartitionCol());
        }
        TypeCheckCtx tcCtx = new TypeCheckCtx(input);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "62%"), TypeCheckProcFactory.getNullExprProcessor());
        opRules.put(new RuleRegExp("R2", "209%"), TypeCheckProcFactory.getNumExprProcessor());
        opRules.put(new RuleRegExp("R3", "160%|151%|122%|155%|281%|282%"), TypeCheckProcFactory.getStrExprProcessor());
        opRules.put(new RuleRegExp("R4", "306%|307%"), TypeCheckProcFactory.getBoolExprProcessor());
        opRules.put(new RuleRegExp("R5", "19%"), TypeCheckProcFactory.getColumnExprProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(TypeCheckProcFactory.getDefaultExprProcessor(), opRules, tcCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.add(expr);
        HashMap<Node, Object> nodeOutputs = new HashMap<Node, Object>();
        ogw.startWalking(topNodes, nodeOutputs);
        exprNodeDesc desc = (exprNodeDesc)nodeOutputs.get(expr);
        if (desc == null) {
            throw new SemanticException(tcCtx.getError());
        }
        return desc;
    }

    static String getTabAliasForCol(QBMetaData qbm, String colName, ASTNode pt) throws SemanticException {
        String tabAlias = null;
        boolean found = false;
        for (Map.Entry<String, Table> ent : qbm.getAliasToTable().entrySet()) {
            for (FieldSchema field : ent.getValue().getAllCols()) {
                if (!colName.equalsIgnoreCase(field.getName())) continue;
                if (found) {
                    throw new SemanticException(ErrorMsg.AMBIGUOUS_COLUMN.getMsg(pt));
                }
                found = true;
                tabAlias = ent.getKey();
            }
        }
        return tabAlias;
    }

    @Override
    public void validate() throws SemanticException {
        for (Task rootTask : this.rootTasks) {
            this.validate(rootTask);
        }
    }

    private void validate(Task<? extends Serializable> task) throws SemanticException {
        if (task instanceof MapRedTask || task instanceof ExecDriver) {
            mapredWork work = (mapredWork)task.getWork();
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            this.validate(childTask);
        }
    }

    public RowResolver getRowResolver(Operator opt) {
        return this.opParseCtx.get(opt).getRR();
    }

    private ASTNode analyzeCreateTable(ASTNode ast, QB qb) throws SemanticException {
        String tableName = SemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String likeTableName = null;
        List<FieldSchema> cols = null;
        List<FieldSchema> partCols = null;
        List<String> bucketCols = null;
        List<Order> sortCols = null;
        int numBuckets = -1;
        String fieldDelim = null;
        String fieldEscape = null;
        String collItemDelim = null;
        String mapKeyDelim = null;
        String lineDelim = null;
        String comment = null;
        String inputFormat = TEXTFILE_INPUT;
        String outputFormat = TEXTFILE_OUTPUT;
        String location = null;
        String serde = null;
        HashMap<String, String> mapProp = null;
        boolean ifNotExists = false;
        boolean isExt = false;
        ASTNode selectStmt = null;
        boolean CREATE_TABLE = false;
        boolean CTLT = true;
        int CTAS = 2;
        int command_type = 0;
        if ("SequenceFile".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.HIVEDEFAULTFILEFORMAT))) {
            inputFormat = SEQUENCEFILE_INPUT;
            outputFormat = SEQUENCEFILE_OUTPUT;
        } else if ("RCFile".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.HIVEDEFAULTFILEFORMAT))) {
            inputFormat = RCFILE_INPUT;
            outputFormat = RCFILE_OUTPUT;
            serde = COLUMNAR_SERDE;
        }
        this.LOG.info((Object)("Creating table" + tableName + " positin=" + ast.getCharPositionInLine()));
        int numCh = ast.getChildCount();
        block32: for (int num = 1; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 132: {
                    ifNotExists = true;
                    continue block32;
                }
                case 159: {
                    isExt = true;
                    continue block32;
                }
                case 80: {
                    if (child.getChildCount() <= 0) continue block32;
                    likeTableName = SemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    if (likeTableName != null) {
                        if (command_type == 2) {
                            throw new SemanticException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                        }
                        if (cols != null) {
                            throw new SemanticException(ErrorMsg.CTLT_COLLST_COEXISTENCE.getMsg());
                        }
                    }
                    command_type = 1;
                    continue block32;
                }
                case 5: {
                    if (command_type == 1) {
                        throw new SemanticException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                    }
                    if (cols != null) {
                        throw new SemanticException(ErrorMsg.CTAS_COLLST_COEXISTENCE.getMsg());
                    }
                    if (partCols != null || bucketCols != null) {
                        throw new SemanticException(ErrorMsg.CTAS_PARCOL_COEXISTENCE.getMsg());
                    }
                    if (isExt) {
                        throw new SemanticException(ErrorMsg.CTAS_EXTTBL_COEXISTENCE.getMsg());
                    }
                    command_type = 2;
                    selectStmt = child;
                    continue block32;
                }
                case 100: {
                    cols = this.getColumns(child);
                    continue block32;
                }
                case 102: {
                    comment = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block32;
                }
                case 103: {
                    partCols = this.getColumns((ASTNode)child.getChild(0));
                    continue block32;
                }
                case 104: {
                    bucketCols = this.getColumnNames((ASTNode)child.getChild(0));
                    if (child.getChildCount() == 2) {
                        numBuckets = Integer.valueOf(child.getChild(1).getText());
                        continue block32;
                    }
                    sortCols = this.getColumnNamesOrder((ASTNode)child.getChild(1));
                    numBuckets = Integer.valueOf(child.getChild(2).getText());
                    continue block32;
                }
                case 105: {
                    child = (ASTNode)child.getChild(0);
                    int numChildRowFormat = child.getChildCount();
                    block33: for (int numC = 0; numC < numChildRowFormat; ++numC) {
                        ASTNode rowChild = (ASTNode)child.getChild(numC);
                        switch (rowChild.getToken().getType()) {
                            case 106: {
                                fieldDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                                if (rowChild.getChildCount() < 2) continue block33;
                                fieldEscape = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(1).getText());
                                continue block33;
                            }
                            case 107: {
                                collItemDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                                continue block33;
                            }
                            case 108: {
                                mapKeyDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                                continue block33;
                            }
                            case 109: {
                                lineDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                                if (lineDelim.equals("\n") || lineDelim.equals("10")) continue block33;
                                throw new SemanticException(ErrorMsg.LINES_TERMINATED_BY_NON_NEWLINE.getMsg());
                            }
                            default: {
                                assert (false);
                                continue block33;
                            }
                        }
                    }
                    continue block32;
                }
                case 126: {
                    child = (ASTNode)child.getChild(0);
                    serde = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    if (child.getChildCount() != 2) continue block32;
                    mapProp = new HashMap<String, String>();
                    ASTNode prop = (ASTNode)((ASTNode)child.getChild(1)).getChild(0);
                    for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
                        String key = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
                        String value = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
                        mapProp.put(key, value);
                    }
                    continue block32;
                }
                case 110: {
                    inputFormat = SEQUENCEFILE_INPUT;
                    outputFormat = SEQUENCEFILE_OUTPUT;
                    continue block32;
                }
                case 111: {
                    inputFormat = TEXTFILE_INPUT;
                    outputFormat = TEXTFILE_OUTPUT;
                    continue block32;
                }
                case 112: {
                    inputFormat = RCFILE_INPUT;
                    outputFormat = RCFILE_OUTPUT;
                    serde = COLUMNAR_SERDE;
                    continue block32;
                }
                case 113: {
                    inputFormat = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    outputFormat = SemanticAnalyzer.unescapeSQLString(child.getChild(1).getText());
                    continue block32;
                }
                case 116: {
                    location = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block32;
                }
                default: {
                    assert (false);
                    continue block32;
                }
            }
        }
        if (ifNotExists) {
            try {
                List<String> tables = this.db.getTablesByPattern(tableName);
                if (tables != null && tables.size() > 0) {
                    return null;
                }
            }
            catch (HiveException e) {
                e.printStackTrace();
            }
        }
        createTableDesc crtTblDesc = null;
        switch (command_type) {
            case 0: {
                crtTblDesc = new createTableDesc(tableName, isExt, cols, partCols, bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serde, mapProp, ifNotExists);
                this.validateCreateTable(crtTblDesc);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTblDesc), this.conf, new Task[0]));
                break;
            }
            case 1: {
                createTableLikeDesc crtTblLikeDesc = new createTableLikeDesc(tableName, isExt, location, ifNotExists, likeTableName);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTblLikeDesc), this.conf, new Task[0]));
                break;
            }
            case 2: {
                try {
                    Table tab = this.db.getTable("default", tableName, false);
                    if (tab != null) {
                        throw new SemanticException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(tableName));
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
                crtTblDesc = new createTableDesc(tableName, isExt, cols, partCols, bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serde, mapProp, ifNotExists);
                qb.setTableDesc(crtTblDesc);
                return selectStmt;
            }
            default: {
                assert (false);
                break;
            }
        }
        return null;
    }

    private void validateCreateTable(createTableDesc crtTblDesc) throws SemanticException {
        if (crtTblDesc.getCols() == null || crtTblDesc.getCols().size() == 0) {
            if (StringUtils.isEmpty(crtTblDesc.getSerName()) || SerDeUtils.isNativeSerDe(crtTblDesc.getSerName())) {
                throw new SemanticException(ErrorMsg.INVALID_TBL_DDL_SERDE.getMsg());
            }
            return;
        }
        try {
            Class<?> origin = Class.forName(crtTblDesc.getOutputFormat(), true, JavaUtils.getClassLoader());
            Class<? extends HiveOutputFormat> replaced = HiveFileFormatUtils.getOutputFormatSubstitute(origin);
            if (replaced == null) {
                throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
            }
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
        }
        Iterator<FieldSchema> iterCols = crtTblDesc.getCols().iterator();
        ArrayList<String> colNames = new ArrayList<String>();
        while (iterCols.hasNext()) {
            String colName = iterCols.next().getName();
            for (String oldColName : colNames) {
                if (!colName.equalsIgnoreCase(oldColName)) continue;
                throw new SemanticException(ErrorMsg.DUPLICATE_COLUMN_NAMES.getMsg());
            }
            colNames.add(colName);
        }
        if (crtTblDesc.getBucketCols() != null) {
            for (String bucketCol : crtTblDesc.getBucketCols()) {
                boolean found = false;
                for (String colName : colNames) {
                    if (!bucketCol.equalsIgnoreCase(colName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg());
            }
        }
        if (crtTblDesc.getSortCols() != null) {
            Iterator<Order> sortCols = crtTblDesc.getSortCols().iterator();
            while (sortCols.hasNext()) {
                String sortCol = sortCols.next().getCol();
                boolean found = false;
                for (String colName : colNames) {
                    if (!sortCol.equalsIgnoreCase(colName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg());
            }
        }
        if (crtTblDesc.getPartCols() != null) {
            Iterator<FieldSchema> partColsIter = crtTblDesc.getPartCols().iterator();
            while (partColsIter.hasNext()) {
                String partCol = partColsIter.next().getName();
                Iterator colNamesIter = colNames.iterator();
                while (colNamesIter.hasNext()) {
                    String colName = SemanticAnalyzer.unescapeIdentifier((String)colNamesIter.next());
                    if (!partCol.equalsIgnoreCase(colName)) continue;
                    throw new SemanticException(ErrorMsg.COLUMN_REPEATED_IN_PARTITIONING_COLS.getMsg());
                }
            }
        }
    }

    static class GenericUDAFInfo {
        ArrayList<exprNodeDesc> convertedParameters;
        GenericUDAFEvaluator genericUDAFEvaluator;
        TypeInfo returnType;

        GenericUDAFInfo() {
        }
    }

    private static class Phase1Ctx {
        String dest;
        int nextNum;

        private Phase1Ctx() {
        }
    }
}

