/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TIOStreamTransport
extends TTransport {
    private static final Logger LOGGER = Logger.getLogger((String)TIOStreamTransport.class.getName());
    protected InputStream inputStream_ = null;
    protected OutputStream outputStream_ = null;

    protected TIOStreamTransport() {
    }

    public TIOStreamTransport(InputStream is) {
        this.inputStream_ = is;
    }

    public TIOStreamTransport(OutputStream os) {
        this.outputStream_ = os;
    }

    public TIOStreamTransport(InputStream is, OutputStream os) {
        this.inputStream_ = is;
        this.outputStream_ = os;
    }

    public boolean isOpen() {
        return true;
    }

    public void open() throws TTransportException {
    }

    public void close() {
        if (this.inputStream_ != null) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iox) {
                LOGGER.warn((Object)"Error closing input stream.", (Throwable)iox);
            }
            this.inputStream_ = null;
        }
        if (this.outputStream_ != null) {
            try {
                this.outputStream_.close();
            }
            catch (IOException iox) {
                LOGGER.warn((Object)"Error closing output stream.", (Throwable)iox);
            }
            this.outputStream_ = null;
        }
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.inputStream_ == null) {
            throw new TTransportException(1, "Cannot read from null inputStream");
        }
        try {
            return this.inputStream_.read(buf, off, len);
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        if (this.outputStream_ == null) {
            throw new TTransportException(1, "Cannot write to null outputStream");
        }
        try {
            this.outputStream_.write(buf, off, len);
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
    }

    public void flush() throws TTransportException {
        if (this.outputStream_ == null) {
            throw new TTransportException(1, "Cannot flush null outputStream");
        }
        try {
            this.outputStream_.flush();
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
    }
}

