/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.javaoptions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.aspectj.ajde.ui.javaoptions.JavaBuildOptions;
import org.aspectj.ajde.ui.swing.OptionsPanel;

public class JavaOtherOptionsPanel
extends OptionsPanel {
    private static final long serialVersionUID = 4491319302490183151L;
    private JPanel parentPanel;
    private Border otherEtchedBorder;
    private TitledBorder otherTitleBorder;
    private Border otherCompoundBorder;
    private JPanel otherPanel;
    private Box otherBox = Box.createVerticalBox();
    private JavaBuildOptions javaBuildOptions;
    private JTextField characterEncoding;

    public JavaOtherOptionsPanel(JavaBuildOptions javaBuildOptions) {
        this.javaBuildOptions = javaBuildOptions;
        try {
            this.jbInit();
            this.setName("Java Other Build Options");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadOptions() throws IOException {
        this.createOtherContents();
    }

    public void saveOptions() throws IOException {
        String text = this.characterEncoding.getText();
        if (text != null) {
            this.javaBuildOptions.setCharacterEncoding(text);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.createBorders();
        this.addBordersToPanel();
        this.add((Component)this.parentPanel, "North");
    }

    private void createOtherContents() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        label.setFont(new Font("Dialog", 0, 11));
        label.setText("Character encoding (will default to platform encoding)");
        panel.add((Component)label, "West");
        this.characterEncoding = new JTextField();
        this.characterEncoding.setFont(new Font("SansSerif", 0, 11));
        this.characterEncoding.setMinimumSize(new Dimension(100, 21));
        this.characterEncoding.setPreferredSize(new Dimension(150, 21));
        panel.add((Component)this.characterEncoding, "East");
        String option = (String)this.javaBuildOptions.getJavaBuildOptionsMap().get("org.eclipse.jdt.core.encoding");
        if (option != null) {
            this.characterEncoding.setText(option);
        }
        this.otherBox.add((Component)panel, null);
        this.otherPanel.add(this.otherBox);
    }

    private void createBorders() {
        this.otherEtchedBorder = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.otherTitleBorder = new TitledBorder(this.otherEtchedBorder, "Other Options");
        this.otherCompoundBorder = BorderFactory.createCompoundBorder(this.otherTitleBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.otherTitleBorder.setTitleFont(new Font("Dialog", 0, 11));
    }

    private void addBordersToPanel() {
        this.parentPanel = new JPanel();
        this.parentPanel.setLayout(new BorderLayout());
        this.otherPanel = new JPanel();
        this.otherPanel.setBorder(this.otherCompoundBorder);
        this.parentPanel.add((Component)this.otherPanel, "Center");
    }
}

