/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;

public abstract class RuntimeAnnotations
extends Attribute {
    private List annotations;
    private boolean visible;
    private boolean inflated = false;
    private byte[] annotation_data;

    public RuntimeAnnotations(byte attrid, boolean visible, int nameIdx, int len, ConstantPool cpool) {
        super(attrid, nameIdx, len, cpool);
        this.visible = visible;
        this.annotations = new ArrayList();
    }

    public RuntimeAnnotations(byte attrid, boolean visible, int nameIdx, int len, byte[] data, ConstantPool cpool) {
        super(attrid, nameIdx, len, cpool);
        this.visible = visible;
        this.annotations = new ArrayList();
        this.annotation_data = data;
    }

    public List getAnnotations() {
        if (!this.inflated) {
            this.inflate();
        }
        return this.annotations;
    }

    public boolean areVisible() {
        return this.visible;
    }

    protected void readAnnotations(DataInputStream dis, ConstantPool cpool) throws IOException {
        this.annotation_data = new byte[this.length];
        dis.read(this.annotation_data, 0, this.length);
    }

    protected void writeAnnotations(DataOutputStream dos) throws IOException {
        if (!this.inflated) {
            dos.write(this.annotation_data, 0, this.length);
        } else {
            dos.writeShort(this.annotations.size());
            Iterator i = this.annotations.iterator();
            while (i.hasNext()) {
                AnnotationGen ann = (AnnotationGen)i.next();
                ann.dump(dos);
            }
        }
    }

    private void inflate() {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.annotation_data));
            int numberOfAnnotations = dis.readUnsignedShort();
            int i = 0;
            while (i < numberOfAnnotations) {
                this.annotations.add(AnnotationGen.read(dis, this.getConstantPool(), this.visible));
                ++i;
            }
            dis.close();
            this.inflated = true;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unabled to inflate annotation data, badly formed? ");
        }
    }

    public boolean isInflated() {
        return this.inflated;
    }
}

