/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.log4j.Logger;
import org.apache.pig.LoadPushDown;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextInputFormat;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.bzip2r.Bzip2TextInputFormat;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.StorageUtil;
import org.apache.pig.impl.util.UDFContext;

public class CSVExcelStorage
extends PigStorage
implements StoreFuncInterface,
LoadPushDown {
    protected static final byte LINEFEED = 10;
    protected static final byte NEWLINE = 13;
    protected static final byte DOUBLE_QUOTE = 34;
    protected static final byte RECORD_DEL = 10;
    private static final byte FIELD_DEL_DEFAULT = 44;
    private static final String MULTILINE_DEFAULT_STR = "NOMULTILINE";
    private static final String LINEBREAKS_DEFAULT_STR = "NOCHANGE";
    private static final Multiline MULTILINE_DEFAULT = Multiline.NO;
    private static final Linebreaks LINEBREAKS_DEFAULT = Linebreaks.NOCHANGE;
    long end = Long.MAX_VALUE;
    private byte fieldDelimiter = (byte)44;
    private Linebreaks eolTreatment = LINEBREAKS_DEFAULT;
    private Multiline multilineTreatment = MULTILINE_DEFAULT;
    private ArrayList<Object> mProtoTuple = null;
    private TupleFactory mTupleFactory = TupleFactory.getInstance();
    private String signature;
    private String loadLocation;
    private boolean[] mRequiredColumns = null;
    private boolean mRequiredColumnsInitialized = false;
    final Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    protected RecordReader in = null;
    Pattern loneLFDetectorPattern = Pattern.compile("([^\r])\n", 40);
    Matcher loneLFDetector = this.loneLFDetectorPattern.matcher("");
    Pattern CRLFDetectorPattern = Pattern.compile("\r\n", 40);
    Matcher CRLFDetector = this.CRLFDetectorPattern.matcher("");
    TupleFactory tupleMaker = TupleFactory.getInstance();
    private boolean getNextInQuotedField;
    private int getNextFieldID;
    private boolean nextTupleSkipChar;

    public CSVExcelStorage() {
        super(new String(new byte[]{44}));
    }

    public CSVExcelStorage(String delimiter) {
        super(delimiter);
        this.initializeInstance(delimiter, MULTILINE_DEFAULT_STR, LINEBREAKS_DEFAULT_STR);
    }

    public CSVExcelStorage(String delimiter, String multilineTreatment) {
        super(delimiter);
        this.initializeInstance(delimiter, multilineTreatment, LINEBREAKS_DEFAULT_STR);
    }

    public CSVExcelStorage(String delimiter, String multilineTreatment, String eolTreatment) {
        super(delimiter);
        this.initializeInstance(delimiter, multilineTreatment, eolTreatment);
    }

    private void initializeInstance(String delimiter, String multilineStr, String theEofTreatment) {
        this.fieldDelimiter = StorageUtil.parseFieldDel((String)delimiter);
        this.multilineTreatment = this.canonicalizeMultilineTreatmentRequest(multilineStr);
        this.eolTreatment = this.canonicalizeEOLTreatmentRequest(theEofTreatment);
    }

    private Multiline canonicalizeMultilineTreatmentRequest(String theMultilineStr) {
        if (theMultilineStr.equalsIgnoreCase("YES_MULTILINE")) {
            return Multiline.YES;
        }
        if (theMultilineStr.equalsIgnoreCase("NO_MULTILINE")) {
            return Multiline.NO;
        }
        return MULTILINE_DEFAULT;
    }

    private Linebreaks canonicalizeEOLTreatmentRequest(String theEolTreatmentStr) {
        if (theEolTreatmentStr.equalsIgnoreCase("Unix")) {
            return Linebreaks.UNIX;
        }
        if (theEolTreatmentStr.equalsIgnoreCase("Windows")) {
            return Linebreaks.WINDOWS;
        }
        return LINEBREAKS_DEFAULT;
    }

    public void putNext(Tuple tupleToWrite) throws IOException {
        ArrayList<String> mProtoTuple = new ArrayList<String>();
        int embeddedNewlineIndex = -1;
        String fieldStr = null;
        int fieldCounter = -1;
        for (Object field : tupleToWrite.getAll()) {
            ++fieldCounter;
            if (field == null) {
                this.logger.warn((Object)("Field " + fieldCounter + " within tuple '" + tupleToWrite + "' is null."));
                return;
            }
            fieldStr = field.toString();
            fieldStr = fieldStr.replaceAll("[\"]", "\"\"");
            embeddedNewlineIndex = fieldStr.indexOf(10);
            if (fieldStr.indexOf(this.fieldDelimiter) != -1 || fieldStr.indexOf(34) != -1 || this.multilineTreatment == Multiline.YES && embeddedNewlineIndex != -1) {
                fieldStr = "\"" + fieldStr + "\"";
            }
            if (this.eolTreatment != Linebreaks.NOCHANGE && embeddedNewlineIndex != -1) {
                if (this.eolTreatment == Linebreaks.WINDOWS) {
                    this.loneLFDetector.reset(fieldStr);
                    this.loneLFDetector.matches();
                    fieldStr = this.loneLFDetector.replaceAll("$1\r\n");
                } else if (this.eolTreatment == Linebreaks.UNIX) {
                    this.CRLFDetector.reset(fieldStr);
                    fieldStr = this.CRLFDetector.replaceAll("\n");
                }
            }
            mProtoTuple.add(fieldStr);
        }
        if (this.eolTreatment == Linebreaks.WINDOWS && fieldStr != null) {
            mProtoTuple.set(mProtoTuple.size() - 1, fieldStr + "\r");
        }
        Tuple resTuple = this.tupleMaker.newTuple(mProtoTuple);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Row: " + resTuple));
        }
        super.putNext(resTuple);
    }

    public Tuple getNext() throws IOException {
        this.mProtoTuple = new ArrayList();
        this.getNextInQuotedField = false;
        boolean evenQuotesSeen = true;
        boolean sawEmbeddedRecordDelimiter = false;
        byte[] buf = null;
        if (!this.mRequiredColumnsInitialized) {
            if (this.signature != null) {
                Properties p = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass());
                this.mRequiredColumns = (boolean[])ObjectSerializer.deserialize((String)p.getProperty(this.signature));
            }
            this.mRequiredColumnsInitialized = true;
        }
        try {
            int recordLen = 0;
            this.getNextFieldID = 0;
            while (sawEmbeddedRecordDelimiter || this.getNextFieldID == 0) {
                Text value = null;
                if (sawEmbeddedRecordDelimiter) {
                    int prevLineLen = recordLen + 1;
                    byte[] prevLineSaved = Arrays.copyOf(buf, prevLineLen);
                    prevLineSaved[prevLineLen - 1] = 10;
                    if (!this.in.nextKeyValue()) {
                        return null;
                    }
                    value = (Text)this.in.getCurrentValue();
                    recordLen = value.getLength();
                    buf = value.getBytes();
                    byte[] prevLineAndContinuation = Arrays.copyOf(prevLineSaved, prevLineLen + recordLen);
                    System.arraycopy(buf, 0, prevLineAndContinuation, prevLineLen, recordLen);
                    buf = prevLineAndContinuation;
                    this.mProtoTuple.clear();
                    this.getNextInQuotedField = false;
                    evenQuotesSeen = true;
                    this.getNextFieldID = 0;
                    recordLen = prevLineAndContinuation.length;
                } else {
                    if (!this.in.nextKeyValue()) {
                        return null;
                    }
                    value = (Text)this.in.getCurrentValue();
                    buf = value.getBytes();
                    this.getNextFieldID = 0;
                    recordLen = value.getLength();
                }
                this.nextTupleSkipChar = false;
                ByteBuffer fieldBuffer = ByteBuffer.allocate(recordLen);
                sawEmbeddedRecordDelimiter = this.processOneInRecord(evenQuotesSeen, buf, recordLen, fieldBuffer);
                if (sawEmbeddedRecordDelimiter) continue;
                this.readField(fieldBuffer, this.getNextFieldID++);
            }
        }
        catch (InterruptedException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, (Throwable)e);
        }
        Tuple t = this.mTupleFactory.newTupleNoCopy(this.mProtoTuple);
        return t;
    }

    private boolean processOneInRecord(boolean evenQuotesSeen, byte[] buf, int recordLen, ByteBuffer fieldBuffer) {
        for (int i = 0; i < recordLen; ++i) {
            if (this.nextTupleSkipChar) {
                this.nextTupleSkipChar = false;
                continue;
            }
            byte b = buf[i];
            if (this.getNextInQuotedField) {
                if (b == 34) {
                    if (i < recordLen - 1 && buf[i + 1] == 34) {
                        fieldBuffer.put(b);
                        this.nextTupleSkipChar = true;
                        continue;
                    }
                    boolean bl = evenQuotesSeen = !evenQuotesSeen;
                    if (!evenQuotesSeen) continue;
                    fieldBuffer.put((byte)34);
                    continue;
                }
                if (!(evenQuotesSeen || b != this.fieldDelimiter && b != 10)) {
                    this.getNextInQuotedField = false;
                    this.readField(fieldBuffer, this.getNextFieldID++);
                    continue;
                }
                fieldBuffer.put(b);
                continue;
            }
            if (b == 34) {
                if (i < recordLen - 1 && buf[i + 1] == 34) {
                    fieldBuffer.put(b);
                    this.nextTupleSkipChar = true;
                    continue;
                }
                this.getNextInQuotedField = true;
                evenQuotesSeen = true;
                continue;
            }
            if (b == this.fieldDelimiter) {
                this.readField(fieldBuffer, this.getNextFieldID++);
                continue;
            }
            evenQuotesSeen = true;
            fieldBuffer.put(b);
        }
        return this.getNextInQuotedField && this.multilineTreatment == Multiline.YES;
    }

    private void readField(ByteBuffer buf, int fieldID) {
        if (this.mRequiredColumns == null || this.mRequiredColumns.length > fieldID && this.mRequiredColumns[fieldID]) {
            byte[] bytes = new byte[buf.position()];
            buf.rewind();
            buf.get(bytes, 0, bytes.length);
            this.mProtoTuple.add(new DataByteArray(bytes));
        }
        buf.clear();
    }

    public void setLocation(String location, Job job) throws IOException {
        this.loadLocation = location;
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public InputFormat getInputFormat() {
        if (this.loadLocation.endsWith(".bz2") || this.loadLocation.endsWith(".bz")) {
            return new Bzip2TextInputFormat();
        }
        return new PigTextInputFormat();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.in = reader;
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        if (requiredFieldList == null) {
            return null;
        }
        if (requiredFieldList.getFields() != null) {
            int lastColumn = -1;
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() <= lastColumn) continue;
                lastColumn = rf.getIndex();
            }
            this.mRequiredColumns = new boolean[lastColumn + 1];
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() == -1) continue;
                this.mRequiredColumns[rf.getIndex()] = true;
            }
            Properties p = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass());
            try {
                p.setProperty(this.signature, ObjectSerializer.serialize((Serializable)this.mRequiredColumns));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot serialize mRequiredColumns");
            }
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public static enum Multiline {
        YES,
        NO;

    }

    public static enum Linebreaks {
        UNIX,
        WINDOWS,
        NOCHANGE;

    }
}

