/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ObjectIdClassMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class JDOHelperGetObjectIdMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression ignore, List args) {
        if (args == null || args.size() == 0) {
            throw new NucleusUserException("Cannot invoke JDOHelper.getObjectId without an argument");
        }
        SQLExpression expr = (SQLExpression)args.get(0);
        if (expr == null) {
            return new NullLiteral(this.stmt, null, null, false);
        }
        if (expr instanceof SQLLiteral) {
            RDBMSManager storeMgr = this.stmt.getRDBMSManager();
            ApiAdapter api = storeMgr.getApiAdapter();
            Object id = api.getIdForObject(((SQLLiteral)((Object)expr)).getValue());
            if (id == null) {
                return new NullLiteral(this.stmt, null, null, false);
            }
            JavaTypeMapping m = this.getMappingForClass(id.getClass());
            return new ObjectLiteral(this.stmt, m, id, false);
        }
        if (ObjectExpression.class.isAssignableFrom(expr.getClass())) {
            if (((ObjectExpression)expr).getJavaTypeMapping() instanceof PersistenceCapableMapping) {
                ObjectIdClassMapping mapping = new ObjectIdClassMapping((PersistenceCapableMapping)expr.getJavaTypeMapping());
                return new ObjectExpression(this.stmt, expr.getSQLTable(), (JavaTypeMapping)mapping);
            }
            return expr;
        }
        throw new IllegalExpressionOperationException("JDOHelper.getObjectId", expr);
    }
}

