/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.PropertyOption;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;

public class OptionsProcessor {
    protected static final Log l4j = LogFactory.getLog((String)OptionsProcessor.class.getName());
    private Parser parser = new Parser();
    private Option confOptions;
    private Option isSilentOption;
    private Option execOption;
    private Option fileOption;
    private Option isHelpOption;
    private CommandLine cmdLine;

    private Option createBoolOption(DefaultOptionBuilder builder, String longName, String shortName, String desc) {
        builder.reset();
        if (longName == null) {
            return builder.withShortName(shortName).withDescription(desc).create();
        }
        return builder.withShortName(shortName).withLongName(longName).withDescription(desc).create();
    }

    private Option createOptionWithArg(DefaultOptionBuilder builder, String longName, String shortName, String desc, Argument arg) {
        builder.reset();
        DefaultOptionBuilder dob = builder.withShortName(shortName).withArgument(arg).withDescription(desc);
        if (longName != null) {
            dob = dob.withLongName(longName);
        }
        return dob.create();
    }

    public OptionsProcessor() {
        DefaultOptionBuilder builder = new DefaultOptionBuilder("-", "-", false);
        ArgumentBuilder argBuilder = new ArgumentBuilder();
        this.execOption = this.createOptionWithArg(builder, "exec", "e", "execute the following command", argBuilder.withMinimum(1).withMaximum(1).create());
        this.fileOption = this.createOptionWithArg(builder, "file", "f", "execute commands from the following file", argBuilder.withMinimum(1).withMaximum(1).create());
        this.isSilentOption = this.createBoolOption(builder, "silent", "S", "silent mode");
        this.isHelpOption = this.createBoolOption(builder, "help", "h", "help");
        this.confOptions = new MultiPropertyOption("-hiveconf", "(n=v) Optional. Add or override Hive/Hadoop properties.", 68);
        new PropertyOption();
        Group allOptions = new GroupBuilder().withOption(this.confOptions).withOption(this.isSilentOption).withOption(this.isHelpOption).withOption(this.execOption).withOption(this.fileOption).create();
        this.parser.setGroup(allOptions);
    }

    public boolean process_stage1(String[] argv) {
        try {
            this.cmdLine = this.parser.parse(argv);
            List hiveConfArgs = (List)this.cmdLine.getValue(this.confOptions);
            if (null != hiveConfArgs) {
                for (String s : hiveConfArgs) {
                    String[] parts = s.split("=", 2);
                    System.setProperty(parts[0], parts[1]);
                }
            }
        }
        catch (OptionException oe) {
            System.err.println(oe.getMessage());
            return false;
        }
        return true;
    }

    public boolean process_stage2(CliSessionState ss) {
        HiveConf hconf = ss.getConf();
        ss.setIsSilent(this.cmdLine.hasOption(this.isSilentOption));
        ss.execString = (String)this.cmdLine.getValue(this.execOption);
        ss.fileName = (String)this.cmdLine.getValue(this.fileOption);
        if (this.cmdLine.hasOption(this.isHelpOption)) {
            this.printUsage(null);
            return false;
        }
        if (ss.execString != null && ss.fileName != null) {
            this.printUsage("-e and -f option cannot be specified simultaneously");
            return false;
        }
        List hiveConfArgs = (List)this.cmdLine.getValue(this.confOptions);
        if (null != hiveConfArgs) {
            for (String s : hiveConfArgs) {
                String[] parts = s.split("=", 2);
                ss.cmdProperties.setProperty(parts[0], parts[1]);
            }
        }
        return true;
    }

    public void printUsage(String error) {
        if (error != null) {
            System.err.println("Invalid arguments: " + error);
        }
        System.err.println("");
        System.err.println("Usage: hive [--config confdir] [-hiveconf x=y]* [<-f filename>|<-e query-string>] [-S]");
        System.err.println("");
        System.err.println("  -e 'quoted query string'  Sql from command line");
        System.err.println("  -f <filename>             Sql from files");
        System.err.println("  -S                        Silent mode in interactive shell");
        System.err.println("");
        System.err.println("-e and -f cannot be specified together. In the absence of these");
        System.err.println("options, interactive shell is started");
        System.err.println("");
    }

    class MultiPropertyOption
    extends PropertyOption {
        private String optionString;

        MultiPropertyOption() {
        }

        MultiPropertyOption(String optionString, String description, int id) {
            super(optionString, description, id);
            this.optionString = optionString;
        }

        public boolean canProcess(WriteableCommandLine commandLine, String argument) {
            boolean ret = argument != null && argument.startsWith(this.optionString);
            return ret;
        }

        public void process(WriteableCommandLine commandLine, ListIterator arguments) throws OptionException {
            List oldVal;
            String arg = (String)arguments.next();
            if (!this.canProcess(commandLine, arg)) {
                throw new OptionException((Option)this, "Unexpected.token", arg);
            }
            ArrayList<String> properties = new ArrayList<String>();
            String next = "";
            while (arguments.hasNext()) {
                next = (String)arguments.next();
                if (!next.startsWith("-")) {
                    if (next.indexOf("=") == -1) {
                        throw new OptionException((Option)this, "Unexpected.token", "argument: '" + next + "' is not of the form x=y");
                    }
                    properties.add(next);
                    continue;
                }
                arguments.previous();
                break;
            }
            if ((oldVal = (List)commandLine.getValue((Option)this)) == null) {
                commandLine.addValue((Option)this, properties);
            } else {
                oldVal.addAll(properties);
            }
        }
    }
}

