/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.explainWork;

public class ExplainSemanticAnalyzer
extends BaseSemanticAnalyzer {
    public ExplainSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.ctx.setExplain(true);
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.conf, (ASTNode)ast.getChild(0));
        sem.analyze((ASTNode)ast.getChild(0), this.ctx);
        boolean extended = false;
        if (ast.getChildCount() > 1) {
            extended = true;
        }
        this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
        List<Task<? extends Serializable>> tasks = sem.getRootTasks();
        Task<? extends Serializable> fetchTask = sem.getFetchTask();
        if (tasks == null) {
            if (fetchTask != null) {
                tasks = new ArrayList<Task<? extends Serializable>>();
                tasks.add(fetchTask);
            }
        } else if (fetchTask != null) {
            tasks.add(fetchTask);
        }
        this.rootTasks.add(TaskFactory.get(new explainWork(this.ctx.getResFile(), tasks, ((ASTNode)ast.getChild(0)).toStringTree(), extended), this.conf, new Task[0]));
    }
}

