/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.joinCond;

public class QBJoinTree {
    private String leftAlias;
    private String[] rightAliases;
    private String[] leftAliases;
    private QBJoinTree joinSrc;
    private String[] baseSrc;
    private int nextTag = 0;
    private joinCond[] joinCond;
    private boolean noOuterJoin = true;
    private boolean noSemiJoin = true;
    private HashMap<String, ArrayList<ASTNode>> rhsSemijoin = new HashMap();
    private Vector<Vector<ASTNode>> expressions;
    private Vector<Vector<ASTNode>> filters;
    private boolean mapSideJoin;
    private List<String> mapAliases;
    private List<String> streamAliases;

    public String getLeftAlias() {
        return this.leftAlias;
    }

    public void setLeftAlias(String leftAlias) {
        this.leftAlias = leftAlias;
    }

    public String[] getRightAliases() {
        return this.rightAliases;
    }

    public void setRightAliases(String[] rightAliases) {
        this.rightAliases = rightAliases;
    }

    public String[] getLeftAliases() {
        return this.leftAliases;
    }

    public void setLeftAliases(String[] leftAliases) {
        this.leftAliases = leftAliases;
    }

    public Vector<Vector<ASTNode>> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(Vector<Vector<ASTNode>> expressions) {
        this.expressions = expressions;
    }

    public String[] getBaseSrc() {
        return this.baseSrc;
    }

    public void setBaseSrc(String[] baseSrc) {
        this.baseSrc = baseSrc;
    }

    public QBJoinTree getJoinSrc() {
        return this.joinSrc;
    }

    public void setJoinSrc(QBJoinTree joinSrc) {
        this.joinSrc = joinSrc;
    }

    public int getNextTag() {
        return this.nextTag++;
    }

    public String getJoinStreamDesc() {
        return "$INTNAME";
    }

    public joinCond[] getJoinCond() {
        return this.joinCond;
    }

    public void setJoinCond(joinCond[] joinCond2) {
        this.joinCond = joinCond2;
    }

    public boolean getNoOuterJoin() {
        return this.noOuterJoin;
    }

    public void setNoOuterJoin(boolean noOuterJoin) {
        this.noOuterJoin = noOuterJoin;
    }

    public boolean getNoSemiJoin() {
        return this.noSemiJoin;
    }

    public void setNoSemiJoin(boolean semi) {
        this.noSemiJoin = semi;
    }

    public Vector<Vector<ASTNode>> getFilters() {
        return this.filters;
    }

    public void setFilters(Vector<Vector<ASTNode>> filters) {
        this.filters = filters;
    }

    public boolean isMapSideJoin() {
        return this.mapSideJoin;
    }

    public void setMapSideJoin(boolean mapSideJoin) {
        this.mapSideJoin = mapSideJoin;
    }

    public List<String> getMapAliases() {
        return this.mapAliases;
    }

    public void setMapAliases(List<String> mapAliases) {
        this.mapAliases = mapAliases;
    }

    public List<String> getStreamAliases() {
        return this.streamAliases;
    }

    public void setStreamAliases(List<String> streamAliases) {
        this.streamAliases = streamAliases;
    }

    public void addRHSSemijoin(String alias) {
        if (!this.rhsSemijoin.containsKey(alias)) {
            this.rhsSemijoin.put(alias, null);
        }
    }

    public void addRHSSemijoinColumns(String alias, ArrayList<ASTNode> columns) {
        ArrayList<ASTNode> cols = this.rhsSemijoin.get(alias);
        if (cols == null) {
            this.rhsSemijoin.put(alias, columns);
        } else {
            cols.addAll(columns);
        }
    }

    public void addRHSSemijoinColumns(String alias, ASTNode column) {
        ArrayList<ASTNode> cols = this.rhsSemijoin.get(alias);
        if (cols == null) {
            cols = new ArrayList();
            cols.add(column);
            this.rhsSemijoin.put(alias, cols);
        } else {
            cols.add(column);
        }
    }

    public ArrayList<ASTNode> getRHSSemijoinColumns(String alias) {
        return this.rhsSemijoin.get(alias);
    }

    public void mergeRHSSemijoin(QBJoinTree src) {
        for (Map.Entry<String, ArrayList<ASTNode>> e : src.rhsSemijoin.entrySet()) {
            String key = e.getKey();
            ArrayList<ASTNode> value = this.rhsSemijoin.get(key);
            if (value == null) {
                this.rhsSemijoin.put(key, e.getValue());
                continue;
            }
            value.addAll((Collection<ASTNode>)e.getValue());
        }
    }
}

