/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.mapredWork;

public class ConditionalResolverMergeFiles
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int getTaskId(HiveConf conf, Object objCtx) {
        long avgConditionSize;
        ConditionalResolverMergeFilesCtx ctx = (ConditionalResolverMergeFilesCtx)objCtx;
        String dirName = ctx.getDir();
        long trgtSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESSIZE);
        trgtSize = trgtSize > (avgConditionSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESAVGSIZE)) ? trgtSize : avgConditionSize;
        try {
            Path dirPath = new Path(dirName);
            FileSystem inpFs = dirPath.getFileSystem((Configuration)conf);
            if (inpFs.exists(dirPath)) {
                FileStatus[] fStats = inpFs.listStatus(dirPath);
                long totalSz = 0L;
                for (FileStatus fStat : fStats) {
                    totalSz += fStat.getLen();
                }
                long currAvgSz = totalSz / (long)fStats.length;
                if (currAvgSz < avgConditionSize && fStats.length > 1) {
                    Task<? extends Serializable> tsk = ctx.getListTasks().get(1);
                    mapredWork work = (mapredWork)tsk.getWork();
                    int maxReducers = conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
                    int reducers = (int)((totalSz + trgtSize - 1L) / trgtSize);
                    reducers = Math.max(1, reducers);
                    reducers = Math.min(maxReducers, reducers);
                    work.setNumReduceTasks(reducers);
                    return 1;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static class ConditionalResolverMergeFilesCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<Task<? extends Serializable>> listTasks;
        private String dir;

        public ConditionalResolverMergeFilesCtx() {
        }

        public ConditionalResolverMergeFilesCtx(List<Task<? extends Serializable>> listTasks, String dir) {
            this.listTasks = listTasks;
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public List<Task<? extends Serializable>> getListTasks() {
            return this.listTasks;
        }

        public void setListTasks(List<Task<? extends Serializable>> listTasks) {
            this.listTasks = listTasks;
        }
    }
}

