/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class exprNodeFieldDesc
extends exprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    exprNodeDesc desc;
    String fieldName;
    Boolean isList;

    public exprNodeFieldDesc() {
    }

    public exprNodeFieldDesc(TypeInfo typeInfo, exprNodeDesc desc, String fieldName, Boolean isList) {
        super(typeInfo);
        this.desc = desc;
        this.fieldName = fieldName;
        this.isList = isList;
    }

    @Override
    public List<exprNodeDesc> getChildren() {
        ArrayList<exprNodeDesc> children = new ArrayList<exprNodeDesc>(2);
        children.add(this.desc);
        return children;
    }

    public exprNodeDesc getDesc() {
        return this.desc;
    }

    public void setDesc(exprNodeDesc desc) {
        this.desc = desc;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Boolean getIsList() {
        return this.isList;
    }

    public void setIsList(Boolean isList) {
        this.isList = isList;
    }

    public String toString() {
        return this.desc.toString() + "." + this.fieldName;
    }

    @Override
    @explain(displayName="expr")
    public String getExprString() {
        return this.desc.getExprString() + "." + this.fieldName;
    }

    @Override
    public List<String> getCols() {
        List<String> colList = new ArrayList<String>();
        if (this.desc != null) {
            colList = Utilities.mergeUniqElems(colList, this.desc.getCols());
        }
        return colList;
    }

    @Override
    public exprNodeDesc clone() {
        return new exprNodeFieldDesc(this.typeInfo, this.desc, this.fieldName, this.isList);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof exprNodeFieldDesc)) {
            return false;
        }
        exprNodeFieldDesc dest = (exprNodeFieldDesc)o;
        if (!this.typeInfo.equals(dest.getTypeInfo())) {
            return false;
        }
        return this.fieldName.equals(dest.getFieldName()) && this.isList.equals(dest.getIsList()) && this.desc.isSame(dest.getDesc());
    }
}

