/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.joinCond;
import org.apache.hadoop.hive.ql.plan.joinDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;

@explain(displayName="Common Join Operator")
public class mapJoinDesc
extends joinDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Byte, List<exprNodeDesc>> keys;
    private tableDesc keyTblDesc;
    private List<tableDesc> valueTblDescs;
    private int posBigTable;
    private Map<Byte, List<Integer>> retainList;

    public mapJoinDesc() {
    }

    public mapJoinDesc(Map<Byte, List<exprNodeDesc>> keys, tableDesc keyTblDesc, Map<Byte, List<exprNodeDesc>> values, List<tableDesc> valueTblDescs, ArrayList<String> outputColumnNames, int posBigTable, joinCond[] conds) {
        super(values, outputColumnNames, conds);
        this.keys = keys;
        this.keyTblDesc = keyTblDesc;
        this.valueTblDescs = valueTblDescs;
        this.posBigTable = posBigTable;
        this.initRetainExprList();
    }

    private void initRetainExprList() {
        this.retainList = new HashMap<Byte, List<Integer>>();
        Set<Map.Entry<Byte, List<exprNodeDesc>>> set = super.getExprs().entrySet();
        for (Map.Entry<Byte, List<exprNodeDesc>> current : set) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < current.getValue().size(); ++i) {
                list.add(i);
            }
            this.retainList.put(current.getKey(), list);
        }
    }

    public Map<Byte, List<Integer>> getRetainList() {
        return this.retainList;
    }

    public void setRetainList(Map<Byte, List<Integer>> retainList) {
        this.retainList = retainList;
    }

    @explain(displayName="keys")
    public Map<Byte, List<exprNodeDesc>> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<Byte, List<exprNodeDesc>> keys) {
        this.keys = keys;
    }

    @explain(displayName="Position of Big Table")
    public int getPosBigTable() {
        return this.posBigTable;
    }

    public void setPosBigTable(int posBigTable) {
        this.posBigTable = posBigTable;
    }

    public tableDesc getKeyTblDesc() {
        return this.keyTblDesc;
    }

    public void setKeyTblDesc(tableDesc keyTblDesc) {
        this.keyTblDesc = keyTblDesc;
    }

    public List<tableDesc> getValueTblDescs() {
        return this.valueTblDescs;
    }

    public void setValueTblDescs(List<tableDesc> valueTblDescs) {
        this.valueTblDescs = valueTblDescs;
    }
}

