/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.Properties;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;

public class SetProcessor
implements CommandProcessor {
    private static String prefix = "set: ";

    public static boolean getBoolean(String value) {
        if (value.equals("on") || value.equals("true")) {
            return true;
        }
        if (value.equals("off") || value.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(prefix + "'" + value + "' is not a boolean");
    }

    private void dumpOptions(Properties p) {
        SessionState ss = SessionState.get();
        ss.out.println("silent=" + (ss.getIsSilent() ? "on" : "off"));
        for (Object one : p.keySet()) {
            String oneProp = (String)one;
            String oneValue = p.getProperty(oneProp);
            ss.out.println(oneProp + "=" + oneValue);
        }
    }

    private void dumpOption(Properties p, String s) {
        SessionState ss = SessionState.get();
        if (p.getProperty(s) != null) {
            ss.out.println(s + "=" + p.getProperty(s));
        } else {
            ss.out.println(s + " is undefined");
        }
    }

    @Override
    public void init() {
    }

    @Override
    public int run(String command) {
        SessionState ss = SessionState.get();
        String nwcmd = command.trim();
        if (nwcmd.equals("")) {
            this.dumpOptions(ss.getConf().getChangedProperties());
            return 0;
        }
        if (nwcmd.equals("-v")) {
            this.dumpOptions(ss.getConf().getAllProperties());
            return 0;
        }
        String[] part = new String[2];
        int eqIndex = nwcmd.indexOf(61);
        if (eqIndex == -1) {
            this.dumpOption(ss.getConf().getAllProperties(), nwcmd);
            return 0;
        }
        if (eqIndex == nwcmd.length() - 1) {
            part[0] = nwcmd.substring(0, nwcmd.length() - 1);
            part[1] = "";
        } else {
            part[0] = nwcmd.substring(0, eqIndex).trim();
            part[1] = nwcmd.substring(eqIndex + 1).trim();
        }
        try {
            if (part[0].equals("silent")) {
                boolean val = SetProcessor.getBoolean(part[1]);
                ss.setIsSilent(val);
            } else {
                ss.getConf().set(part[0], part[1]);
            }
        }
        catch (IllegalArgumentException err) {
            ss.err.println(err.getMessage());
            return 1;
        }
        return 0;
    }
}

