/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hwi;

import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.hwi.HWIAuth;
import org.apache.hadoop.hive.hwi.HWISessionItem;

public class HWISessionManager
implements Runnable {
    protected static final Log l4j = LogFactory.getLog((String)HWISessionManager.class.getName());
    private boolean goOn = true;
    private TreeMap<HWIAuth, Set<HWISessionItem>> items = new TreeMap();

    protected HWISessionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TreeMap<HWIAuth, Set<HWISessionItem>> treeMap;
        l4j.debug((Object)"Entered run() thread has started");
        while (this.goOn) {
            l4j.debug((Object)"locking items");
            treeMap = this.items;
            synchronized (treeMap) {
                for (HWIAuth a : this.items.keySet()) {
                    for (HWISessionItem i : this.items.get(a)) {
                        if (i.getStatus() == HWISessionItem.WebSessionItemStatus.DESTROY) {
                            this.items.get(a).remove(i);
                        }
                        if (i.getStatus() != HWISessionItem.WebSessionItemStatus.KILL_QUERY) continue;
                        l4j.debug((Object)("Killing item: " + i.getSessionName()));
                        i.killIt();
                        l4j.debug((Object)("Killed item: " + i.getSessionName()));
                        this.items.get(a).remove(i);
                    }
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                l4j.error((Object)"Could not sleep ", (Throwable)ex);
            }
        }
        l4j.debug((Object)"goOn is false. Loop has ended.");
        treeMap = this.items;
        synchronized (treeMap) {
            for (HWIAuth a : this.items.keySet()) {
                for (HWISessionItem i : this.items.get(a)) {
                    try {
                        if (i.getStatus() != HWISessionItem.WebSessionItemStatus.QUERY_RUNNING) continue;
                        l4j.debug((Object)(i.getSessionName() + "Joining "));
                        i.runnable.join(1000L);
                        l4j.debug((Object)(i.getSessionName() + "Joined "));
                    }
                    catch (InterruptedException ex) {
                        l4j.error((Object)(i.getSessionName() + "while joining "), (Throwable)ex);
                    }
                }
            }
        }
    }

    protected boolean isGoOn() {
        return this.goOn;
    }

    protected void setGoOn(boolean goOn) {
        this.goOn = goOn;
    }

    protected TreeMap<HWIAuth, Set<HWISessionItem>> getItems() {
        return this.items;
    }

    protected void setItems(TreeMap<HWIAuth, Set<HWISessionItem>> items) {
        this.items = items;
    }

    public Vector<HWISessionItem> findAllSessionItems() {
        Vector<HWISessionItem> otherItems = new Vector<HWISessionItem>();
        for (HWIAuth a : this.items.keySet()) {
            otherItems.addAll((Collection<HWISessionItem>)this.items.get(a));
        }
        return otherItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HWISessionItem createSession(HWIAuth a, String sessionName) {
        l4j.debug((Object)("Creating session: " + sessionName));
        HWISessionItem si = null;
        TreeMap<HWIAuth, Set<HWISessionItem>> treeMap = this.items;
        synchronized (treeMap) {
            if (this.findSessionItemByName(a, sessionName) == null) {
                l4j.debug((Object)("Initializing session: " + sessionName + " a for " + a.getUser()));
                si = new HWISessionItem(a, sessionName);
                if (!this.items.containsKey(a)) {
                    l4j.debug((Object)("SessionList is empty " + a.getUser()));
                    TreeSet<HWISessionItem> list = new TreeSet<HWISessionItem>();
                    list.add(si);
                    this.items.put(a, list);
                    l4j.debug((Object)("Item added " + si.getSessionName() + " for user " + a.getUser()));
                } else {
                    this.items.get(a).add(si);
                    l4j.debug((Object)("Item added " + si.getSessionName() + " for user " + a.getUser()));
                }
            } else {
                l4j.debug((Object)("Creating session: " + sessionName + " already exists " + a.getUser()));
            }
        }
        return si;
    }

    public HWISessionItem findSessionItemByName(HWIAuth auth, String sessionname) {
        Collection sessForUser = this.items.get(auth);
        if (sessForUser == null) {
            return null;
        }
        for (HWISessionItem si : sessForUser) {
            if (!si.getSessionName().equals(sessionname)) continue;
            return si;
        }
        return null;
    }

    public Set<HWIAuth> findAllUsersWithSessions() {
        return this.items.keySet();
    }

    public Set<HWISessionItem> findAllSessionsForUser(HWIAuth auth) {
        return this.items.get(auth);
    }
}

