/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class LazySimpleSerDe
implements SerDe {
    public static final Log LOG = LogFactory.getLog((String)LazySimpleSerDe.class.getName());
    public static final byte[] DefaultSeparators = new byte[]{1, 2, 3};
    private ObjectInspector cachedObjectInspector;
    private boolean useJSONSerialize;
    SerDeParameters serdeParams = null;
    LazyStruct cachedLazyStruct;
    ByteArrayRef byteArrayRef;
    Text serializeCache = new Text();
    ByteStream.Output serializeStream = new ByteStream.Output();

    public String toString() {
        return this.getClass().toString() + "[" + Arrays.asList(new byte[][]{this.serdeParams.separators}) + ":" + ((StructTypeInfo)this.serdeParams.rowTypeInfo).getAllStructFieldNames() + ":" + ((StructTypeInfo)this.serdeParams.rowTypeInfo).getAllStructFieldTypeInfos() + "]";
    }

    public static byte getByte(String altValue, byte defaultVal) {
        if (altValue != null && altValue.length() > 0) {
            try {
                return Byte.valueOf(altValue);
            }
            catch (NumberFormatException e) {
                return (byte)altValue.charAt(0);
            }
        }
        return defaultVal;
    }

    @Override
    public void initialize(Configuration job, Properties tbl) throws SerDeException {
        this.serdeParams = LazySimpleSerDe.initSerdeParams(job, tbl, this.getClass().getName());
        this.cachedObjectInspector = LazyFactory.createLazyStructInspector(this.serdeParams.getColumnNames(), this.serdeParams.getColumnTypes(), this.serdeParams.getSeparators(), this.serdeParams.getNullSequence(), this.serdeParams.isLastColumnTakesRest(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar());
        if (this.serdeParams.isJsonSerialize()) {
            this.setUseJSONSerialize(true);
        }
        this.cachedLazyStruct = (LazyStruct)LazyFactory.createLazyObject(this.cachedObjectInspector);
        LOG.debug((Object)("LazySimpleSerDe initialized with: columnNames=" + this.serdeParams.columnNames + " columnTypes=" + this.serdeParams.columnTypes + " separator=" + Arrays.asList(new byte[][]{this.serdeParams.separators}) + " nullstring=" + this.serdeParams.nullString + " lastColumnTakesRest=" + this.serdeParams.lastColumnTakesRest));
    }

    public static SerDeParameters initSerdeParams(Configuration job, Properties tbl, String serdeName) throws SerDeException {
        int i;
        SerDeParameters serdeParams = new SerDeParameters();
        serdeParams.separators = new byte[8];
        serdeParams.separators[0] = LazySimpleSerDe.getByte(tbl.getProperty("field.delim", tbl.getProperty("serialization.format")), DefaultSeparators[0]);
        serdeParams.separators[1] = LazySimpleSerDe.getByte(tbl.getProperty("colelction.delim"), DefaultSeparators[1]);
        serdeParams.separators[2] = LazySimpleSerDe.getByte(tbl.getProperty("mapkey.delim"), DefaultSeparators[2]);
        for (int i2 = 3; i2 < serdeParams.separators.length; ++i2) {
            serdeParams.separators[i2] = (byte)(i2 + 1);
        }
        serdeParams.nullString = tbl.getProperty("serialization.null.format", "\\N");
        serdeParams.nullSequence = new Text(serdeParams.nullString);
        String lastColumnTakesRestString = tbl.getProperty("serialization.last.column.takes.rest");
        serdeParams.lastColumnTakesRest = lastColumnTakesRestString != null && lastColumnTakesRestString.equalsIgnoreCase("true");
        String useJsonSerialize = tbl.getProperty("serialization.use.json.object");
        serdeParams.jsonSerialize = useJsonSerialize != null && useJsonSerialize.equalsIgnoreCase("true");
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        serdeParams.columnNames = columnNameProperty != null && columnNameProperty.length() > 0 ? Arrays.asList(columnNameProperty.split(",")) : new ArrayList<String>();
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < serdeParams.columnNames.size(); ++i) {
                if (i > 0) {
                    sb.append(":");
                }
                sb.append("string");
            }
            columnTypeProperty = sb.toString();
        }
        serdeParams.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        if (serdeParams.columnNames.size() != serdeParams.columnTypes.size()) {
            throw new SerDeException(serdeName + ": columns has " + serdeParams.columnNames.size() + " elements while columns.types has " + serdeParams.columnTypes.size() + " elements!");
        }
        serdeParams.rowTypeInfo = TypeInfoFactory.getStructTypeInfo(serdeParams.columnNames, serdeParams.columnTypes);
        String escapeProperty = tbl.getProperty("escape.delim");
        boolean bl = serdeParams.escaped = escapeProperty != null;
        if (serdeParams.escaped) {
            serdeParams.escapeChar = LazySimpleSerDe.getByte(escapeProperty, (byte)92);
        }
        if (serdeParams.escaped) {
            serdeParams.needsEscape = new boolean[128];
            for (i = 0; i < 128; ++i) {
                serdeParams.needsEscape[i] = false;
            }
            serdeParams.needsEscape[serdeParams.escapeChar] = true;
            for (i = 0; i < serdeParams.separators.length; ++i) {
                serdeParams.needsEscape[serdeParams.separators[i]] = true;
            }
        }
        return serdeParams;
    }

    @Override
    public Object deserialize(Writable field) throws SerDeException {
        if (this.byteArrayRef == null) {
            this.byteArrayRef = new ByteArrayRef();
        }
        if (field instanceof BytesWritable) {
            BytesWritable b = (BytesWritable)field;
            this.byteArrayRef.setData(b.get());
            this.cachedLazyStruct.init(this.byteArrayRef, 0, b.getSize());
        } else if (field instanceof Text) {
            Text t = (Text)field;
            this.byteArrayRef.setData(t.getBytes());
            this.cachedLazyStruct.init(this.byteArrayRef, 0, t.getLength());
        } else {
            throw new SerDeException(this.getClass().toString() + ": expects either BytesWritable or Text object!");
        }
        return this.cachedLazyStruct;
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        List<Object> list = soi.getStructFieldsDataAsList(obj);
        List<? extends StructField> declaredFields = this.serdeParams.rowTypeInfo != null && ((StructTypeInfo)this.serdeParams.rowTypeInfo).getAllStructFieldNames().size() > 0 ? ((StructObjectInspector)this.getObjectInspector()).getAllStructFieldRefs() : null;
        this.serializeStream.reset();
        try {
            for (int i = 0; i < fields.size(); ++i) {
                Object f;
                if (i > 0) {
                    this.serializeStream.write(this.serdeParams.separators[0]);
                }
                ObjectInspector foi = fields.get(i).getFieldObjectInspector();
                Object object = f = list == null ? null : list.get(i);
                if (declaredFields != null && i >= declaredFields.size()) {
                    throw new SerDeException("Error: expecting " + declaredFields.size() + " but asking for field " + i + "\n" + "data=" + obj + "\n" + "tableType=" + this.serdeParams.rowTypeInfo.toString() + "\n" + "dataType=" + TypeInfoUtils.getTypeInfoFromObjectInspector(objInspector));
                }
                if (!foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && (declaredFields == null || declaredFields.get(i).getFieldObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || this.useJSONSerialize)) {
                    LazySimpleSerDe.serialize(this.serializeStream, SerDeUtils.getJSONString(f, foi), PrimitiveObjectInspectorFactory.javaStringObjectInspector, this.serdeParams.separators, 1, this.serdeParams.nullSequence, this.serdeParams.escaped, this.serdeParams.escapeChar, this.serdeParams.needsEscape);
                    continue;
                }
                LazySimpleSerDe.serialize(this.serializeStream, f, foi, this.serdeParams.separators, 1, this.serdeParams.nullSequence, this.serdeParams.escaped, this.serdeParams.escapeChar, this.serdeParams.needsEscape);
            }
        }
        catch (IOException e) {
            throw new SerDeException(e);
        }
        this.serializeCache.set(this.serializeStream.getData(), 0, this.serializeStream.getCount());
        return this.serializeCache;
    }

    public static void serialize(ByteStream.Output out, Object obj, ObjectInspector objInspector, byte[] separators, int level, Text nullSequence, boolean escaped, byte escapeChar, boolean[] needsEscape) throws IOException {
        if (obj == null) {
            out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
            return;
        }
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                LazyUtils.writePrimitiveUTF8((OutputStream)((Object)out), obj, (PrimitiveObjectInspector)objInspector, escaped, escapeChar, needsEscape);
                return;
            }
            case LIST: {
                char separator = (char)separators[level];
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List<?> list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            out.write(separator);
                        }
                        LazySimpleSerDe.serialize(out, list.get(i), eoi, separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                    }
                }
                return;
            }
            case MAP: {
                char separator = (char)separators[level];
                char keyValueSeparator = (char)separators[level + 1];
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map<?, ?> map = moi.getMap(obj);
                if (map == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    boolean first = true;
                    for (Map.Entry<?, ?> entry : map.entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            out.write(separator);
                        }
                        LazySimpleSerDe.serialize(out, entry.getKey(), koi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                        out.write(keyValueSeparator);
                        LazySimpleSerDe.serialize(out, entry.getValue(), voi, separators, level + 2, nullSequence, escaped, escapeChar, needsEscape);
                    }
                }
                return;
            }
            case STRUCT: {
                char separator = (char)separators[level];
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                List<Object> list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    out.write(nullSequence.getBytes(), 0, nullSequence.getLength());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            out.write(separator);
                        }
                        LazySimpleSerDe.serialize(out, list.get(i), fields.get(i).getFieldObjectInspector(), separators, level + 1, nullSequence, escaped, escapeChar, needsEscape);
                    }
                }
                return;
            }
        }
        throw new RuntimeException("Unknown category type: " + (Object)((Object)objInspector.getCategory()));
    }

    public boolean isUseJSONSerialize() {
        return this.useJSONSerialize;
    }

    public void setUseJSONSerialize(boolean useJSONSerialize) {
        this.useJSONSerialize = useJSONSerialize;
    }

    public static class SerDeParameters {
        byte[] separators = DefaultSeparators;
        String nullString;
        Text nullSequence;
        TypeInfo rowTypeInfo;
        boolean lastColumnTakesRest;
        List<String> columnNames;
        List<TypeInfo> columnTypes;
        boolean escaped;
        byte escapeChar;
        boolean[] needsEscape;
        boolean jsonSerialize;

        public List<TypeInfo> getColumnTypes() {
            return this.columnTypes;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        public byte[] getSeparators() {
            return this.separators;
        }

        public String getNullString() {
            return this.nullString;
        }

        public Text getNullSequence() {
            return this.nullSequence;
        }

        public TypeInfo getRowTypeInfo() {
            return this.rowTypeInfo;
        }

        public boolean isLastColumnTakesRest() {
            return this.lastColumnTakesRest;
        }

        public boolean isEscaped() {
            return this.escaped;
        }

        public byte getEscapeChar() {
            return this.escapeChar;
        }

        public boolean[] getNeedsEscape() {
            return this.needsEscape;
        }

        public boolean isJsonSerialize() {
            return this.jsonSerialize;
        }

        public void setJsonSerialize(boolean jsonSerialize) {
            this.jsonSerialize = jsonSerialize;
        }
    }
}

