/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigProgressable;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class ExtremalTupleByNthField
extends EvalFunc<Tuple>
implements Algebraic,
Accumulator<Tuple> {
    private static final int PROGRESS_FREQUENCY = 10000;
    int fieldIndex;
    int sign;
    Tuple intermediate = null;
    DataBag tempDb = BagFactory.getInstance().newDefaultBag();
    Tuple parameterToExtreme = TupleFactory.getInstance().newTuple((Object)this.tempDb);

    public ExtremalTupleByNthField() throws ExecException {
        this("1", "max");
    }

    public ExtremalTupleByNthField(String fieldIndexString) throws ExecException {
        this(fieldIndexString, "max");
    }

    public ExtremalTupleByNthField(String fieldIndexString, String order) throws ExecException {
        this.fieldIndex = ExtremalTupleByNthField.parseFieldIndex(fieldIndexString);
        this.sign = ExtremalTupleByNthField.parseOrdering(order);
    }

    public Tuple exec(Tuple input) throws IOException {
        return ExtremalTupleByNthField.extreme(this.fieldIndex, this.sign, input, this.reporter);
    }

    public Type getReturnType() {
        return Tuple.class;
    }

    public Schema outputSchema(Schema input) {
        return input;
    }

    public String getInitial() {
        return HelperClass.class.getName();
    }

    public String getIntermed() {
        return HelperClass.class.getName();
    }

    public String getFinal() {
        return HelperClass.class.getName();
    }

    public void accumulate(Tuple b) throws IOException {
        try {
            if (b != null) {
                if (this.intermediate == null) {
                    this.intermediate = TupleFactory.getInstance().newTuple(b.size());
                    for (int i = 0; i < b.size(); ++i) {
                        this.intermediate.set(i, b.get(i));
                    }
                } else {
                    this.tempDb.clear();
                    this.tempDb.add(b);
                    this.tempDb.add(this.intermediate);
                    this.intermediate = ExtremalTupleByNthField.extreme(this.fieldIndex, this.sign, this.parameterToExtreme, this.reporter);
                }
            }
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = -1;
            String msg = "Error while computing ExtremalTupleByNthField in " + ((Object)((Object)this)).getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, (Throwable)e);
        }
    }

    public void cleanup() {
        this.intermediate = null;
    }

    public Tuple getValue() {
        return this.intermediate;
    }

    protected static final Tuple extreme(int pind, int psign, Tuple input, PigProgressable reporter) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        Comparable curMax = null;
        Tuple curMaxTuple = null;
        int n = 0;
        for (Tuple t : values) {
            if (reporter != null && ++n % 10000 == 0) {
                reporter.progress();
            }
            if (t == null) continue;
            try {
                Object o = t.get(pind);
                if (o == null) continue;
                Comparable d = (Comparable)o;
                if (curMax == null) {
                    curMax = d;
                    curMaxTuple = t;
                    continue;
                }
                int c = psign * d.compareTo(curMax);
                if (c <= 0) continue;
                curMax = d;
                curMaxTuple = t;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = -1;
                String msg = "Error while computing ExtremalTupleByNthField in ExtremalTupleByNthField,";
                throw new ExecException(msg, errCode, -1, (Throwable)e);
            }
        }
        return curMaxTuple;
    }

    protected static int parseFieldIndex(String inputFieldIndex) throws ExecException {
        int fieldIndex = Integer.valueOf(inputFieldIndex);
        if (--fieldIndex < 0) {
            throw new ExecException("field index cannot be less than 1:" + inputFieldIndex, -1, -1, null);
        }
        return fieldIndex;
    }

    protected static int parseOrdering(String order) {
        int sign = 1;
        sign = (order = order.toLowerCase().trim()) != null && (order.startsWith("min") || order.startsWith("desc") || order.startsWith("-") || order.startsWith("small") || order.startsWith("least")) ? -1 : 1;
        return sign;
    }

    public static final class HelperClass
    extends EvalFunc<Tuple> {
        int fieldIndex;
        int sign;

        public HelperClass() throws ExecException {
            this("1", "max");
        }

        public HelperClass(String fieldIndexString) throws ExecException {
            this(fieldIndexString, "max");
        }

        public HelperClass(String fieldIndexString, String order) throws ExecException {
            this.fieldIndex = ExtremalTupleByNthField.parseFieldIndex(fieldIndexString);
            this.sign = ExtremalTupleByNthField.parseOrdering(order);
        }

        public Tuple exec(Tuple input) throws IOException {
            return ExtremalTupleByNthField.extreme(this.fieldIndex, this.sign, input, this.reporter);
        }
    }
}

