/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public class QueryUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected static Class[] classArrayObjectObject = new Class[]{Object.class, Object.class};

    public static boolean resultClassIsUserType(String className) {
        return !QueryUtils.resultClassIsSimple(className) && !className.equals(Map.class.getName()) && !className.equals(ClassNameConstants.Object);
    }

    public static boolean resultClassIsSimple(String className) {
        return className.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || className.equals(ClassNameConstants.JAVA_LANG_BYTE) || className.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || className.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || className.equals(ClassNameConstants.JAVA_LANG_FLOAT) || className.equals(ClassNameConstants.JAVA_LANG_INTEGER) || className.equals(ClassNameConstants.JAVA_LANG_LONG) || className.equals(ClassNameConstants.JAVA_LANG_SHORT) || className.equals(ClassNameConstants.JAVA_LANG_STRING) || className.equals(BigDecimal.class.getName()) || className.equals(BigInteger.class.getName()) || className.equals(java.util.Date.class.getName()) || className.equals(Date.class.getName()) || className.equals(Time.class.getName()) || className.equals(Timestamp.class.getName()) || className.equals(ClassNameConstants.Object);
    }

    public static boolean resultHasOnlyAggregates(String result) {
        if (result == null) {
            return false;
        }
        String resultDefn = result;
        if (resultDefn.toLowerCase().startsWith("distinct")) {
            resultDefn = resultDefn.substring(8);
        }
        StringTokenizer tokenizer = new StringTokenizer(resultDefn, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim().toLowerCase();
            if (token.startsWith("max") || token.startsWith("min") || token.startsWith("avg") || token.startsWith("sum")) {
                if ((token = token.substring(3).trim()).startsWith("(")) continue;
                return false;
            }
            if (token.startsWith("count")) {
                if ((token = token.substring(5).trim()).startsWith("(")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean queryReturnsSingleRow(Query query) {
        if (query.isUnique()) {
            return true;
        }
        if (query.getGrouping() != null) {
            return false;
        }
        return QueryUtils.resultHasOnlyAggregates(query.getResult());
    }

    public static Object createResultObjectUsingArgumentedConstructor(Class resultClass, Object[] fieldValues, Class[] fieldTypes) {
        Object obj = null;
        Class[] ctrTypes = new Class[fieldValues.length];
        for (int i = 0; i < ctrTypes.length; ++i) {
            ctrTypes[i] = fieldTypes != null && fieldTypes[i] != null ? fieldTypes[i] : (fieldValues[i] != null ? fieldValues[i].getClass() : Object.class);
        }
        Constructor ctr = ClassUtils.getConstructorWithArguments(resultClass, ctrTypes);
        if (ctr != null) {
            try {
                obj = ctr.newInstance(fieldValues);
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    String msg = "ResultObject of type " + resultClass.getName() + " created with following constructor arguments: " + StringUtils.objectArrayToString(fieldValues);
                    NucleusLogger.QUERY.debug(msg);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return obj;
    }

    public static Object createResultObjectUsingDefaultConstructorAndSetters(Class resultClass, String[] resultFieldNames, Map resultClassFieldNames, Object[] fieldValues) {
        Object obj = null;
        try {
            obj = resultClass.newInstance();
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("021205", (Object)resultClass.getName());
            NucleusLogger.QUERY.error(msg);
            throw new NucleusUserException(msg);
        }
        for (int i = 0; i < fieldValues.length; ++i) {
            Field field = (Field)resultClassFieldNames.get(resultFieldNames[i].toUpperCase());
            if (QueryUtils.setFieldForResultObject(obj, resultFieldNames[i], field, fieldValues[i])) continue;
            String fieldType = "null";
            if (fieldValues[i] != null) {
                fieldType = fieldValues[i].getClass().getName();
            }
            String msg = LOCALISER.msg("021204", (Object)resultClass.getName(), (Object)resultFieldNames[i], (Object)fieldType);
            NucleusLogger.QUERY.error(msg);
            throw new NucleusUserException(msg);
        }
        return obj;
    }

    public static Object createResultObjectUsingDefaultConstructorAndSetters(Class resultClass, String[] resultFieldNames, Field[] resultFields, Object[] fieldValues) {
        Object obj = null;
        try {
            obj = resultClass.newInstance();
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("021205", (Object)resultClass.getName());
            NucleusLogger.QUERY.error(msg);
            throw new NucleusUserException(msg);
        }
        for (int i = 0; i < fieldValues.length; ++i) {
            if (QueryUtils.setFieldForResultObject(obj, resultFieldNames[i], resultFields[i], fieldValues[i])) continue;
            String fieldType = "null";
            if (fieldValues[i] != null) {
                fieldType = fieldValues[i].getClass().getName();
            }
            String msg = LOCALISER.msg("021204", (Object)resultClass.getName(), (Object)resultFieldNames[i], (Object)fieldType);
            NucleusLogger.QUERY.error(msg);
            throw new NucleusUserException(msg);
        }
        return obj;
    }

    private static boolean setFieldForResultObject(final Object obj, String fieldName, Field field, Object value) {
        boolean fieldSet = false;
        if (!fieldSet) {
            String declaredFieldName;
            block30: {
                Field f;
                declaredFieldName = fieldName;
                if (field != null) {
                    declaredFieldName = field.getName();
                }
                if ((f = ClassUtils.getFieldForClass(obj.getClass(), declaredFieldName)) != null && Modifier.isPublic(f.getModifiers())) {
                    try {
                        f.set(obj, value);
                        fieldSet = true;
                    }
                    catch (Exception e) {
                        Object convertedValue = TypeConversionHelper.convertTo(value, f.getType());
                        if (convertedValue == value) break block30;
                        try {
                            f.set(obj, convertedValue);
                            fieldSet = true;
                            if (NucleusLogger.QUERY.isDebugEnabled()) {
                                String msg = "ResultObject set field=" + fieldName + " using reflection";
                                NucleusLogger.QUERY.debug(msg);
                            }
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!fieldSet && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021209", (Object)obj.getClass().getName(), (Object)declaredFieldName));
            }
        }
        if (!fieldSet) {
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            if (field != null) {
                setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + field.getName().substring(1);
            }
            Class<?> argType = null;
            if (value != null) {
                argType = value.getClass();
            } else if (field != null) {
                argType = field.getType();
            }
            Method m = ClassUtils.getMethodWithArgument(obj.getClass(), setMethodName, argType);
            if (m != null && Modifier.isPublic(m.getModifiers())) {
                try {
                    m.invoke(obj, value);
                    fieldSet = true;
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        String msg = "ResultObject set field=" + fieldName + " using public " + setMethodName + "() method";
                        NucleusLogger.QUERY.debug(msg);
                    }
                }
                catch (Exception e) {}
            } else if (m == null) {
                Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return obj.getClass().getDeclaredMethods();
                    }
                });
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] args = methods[i].getParameterTypes();
                    if (!methods[i].getName().equals(setMethodName) || !Modifier.isPublic(methods[i].getModifiers()) || args == null || args.length != 1) continue;
                    try {
                        methods[i].invoke(obj, ClassUtils.convertValue(value, args[0]));
                        fieldSet = true;
                        if (!NucleusLogger.QUERY.isDebugEnabled()) break;
                        String msg = "ResultObject set field=" + fieldName + " using " + setMethodName + "() method";
                        NucleusLogger.QUERY.debug(msg);
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (!fieldSet && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021207", (Object)obj.getClass().getName(), (Object)setMethodName, (Object)(argType != null ? argType.getName() : null)));
            }
        }
        if (!fieldSet) {
            Method m = QueryUtils.getPublicPutMethodForResultClass(obj.getClass());
            if (m != null) {
                try {
                    m.invoke(obj, fieldName, value);
                    fieldSet = true;
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        String msg = "ResultObject set field=" + fieldName + " using put() method";
                        NucleusLogger.QUERY.debug(msg);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!fieldSet && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021208", (Object)obj.getClass().getName(), (Object)"put"));
            }
        }
        return fieldSet;
    }

    public static Method getPublicSetMethodForFieldOfResultClass(Class resultClass, String fieldName, Class fieldType) {
        String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method m = ClassUtils.getMethodWithArgument(resultClass, setMethodName, fieldType);
        if (m != null && Modifier.isPublic(m.getModifiers())) {
            return m;
        }
        return null;
    }

    public static Method getPublicPutMethodForResultClass(final Class resultClass) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return resultClass.getMethod("put", classArrayObjectObject);
                }
                catch (NoSuchMethodException ex) {
                    return null;
                }
            }
        });
    }

    public static String[] getExpressionsFromString(String str) {
        StringCharacterIterator ci = new StringCharacterIterator(str);
        int braces = 0;
        String text = "";
        ArrayList<String> exprList = new ArrayList<String>();
        while (ci.getIndex() != ci.getEndIndex()) {
            char c = ci.current();
            if (c == ',' && braces == 0) {
                exprList.add(text);
                text = "";
            } else if (c == '(') {
                ++braces;
                text = text + c;
            } else if (c == ')') {
                --braces;
                text = text + c;
            } else {
                text = text + c;
            }
            ci.next();
        }
        exprList.add(text);
        return exprList.toArray(new String[exprList.size()]);
    }

    public static Object getValueForParameterExpression(Map parameterValues, ParameterExpression paramExpr) {
        if (parameterValues == null) {
            return null;
        }
        Object value = parameterValues.get(paramExpr.getId());
        if (value != null) {
            return value;
        }
        value = parameterValues.get(paramExpr.getPosition());
        if (value != null) {
            return value;
        }
        return null;
    }

    public static String getStringValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = (String)obj;
        } else if (obj instanceof Character) {
            value = ((Character)obj).toString();
        } else if (obj instanceof Number) {
            value = ((Number)obj).toString();
        } else if (obj == null) {
            value = null;
        } else {
            throw new NucleusException("getStringValue(obj) where obj is instanceof " + obj.getClass().getName() + " not supported");
        }
        return value;
    }

    public static String getStringValueForExpression(Expression expr, Map parameters) {
        String paramValue = null;
        if (expr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)expr;
            Object obj = QueryUtils.getValueForParameterExpression(parameters, paramExpr);
            paramValue = QueryUtils.getStringValue(obj);
        } else if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            paramValue = QueryUtils.getStringValue(literal.getLiteral());
        } else {
            throw new NucleusException("getStringValueForExpression(expr) where expr is instanceof " + expr.getClass().getName() + " not supported");
        }
        return paramValue;
    }

    public static boolean compareExpressionValues(Object left, Object right, Expression.Operator op) {
        if (left == null || right == null) {
            if (op == Expression.OP_GT) {
                throw new NucleusException("Impossible to evaluate greater_than expression between " + left + " and " + right + " due to presence of null!");
            }
            if (op == Expression.OP_LT) {
                throw new NucleusException("Impossible to evaluate less_than expression between " + left + " and " + right + " due to presence of null!");
            }
            if (op == Expression.OP_GTEQ) {
                if (left == right) {
                    return true;
                }
                throw new NucleusException("Impossible to evaluate greater_equals expression between " + left + " and " + right + " due to presence of null!");
            }
            if (op == Expression.OP_LTEQ) {
                if (left == right) {
                    return true;
                }
                throw new NucleusException("Impossible to evaluate less_equals expression between " + left + " and " + right + " due to presence of null!");
            }
            if (op == Expression.OP_EQ) {
                return left == right;
            }
            if (op == Expression.OP_NOTEQ) {
                return left != right;
            }
        } else if (left instanceof Float || left instanceof Double || left instanceof BigDecimal || right instanceof Float || right instanceof Double || right instanceof BigDecimal) {
            Double leftVal = null;
            Double rightVal = null;
            if (left instanceof BigDecimal) {
                leftVal = new Double(((BigDecimal)left).doubleValue());
            } else if (left instanceof Double) {
                leftVal = (Double)left;
            } else if (left instanceof Float) {
                leftVal = new Double(((Float)left).doubleValue());
            } else if (left instanceof BigInteger) {
                leftVal = new Double(((BigInteger)left).doubleValue());
            } else if (left instanceof Long) {
                leftVal = new Double(((Long)left).doubleValue());
            } else if (left instanceof Integer) {
                leftVal = new Double(((Integer)left).doubleValue());
            } else if (left instanceof Short) {
                leftVal = new Double(((Short)left).doubleValue());
            } else if (left instanceof Enum) {
                leftVal = new Double(((Enum)left).ordinal());
            }
            if (right instanceof BigDecimal) {
                rightVal = new Double(((BigDecimal)right).doubleValue());
            } else if (right instanceof Double) {
                rightVal = (Double)right;
            } else if (right instanceof Float) {
                rightVal = new Double(((Float)right).doubleValue());
            } else if (right instanceof BigInteger) {
                rightVal = new Double(((BigInteger)right).doubleValue());
            } else if (right instanceof Long) {
                rightVal = new Double(((Long)right).doubleValue());
            } else if (right instanceof Integer) {
                rightVal = new Double(((Integer)right).doubleValue());
            } else if (right instanceof Short) {
                rightVal = new Double(((Short)right).doubleValue());
            } else if (right instanceof Enum) {
                rightVal = new Double(((Enum)right).ordinal());
            }
            if (leftVal == null || rightVal == null) {
                throw new NucleusException("Attempt to evaluate relational expression between\"" + left + "\" (type=" + left.getClass().getName() + ") and" + "\"" + right + "\" (type=" + right.getClass().getName() + ") not possible due to types");
            }
            int comparison = leftVal.compareTo(rightVal);
            if (op == Expression.OP_GT) {
                return comparison > 0;
            }
            if (op == Expression.OP_LT) {
                return comparison < 0;
            }
            if (op == Expression.OP_GTEQ) {
                return comparison >= 0;
            }
            if (op == Expression.OP_LTEQ) {
                return comparison <= 0;
            }
            if (op == Expression.OP_EQ) {
                return comparison == 0;
            }
            if (op == Expression.OP_NOTEQ) {
                return comparison != 0;
            }
        } else if (left instanceof Short || left instanceof Integer || left instanceof Long || left instanceof BigInteger || right instanceof Short || right instanceof Integer || right instanceof Long || right instanceof BigInteger) {
            long leftVal = Long.MAX_VALUE;
            long rightVal = Long.MAX_VALUE;
            if (left instanceof BigInteger) {
                leftVal = ((BigInteger)left).longValue();
            } else if (left instanceof Long) {
                leftVal = (Long)left;
            } else if (left instanceof Integer) {
                leftVal = ((Integer)left).longValue();
            } else if (left instanceof Short) {
                leftVal = ((Short)left).longValue();
            } else if (left instanceof BigDecimal) {
                leftVal = ((BigDecimal)left).longValue();
            } else if (left instanceof Double) {
                leftVal = ((Double)left).longValue();
            } else if (left instanceof Float) {
                leftVal = ((Float)left).longValue();
            } else if (left instanceof Enum) {
                leftVal = ((Enum)left).ordinal();
            }
            if (right instanceof BigInteger) {
                rightVal = ((BigInteger)right).longValue();
            } else if (right instanceof Long) {
                rightVal = (Long)right;
            } else if (right instanceof Integer) {
                rightVal = ((Integer)right).longValue();
            } else if (right instanceof Short) {
                rightVal = ((Short)right).longValue();
            } else if (right instanceof BigDecimal) {
                rightVal = ((BigDecimal)right).longValue();
            } else if (right instanceof Double) {
                rightVal = ((Double)right).longValue();
            } else if (right instanceof Float) {
                rightVal = ((Float)right).longValue();
            } else if (right instanceof Enum) {
                rightVal = ((Enum)right).ordinal();
            }
            if (leftVal == Long.MAX_VALUE || rightVal == Long.MAX_VALUE) {
                throw new NucleusException("Attempt to evaluate relational expression between\"" + left + "\" (type=" + left.getClass().getName() + ") and" + "\"" + right + "\" (type=" + right.getClass().getName() + ") not possible due to types");
            }
            if (op == Expression.OP_GT) {
                return leftVal > rightVal;
            }
            if (op == Expression.OP_LT) {
                return leftVal < rightVal;
            }
            if (op == Expression.OP_GTEQ) {
                return leftVal >= rightVal;
            }
            if (op == Expression.OP_LTEQ) {
                return leftVal <= rightVal;
            }
            if (op == Expression.OP_EQ) {
                return leftVal == rightVal;
            }
            if (op == Expression.OP_NOTEQ) {
                return leftVal != rightVal;
            }
        } else {
            if (left instanceof Enum || right instanceof Enum) {
                if (op == Expression.OP_EQ) {
                    if (left == null) {
                        return right == null;
                    }
                    return left.toString().equals(right.toString());
                }
                if (op == Expression.OP_NOTEQ) {
                    if (left == null) {
                        return right != null;
                    }
                    return !left.toString().equals(right.toString());
                }
                throw new NucleusException("Attempt to evaluate relational expression between\"" + left + "\" (type=" + left.getClass().getName() + ") and" + "\"" + right + "\" (type=" + right.getClass().getName() + ") not possible due to types");
            }
            if (op == Expression.OP_EQ) {
                if (left == null) {
                    return right == null;
                }
                return left.equals(right);
            }
            if (op == Expression.OP_NOTEQ) {
                if (left == null) {
                    return right != null;
                }
                return !left.equals(right);
            }
            throw new NucleusException("Attempt to evaluate relational expression between\"" + left + "\" (type=" + left.getClass().getName() + ") and" + "\"" + right + "\" (type=" + right.getClass().getName() + ") not possible due to types");
        }
        throw new NucleusException("Attempt to evaluate relational expression between " + left + " and " + right + " with operation = " + op + " impossible to perform");
    }

    public static boolean expressionHasOrOperator(Expression expr) {
        if (expr instanceof DyadicExpression && expr.getOperator() == Expression.OP_OR) {
            return true;
        }
        if (expr.getLeft() != null && QueryUtils.expressionHasOrOperator(expr.getLeft())) {
            return true;
        }
        return expr.getRight() != null && QueryUtils.expressionHasOrOperator(expr.getRight());
    }

    public static boolean expressionHasNotOperator(Expression expr) {
        if (expr instanceof DyadicExpression && expr.getOperator() == Expression.OP_NOT) {
            return true;
        }
        if (expr.getLeft() != null && QueryUtils.expressionHasNotOperator(expr.getLeft())) {
            return true;
        }
        return expr.getRight() != null && QueryUtils.expressionHasNotOperator(expr.getRight());
    }

    public static ParameterExpression getParameterExpressionForPosition(Expression rootExpr, int pos) {
        InvokeExpression invokeExpr;
        List<Expression> args;
        ParameterExpression paramExpr;
        if (rootExpr instanceof ParameterExpression && ((ParameterExpression)rootExpr).getPosition() == pos) {
            return (ParameterExpression)rootExpr;
        }
        if (rootExpr.getLeft() != null && (paramExpr = QueryUtils.getParameterExpressionForPosition(rootExpr.getLeft(), pos)) != null) {
            return paramExpr;
        }
        if (rootExpr.getRight() != null && (paramExpr = QueryUtils.getParameterExpressionForPosition(rootExpr.getRight(), pos)) != null) {
            return paramExpr;
        }
        if (rootExpr instanceof InvokeExpression && (args = (invokeExpr = (InvokeExpression)rootExpr).getArguments()) != null) {
            Iterator<Expression> argIter = args.iterator();
            while (argIter.hasNext()) {
                ParameterExpression paramExpr2 = QueryUtils.getParameterExpressionForPosition(argIter.next(), pos);
                if (paramExpr2 == null) continue;
                return paramExpr2;
            }
        }
        return null;
    }

    public static boolean queryParameterTypesAreCompatible(Class cls1, Class cls2) {
        Class first = cls1;
        Class second = cls2;
        if (cls1.isPrimitive()) {
            first = ClassUtils.getWrapperTypeForPrimitiveType(cls1);
        }
        if (cls2.isPrimitive()) {
            second = ClassUtils.getWrapperTypeForPrimitiveType(cls2);
        }
        if (first.isAssignableFrom(second)) {
            return true;
        }
        return Number.class.isAssignableFrom(first) && Number.class.isAssignableFrom(cls2);
    }

    public static String getKeyForQueryResultsCache(Query query, Map params) {
        if (params != null && params.size() > 0) {
            return query.getLanguage() + ":" + query.toString() + ":" + ((Object)params).hashCode();
        }
        return query.getLanguage() + ":" + query.toString() + ":";
    }
}

