/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.connection;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;

public abstract class AbstractManagedConnection
implements ManagedConnection {
    protected Object conn;
    protected boolean managed = false;
    protected boolean locked = false;
    protected List<ManagedConnectionResourceListener> listeners = new ArrayList<ManagedConnectionResourceListener>();

    public void release() {
        if (!this.managed) {
            this.close();
        }
    }

    public void setManagedResource() {
        this.managed = true;
    }

    public void addListener(ManagedConnectionResourceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ManagedConnectionResourceListener listener) {
        this.listeners.remove(listener);
    }

    public void flush() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).managedConnectionFlushed();
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public String toString() {
        return "[" + super.toString() + ", " + this.conn + "]";
    }
}

