/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.NullMapping;

public class NullLiteral
extends ScalarExpression
implements Literal {
    public NullLiteral(QueryExpression qs) {
        super(qs);
        this.mapping = new NullMapping(qs.getStoreManager());
        this.st.append("NULL");
    }

    public Object getValue() {
        return null;
    }

    public ScalarExpression add(ScalarExpression expr) {
        return this;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        if (expr instanceof ObjectExpression) {
            return expr.eq(this);
        }
        return new BooleanExpression(expr, OP_IS, this);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, false);
        }
        if (expr instanceof ObjectExpression) {
            return expr.noteq(this);
        }
        return new BooleanExpression(expr, OP_ISNOT, this);
    }

    public void setRawValue(Object val) {
    }

    public Object getRawValue() {
        return null;
    }
}

