/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class AbstractMergeTestBase
extends HBaseClusterTestCase {
    static final Log LOG = LogFactory.getLog((String)AbstractMergeTestBase.class.getName());
    static final byte[] COLUMN_NAME = Bytes.toBytes("contents");
    protected final Random rand = new Random();
    protected HTableDescriptor desc;
    protected ImmutableBytesWritable value;
    protected boolean startMiniHBase;

    public AbstractMergeTestBase() {
        this(true);
    }

    public AbstractMergeTestBase(boolean startMiniHBase) {
        this.startMiniHBase = startMiniHBase;
        String partialValue = String.valueOf(System.currentTimeMillis());
        StringBuilder val = new StringBuilder();
        while (val.length() < 1024) {
            val.append(partialValue);
        }
        try {
            this.value = new ImmutableBytesWritable(val.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            AbstractMergeTestBase.fail();
        }
        this.desc = new HTableDescriptor(Bytes.toBytes("test"));
        this.desc.addFamily(new HColumnDescriptor(COLUMN_NAME));
    }

    @Override
    protected void hBaseClusterSetup() throws Exception {
        if (this.startMiniHBase) {
            super.hBaseClusterSetup();
        }
    }

    @Override
    public void preHBaseClusterSetup() throws Exception {
        this.conf.setLong("hbase.hregion.max.filesize", 0x4000000L);
        byte[] row_70001 = Bytes.toBytes("row_70001");
        byte[] row_80001 = Bytes.toBytes("row_80001");
        HRegion[] regions = new HRegion[]{this.createAregion(null, row_70001, 1, 70000), this.createAregion(row_70001, row_80001, 70001, 10000), this.createAregion(row_80001, null, 80001, 11000)};
        this.createRootAndMetaRegions();
        for (int i = 0; i < regions.length; ++i) {
            HRegion.addRegionToMETA(this.meta, regions[i]);
        }
        this.closeRootAndMeta();
    }

    private HRegion createAregion(byte[] startKey, byte[] endKey, int firstRow, int nrows) throws IOException {
        HRegion region = this.createNewHRegion(this.desc, startKey, endKey);
        System.out.println("created region " + Bytes.toString(region.getRegionName()));
        HBaseTestCase.HRegionIncommon r = new HBaseTestCase.HRegionIncommon(region);
        for (int i = firstRow; i < firstRow + nrows; ++i) {
            Put put = new Put(Bytes.toBytes("row_" + String.format("%1$05d", i)));
            put.add(COLUMN_NAME, null, this.value.get());
            region.put(put);
            if (i % 10000 != 0) continue;
            System.out.println("Flushing write #" + i);
            r.flushcache();
        }
        region.close();
        region.getLog().closeAndDelete();
        region.getRegionInfo().setOffline(true);
        return region;
    }
}

