/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import agilejson.TOJSON;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.IRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.ISerializable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class HColumnDescriptor
implements ISerializable,
WritableComparable<HColumnDescriptor> {
    private static final byte COLUMN_DESCRIPTOR_VERSION = 7;
    public static final String COMPRESSION = "COMPRESSION";
    public static final String BLOCKCACHE = "BLOCKCACHE";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String LENGTH = "LENGTH";
    public static final String TTL = "TTL";
    public static final String BLOOMFILTER = "BLOOMFILTER";
    public static final String FOREVER = "FOREVER";
    public static final String MAPFILE_INDEX_INTERVAL = "MAPFILE_INDEX_INTERVAL";
    public static final String DEFAULT_COMPRESSION = Compression.Algorithm.NONE.getName();
    public static final int DEFAULT_VERSIONS = 3;
    private volatile Integer blocksize = null;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final boolean DEFAULT_BLOCKCACHE = true;
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final boolean DEFAULT_BLOOMFILTER = false;
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    private byte[] name;
    protected Map<ImmutableBytesWritable, ImmutableBytesWritable> values = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
    private int cachedMaxVersions = -1;

    public HColumnDescriptor() {
        this.name = null;
    }

    public HColumnDescriptor(String familyName) {
        this(Bytes.toBytes(familyName));
    }

    public HColumnDescriptor(byte[] familyName) {
        this(familyName == null || familyName.length <= 0 ? HConstants.EMPTY_BYTE_ARRAY : familyName, 3, DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, false);
    }

    public HColumnDescriptor(HColumnDescriptor desc) {
        this.name = (byte[])desc.name.clone();
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : desc.values.entrySet()) {
            this.values.put(e.getKey(), e.getValue());
        }
    }

    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int timeToLive, boolean bloomFilter) {
        this(familyName, maxVersions, compression, inMemory, blockCacheEnabled, 65536, timeToLive, bloomFilter);
    }

    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int blocksize, int timeToLive, boolean bloomFilter) {
        this.name = HColumnDescriptor.stripColon(familyName);
        HColumnDescriptor.isLegalFamilyName(this.name);
        if (maxVersions <= 0) {
            throw new IllegalArgumentException("Maximum versions must be positive");
        }
        this.setMaxVersions(maxVersions);
        this.setInMemory(inMemory);
        this.setBlockCacheEnabled(blockCacheEnabled);
        this.setTimeToLive(timeToLive);
        this.setCompressionType(Compression.Algorithm.valueOf(compression.toUpperCase()));
        this.setBloomfilter(bloomFilter);
        this.setBlocksize(blocksize);
    }

    private static byte[] stripColon(byte[] n) {
        byte col = n[n.length - 1];
        if (col == 58) {
            byte[] res = new byte[n.length - 1];
            System.arraycopy(n, 0, res, 0, n.length - 1);
            return res;
        }
        return n;
    }

    public static byte[] isLegalFamilyName(byte[] b) {
        if (b == null) {
            return b;
        }
        if (b[0] == 46) {
            throw new IllegalArgumentException("Family names cannot start with a period: " + Bytes.toString(b));
        }
        for (int i = 0; i < b.length - 1; ++i) {
            if (!Character.isISOControl(b[i]) && b[i] != 58) continue;
            throw new IllegalArgumentException("Illegal character <" + b[i] + ">. Family names cannot contain control characters or colons: " + Bytes.toString(b));
        }
        return b;
    }

    public byte[] getName() {
        return this.name;
    }

    @TOJSON(fieldName="name", base64=true)
    public byte[] getNameWithColon() {
        return Bytes.add(this.name, new byte[]{58});
    }

    public String getNameAsString() {
        return Bytes.toString(this.name);
    }

    public byte[] getValue(byte[] key) {
        ImmutableBytesWritable ibw = this.values.get(new ImmutableBytesWritable(key));
        if (ibw == null) {
            return null;
        }
        return ibw.get();
    }

    public String getValue(String key) {
        byte[] value = this.getValue(Bytes.toBytes(key));
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public Map<ImmutableBytesWritable, ImmutableBytesWritable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public void setValue(byte[] key, byte[] value) {
        this.values.put(new ImmutableBytesWritable(key), new ImmutableBytesWritable(value));
    }

    public void remove(byte[] key) {
        this.values.remove(new ImmutableBytesWritable(key));
    }

    public void setValue(String key, String value) {
        this.setValue(Bytes.toBytes(key), Bytes.toBytes(value));
    }

    @TOJSON
    public Compression.Algorithm getCompression() {
        String n = this.getValue(COMPRESSION);
        return Compression.Algorithm.valueOf(n.toUpperCase());
    }

    @TOJSON
    public synchronized int getMaxVersions() {
        if (this.cachedMaxVersions == -1) {
            String value = this.getValue("VERSIONS");
            this.cachedMaxVersions = value != null ? Integer.valueOf(value) : 3;
        }
        return this.cachedMaxVersions;
    }

    public void setMaxVersions(int maxVersions) {
        this.setValue("VERSIONS", Integer.toString(maxVersions));
    }

    @TOJSON
    public synchronized int getBlocksize() {
        if (this.blocksize == null) {
            String value = this.getValue(BLOCKSIZE);
            this.blocksize = value != null ? Integer.decode(value) : Integer.valueOf(65536);
        }
        return this.blocksize;
    }

    public void setBlocksize(int s) {
        this.setValue(BLOCKSIZE, Integer.toString(s));
        this.blocksize = null;
    }

    @TOJSON
    public Compression.Algorithm getCompressionType() {
        return this.getCompression();
    }

    public void setCompressionType(Compression.Algorithm type) {
        String compressionType;
        switch (type) {
            case LZO: {
                compressionType = "LZO";
                break;
            }
            case GZ: {
                compressionType = "GZ";
                break;
            }
            default: {
                compressionType = "NONE";
            }
        }
        this.setValue(COMPRESSION, compressionType);
    }

    @TOJSON(prefixLength=2)
    public boolean isInMemory() {
        String value = this.getValue("IN_MEMORY");
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public void setInMemory(boolean inMemory) {
        this.setValue("IN_MEMORY", Boolean.toString(inMemory));
    }

    @TOJSON
    public int getTimeToLive() {
        String value = this.getValue(TTL);
        return value != null ? Integer.valueOf(value) : Integer.MAX_VALUE;
    }

    public void setTimeToLive(int timeToLive) {
        this.setValue(TTL, Integer.toString(timeToLive));
    }

    @TOJSON(prefixLength=2)
    public boolean isBlockCacheEnabled() {
        String value = this.getValue(BLOCKCACHE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public void setBlockCacheEnabled(boolean blockCacheEnabled) {
        this.setValue(BLOCKCACHE, Boolean.toString(blockCacheEnabled));
    }

    @TOJSON(prefixLength=2)
    public boolean isBloomfilter() {
        String value = this.getValue(BLOOMFILTER);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public void setBloomfilter(boolean onOff) {
        this.setValue(BLOOMFILTER, Boolean.toString(onOff));
    }

    public void setMapFileIndexInterval(int interval) {
        this.setValue(MAPFILE_INDEX_INTERVAL, Integer.toString(interval));
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString(this.name));
        s.append("'");
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            String key = Bytes.toString(e.getKey().get());
            String value = Bytes.toString(e.getValue().get());
            if (key != null && key.toUpperCase().equals(BLOOMFILTER)) continue;
            s.append(", ");
            s.append(key);
            s.append(" => '");
            s.append(value);
            s.append("'");
        }
        s.append('}');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HColumnDescriptor)) {
            return false;
        }
        return this.compareTo((HColumnDescriptor)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.name);
        result ^= Byte.valueOf((byte)7).hashCode();
        return result ^= ((Object)this.values).hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version < 6) {
            if (version <= 2) {
                Text t = new Text();
                t.readFields(in);
                this.name = t.getBytes();
            } else {
                this.name = Bytes.readByteArray(in);
            }
            this.values.clear();
            this.setMaxVersions(in.readInt());
            int ordinal = in.readInt();
            this.setCompressionType(Compression.Algorithm.values()[ordinal]);
            this.setInMemory(in.readBoolean());
            this.setBloomfilter(in.readBoolean());
            if (this.isBloomfilter() && version < 5) {
                throw new UnsupportedClassVersionError(this.getClass().getName() + " does not support backward compatibility with versions older " + "than version 5");
            }
            if (version > 1) {
                this.setBlockCacheEnabled(in.readBoolean());
            }
            if (version > 2) {
                this.setTimeToLive(in.readInt());
            }
        } else {
            this.name = Bytes.readByteArray(in);
            this.values.clear();
            int numValues = in.readInt();
            for (int i = 0; i < numValues; ++i) {
                ImmutableBytesWritable key = new ImmutableBytesWritable();
                ImmutableBytesWritable value = new ImmutableBytesWritable();
                key.readFields(in);
                value.readFields(in);
                this.values.put(key, value);
            }
            if (version == 6) {
                this.setValue(COMPRESSION, Compression.Algorithm.NONE.getName());
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(7);
        Bytes.writeByteArray(out, this.name);
        out.writeInt(this.values.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            e.getKey().write(out);
            e.getValue().write(out);
        }
    }

    public int compareTo(HColumnDescriptor o) {
        int result = Bytes.compareTo(this.name, o.getName());
        if (result == 0) {
            result = ((Object)this.values).hashCode() - ((Object)o.values).hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public void restSerialize(IRestSerializer serializer) throws HBaseRestException {
        serializer.serializeColumnDescriptor(this);
    }

    @Deprecated
    public static enum CompressionType {
        NONE,
        RECORD,
        BLOCK;

    }
}

