/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.util.Bytes;

public class TestMasterAdmin
extends HBaseClusterTestCase {
    private final Log LOG = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private static final byte[] COLUMN_NAME = Bytes.toBytes("col1:");
    private static HTableDescriptor testDesc = new HTableDescriptor("testadmin1");
    private HBaseAdmin admin = null;

    public TestMasterAdmin() {
        this.conf.setInt("hbase.server.thread.wakefrequency", 2000);
    }

    public void testMasterAdmin() throws Exception {
        this.admin = new HBaseAdmin(this.conf);
        boolean exception = false;
        try {
            this.admin.createTable(new HTableDescriptor());
        }
        catch (IllegalArgumentException e) {
            exception = true;
        }
        TestMasterAdmin.assertTrue((boolean)exception);
        this.admin.createTable(testDesc);
        this.LOG.info((Object)("Table " + testDesc.getNameAsString() + " created"));
        this.admin.disableTable(testDesc.getName());
        this.LOG.info((Object)("Table " + testDesc.getNameAsString() + " disabled"));
        try {
            HTable table = new HTable(this.conf, testDesc.getName());
        }
        catch (RegionOfflineException e) {
            // empty catch block
        }
        this.admin.addColumn(testDesc.getName(), new HColumnDescriptor("col2:"));
        this.admin.enableTable(testDesc.getName());
        try {
            this.admin.deleteColumn(testDesc.getName(), Bytes.toBytes("col2:"));
        }
        catch (TableNotDisabledException tableNotDisabledException) {
            // empty catch block
        }
        this.admin.disableTable(testDesc.getName());
        this.admin.deleteColumn(testDesc.getName(), Bytes.toBytes("col2:"));
        this.admin.deleteTable(testDesc.getName());
    }

    static {
        testDesc.addFamily(new HColumnDescriptor(COLUMN_NAME));
    }
}

