/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;

public class TestRegionRebalancing
extends HBaseClusterTestCase {
    final Log LOG = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    HTable table;
    HTableDescriptor desc;
    final byte[] FIVE_HUNDRED_KBYTES;
    final byte[] COLUMN_NAME = Bytes.toBytes("col:");

    public TestRegionRebalancing() {
        super(1);
        this.FIVE_HUNDRED_KBYTES = new byte[512000];
        for (int i = 0; i < 512000; ++i) {
            this.FIVE_HUNDRED_KBYTES[i] = 120;
        }
        this.desc = new HTableDescriptor("test");
        this.desc.addFamily(new HColumnDescriptor(this.COLUMN_NAME));
    }

    @Override
    public void preHBaseClusterSetup() throws IOException {
        ArrayList<byte[]> startKeys = new ArrayList<byte[]>();
        startKeys.add(null);
        for (int i = 10; i < 29; ++i) {
            startKeys.add(Bytes.toBytes("row_" + i));
        }
        startKeys.add(null);
        this.LOG.info((Object)(startKeys.size() + " start keys generated"));
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        for (int i = 0; i < 20; ++i) {
            regions.add(this.createAregion((byte[])startKeys.get(i), (byte[])startKeys.get(i + 1)));
        }
        this.createRootAndMetaRegions();
        for (HRegion region : regions) {
            HRegion.addRegionToMETA(this.meta, region);
        }
        this.closeRootAndMeta();
    }

    public void testRebalancing() throws IOException {
        this.table = new HTable(this.conf, "test");
        TestRegionRebalancing.assertEquals((String)"Test table should have 20 regions", (int)20, (int)this.table.getStartKeys().length);
        this.assertRegionsAreBalanced();
        this.LOG.debug((Object)"Adding 2nd region server.");
        this.cluster.startRegionServer();
        this.assertRegionsAreBalanced();
        this.LOG.debug((Object)"Adding 3rd region server.");
        this.cluster.startRegionServer();
        this.assertRegionsAreBalanced();
        this.LOG.debug((Object)"Killing the 3rd region server.");
        this.cluster.stopRegionServer(2, false);
        this.cluster.waitOnRegionServer(2);
        this.assertRegionsAreBalanced();
        this.LOG.debug((Object)"Adding 3rd region server");
        this.cluster.startRegionServer();
        this.LOG.debug((Object)"Adding 4th region server");
        this.cluster.startRegionServer();
        this.assertRegionsAreBalanced();
        for (int i = 0; i < 6; ++i) {
            this.LOG.debug((Object)("Adding " + (i + 5) + "th region server"));
            this.cluster.startRegionServer();
        }
        this.assertRegionsAreBalanced();
    }

    private int getRegionCount() {
        int total = 0;
        for (HRegionServer server : this.getOnlineRegionServers()) {
            total += server.getOnlineRegions().size();
        }
        return total;
    }

    private void assertRegionsAreBalanced() {
        boolean success = false;
        float slop = this.conf.getFloat("hbase.regions.slop", 0.1f);
        if (slop <= 0.0f) {
            slop = 1.0f;
        }
        for (int i = 0; i < 5; ++i) {
            success = true;
            this.waitForAllRegionsAssigned();
            int regionCount = this.getRegionCount();
            List<HRegionServer> servers = this.getOnlineRegionServers();
            double avg = this.cluster.getMaster().getAverageLoad();
            int avgLoadPlusSlop = (int)Math.ceil(avg * (double)(1.0f + slop));
            int avgLoadMinusSlop = (int)Math.floor(avg * (double)(1.0f - slop)) - 1;
            this.LOG.debug((Object)("There are " + servers.size() + " servers and " + regionCount + " regions. Load Average: " + avg + " low border: " + avgLoadMinusSlop + ", up border: " + avgLoadPlusSlop + "; attempt: " + i));
            for (HRegionServer server : servers) {
                int serverLoad = server.getOnlineRegions().size();
                this.LOG.debug((Object)(server.hashCode() + " Avg: " + avg + " actual: " + serverLoad));
                if (avg > 2.0 && serverLoad <= avgLoadPlusSlop && serverLoad >= avgLoadMinusSlop) continue;
                this.LOG.debug((Object)(server.hashCode() + " Isn't balanced!!! Avg: " + avg + " actual: " + serverLoad + " slop: " + slop));
                success = false;
            }
            if (!success) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            return;
        }
        TestRegionRebalancing.fail((String)"After 5 attempts, region assignments were not balanced.");
    }

    private List<HRegionServer> getOnlineRegionServers() {
        ArrayList<HRegionServer> list = new ArrayList<HRegionServer>();
        for (LocalHBaseCluster.RegionServerThread rst : this.cluster.getRegionThreads()) {
            if (!rst.getRegionServer().isOnline()) continue;
            list.add(rst.getRegionServer());
        }
        return list;
    }

    private void waitForAllRegionsAssigned() {
        while (this.getRegionCount() < 22) {
            this.LOG.debug((Object)("Waiting for there to be 22 regions, but there are " + this.getRegionCount() + " right now."));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private HRegion createAregion(byte[] startKey, byte[] endKey) throws IOException {
        HRegion region = this.createNewHRegion(this.desc, startKey, endKey);
        byte[] keyToWrite = startKey == null ? Bytes.toBytes("row_000") : startKey;
        Put put = new Put(keyToWrite);
        byte[][] famAndQf = KeyValue.parseColumn(this.COLUMN_NAME);
        put.add(famAndQf[0], famAndQf[1], Bytes.toBytes("test"));
        region.put(put);
        region.close();
        region.getLog().closeAndDelete();
        return region;
    }
}

