/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

public class TestTable
extends HBaseClusterTestCase {
    public void testCreateTable() throws IOException {
        int i;
        final HBaseAdmin admin = new HBaseAdmin(this.conf);
        String msg = null;
        try {
            admin.createTable(HTableDescriptor.ROOT_TABLEDESC);
        }
        catch (IllegalArgumentException e) {
            msg = e.toString();
        }
        TestTable.assertTrue((String)("Unexcepted exception message " + msg), (msg != null && msg.startsWith(IllegalArgumentException.class.getName()) && msg.contains(HTableDescriptor.ROOT_TABLEDESC.getNameAsString()) ? 1 : 0) != 0);
        msg = null;
        try {
            admin.createTable(HTableDescriptor.META_TABLEDESC);
        }
        catch (IllegalArgumentException e) {
            msg = e.toString();
        }
        TestTable.assertTrue((String)("Unexcepted exception message " + msg), (msg != null && msg.startsWith(IllegalArgumentException.class.getName()) && msg.contains(HTableDescriptor.META_TABLEDESC.getNameAsString()) ? 1 : 0) != 0);
        msg = null;
        HTableDescriptor desc = new HTableDescriptor(this.getName());
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        admin.createTable(desc);
        TestTable.assertTrue((String)"First table creation completed", (admin.listTables().length == 1 ? 1 : 0) != 0);
        boolean gotException = false;
        try {
            admin.createTable(desc);
        }
        catch (TableExistsException e) {
            gotException = true;
            msg = e.getMessage();
        }
        TestTable.assertTrue((String)"Didn't get a TableExistsException!", (boolean)gotException);
        TestTable.assertTrue((String)("Unexpected exception message " + msg), (msg != null && msg.contains(this.getName()) ? 1 : 0) != 0);
        final HTableDescriptor threadDesc = new HTableDescriptor("threaded_" + this.getName());
        threadDesc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        int count = 10;
        Thread[] threads = new Thread[count];
        final AtomicInteger successes = new AtomicInteger(0);
        final AtomicInteger failures = new AtomicInteger(0);
        for (i = 0; i < count; ++i) {
            threads[i] = new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    try {
                        admin.createTable(threadDesc);
                        successes.incrementAndGet();
                    }
                    catch (TableExistsException e) {
                        failures.incrementAndGet();
                    }
                    catch (IOException e) {
                        System.out.println("Got an IOException... " + e);
                        Assert.fail();
                    }
                }
            };
        }
        for (i = 0; i < count; ++i) {
            threads[i].start();
        }
        for (i = 0; i < count; ++i) {
            while (threads[i].isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
        TestTable.assertEquals((int)1, (int)successes.get());
        TestTable.assertEquals((int)(count - 1), (int)failures.get());
    }

    public void testTableNameClash() throws Exception {
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(new HTableDescriptor(this.getName() + "SOMEUPPERCASE"));
        admin.createTable(new HTableDescriptor(this.getName()));
        HTable table = new HTable(this.conf, this.getName());
    }

    public void testReadOnlyTable() throws Exception {
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        HTableDescriptor desc = new HTableDescriptor(this.getName());
        byte[] colName = Bytes.toBytes("test:");
        desc.addFamily(new HColumnDescriptor(colName));
        desc.setReadOnly(true);
        admin.createTable(desc);
        HTable table = new HTable(this.conf, this.getName());
        try {
            byte[] value = Bytes.toBytes("somedata");
            Put put = new Put(value);
            byte[][] famAndQf = KeyValue.parseColumn(colName);
            put.add(famAndQf[0], famAndQf[1], value);
            table.put(put);
            TestTable.fail((String)"Put on read only table succeeded");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testTableNames() {
        byte[][] illegalNames = new byte[][]{Bytes.toBytes("-bad"), Bytes.toBytes(".bad"), HConstants.ROOT_TABLE_NAME, HConstants.META_TABLE_NAME};
        for (int i = 0; i < illegalNames.length; ++i) {
            try {
                new HTableDescriptor(illegalNames[i]);
                TestTable.fail((String)("Did not detect '" + Bytes.toString(illegalNames[i]) + "' as an illegal user table name"));
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        byte[] legalName = Bytes.toBytes("g-oo.d");
        try {
            new HTableDescriptor(legalName);
        }
        catch (IllegalArgumentException e) {
            TestTable.fail((String)("Legal user table name: '" + Bytes.toString(legalName) + "' caused IllegalArgumentException: " + e.getMessage()));
        }
    }
}

