/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.util.Bytes;

public class TestHBaseAdmin
extends HBaseClusterTestCase {
    static final Log LOG = LogFactory.getLog((String)TestHBaseAdmin.class.getName());
    private String TABLE_STR = "testTable";
    private byte[] TABLE = Bytes.toBytes(this.TABLE_STR);
    private byte[] ROW = Bytes.toBytes("testRow");
    private byte[] FAMILY = Bytes.toBytes("testFamily");
    private byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private byte[] VALUE = Bytes.toBytes("testValue");
    private HBaseAdmin admin = null;
    private HConnection connection = null;

    public void testCreateTable() throws IOException {
        this.init();
        HTableDescriptor[] tables = this.connection.listTables();
        int numTables = tables.length;
        this.createTable(this.TABLE, new byte[][]{this.FAMILY});
        tables = this.connection.listTables();
        TestHBaseAdmin.assertEquals((int)(numTables + 1), (int)tables.length);
    }

    public void testDisableAndEnableTable() throws IOException {
        this.init();
        HTable ht = this.createTable(this.TABLE, new byte[][]{this.FAMILY});
        Put put = new Put(this.ROW);
        put.add(this.FAMILY, this.QUALIFIER, this.VALUE);
        ht.put(put);
        this.admin.disableTable(this.TABLE);
        Get get2 = new Get(this.ROW);
        get2.addColumn(this.FAMILY, this.QUALIFIER);
        boolean ok = false;
        try {
            ht.get(get2);
        }
        catch (RetriesExhaustedException e) {
            ok = true;
        }
        TestHBaseAdmin.assertEquals((boolean)true, (boolean)ok);
        this.admin.enableTable(this.TABLE);
        try {
            ht.get(get2);
        }
        catch (RetriesExhaustedException e) {
            ok = false;
        }
        TestHBaseAdmin.assertEquals((boolean)true, (boolean)ok);
    }

    public void testTableExist() throws IOException {
        this.init();
        boolean exist = false;
        exist = this.admin.tableExists(this.TABLE);
        TestHBaseAdmin.assertEquals((boolean)false, (boolean)exist);
        this.createTable(this.TABLE, new byte[][]{this.FAMILY});
        exist = this.admin.tableExists(this.TABLE);
        TestHBaseAdmin.assertEquals((boolean)true, (boolean)exist);
    }

    private byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add(base, new byte[]{(byte)i});
        }
        return ret;
    }

    private HTable createTable(byte[] tableName, byte[] ... families) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            desc.addFamily(new HColumnDescriptor(family));
        }
        this.admin = new HBaseAdmin(this.conf);
        this.admin.createTable(desc);
        return new HTable(this.conf, tableName);
    }

    private void init() throws IOException {
        this.connection = new HBaseAdmin((HBaseConfiguration)this.conf).connection;
        this.admin = new HBaseAdmin(this.conf);
    }
}

