/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.TestGetRowVersions;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.util.Bytes;

public class TestOldAPIGetRowVersions
extends HBaseClusterTestCase {
    private static final Log LOG = LogFactory.getLog(TestGetRowVersions.class);
    private static final String TABLE_NAME = "test";
    private static final String CONTENTS_STR = "contents:";
    private static final String ROW = "row";
    private static final String COLUMN = "contents:contents";
    private static final long TIMESTAMP = System.currentTimeMillis();
    private static final String VALUE1 = "value1";
    private static final String VALUE2 = "value2";
    private HBaseAdmin admin = null;
    private HTable table = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        HTableDescriptor desc = new HTableDescriptor(TABLE_NAME);
        desc.addFamily(new HColumnDescriptor(CONTENTS_STR));
        this.admin = new HBaseAdmin(this.conf);
        this.admin.createTable(desc);
        this.table = new HTable(this.conf, TABLE_NAME);
    }

    public void testGetRowMultipleVersions() throws Exception {
        BatchUpdate b = new BatchUpdate(ROW, TIMESTAMP);
        b.put(COLUMN, Bytes.toBytes(VALUE1));
        this.table.commit(b);
        Cell c = this.table.get(ROW, COLUMN);
        TestOldAPIGetRowVersions.assertEquals((String)VALUE1, (String)Bytes.toString(c.getValue()));
        b = new BatchUpdate(ROW, TIMESTAMP);
        b.put(COLUMN, Bytes.toBytes(VALUE2));
        this.table.commit(b);
        c = this.table.get(ROW, COLUMN);
        LOG.info((Object)("Got " + Bytes.toString(c.getValue())));
        TestOldAPIGetRowVersions.assertEquals((String)VALUE2, (String)Bytes.toString(c.getValue()));
        RowResult r = this.table.getRow(ROW);
        TestOldAPIGetRowVersions.assertNotNull((Object)r);
        TestOldAPIGetRowVersions.assertTrue((r.size() != 0 ? 1 : 0) != 0);
        c = r.get(COLUMN);
        TestOldAPIGetRowVersions.assertNotNull((Object)c);
        TestOldAPIGetRowVersions.assertTrue((c.getValue().length != 0 ? 1 : 0) != 0);
        String value = Bytes.toString(c.getValue());
        TestOldAPIGetRowVersions.assertTrue((value.compareTo(VALUE2) == 0 ? 1 : 0) != 0);
        r = this.table.getRow(ROW, Integer.MAX_VALUE);
        for (Map.Entry<byte[], Cell> e : r.entrySet()) {
            c = e.getValue();
            for (Map.Entry<Long, byte[]> v : c) {
                value = Bytes.toString(v.getValue());
                TestOldAPIGetRowVersions.assertTrue((VALUE2.compareTo(Bytes.toString(v.getValue())) == 0 ? 1 : 0) != 0);
            }
        }
    }
}

