/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;

public class RowFilter
extends CompareFilter {
    private boolean filterOutRow = false;

    public RowFilter() {
    }

    public RowFilter(CompareFilter.CompareOp rowCompareOp, WritableByteArrayComparable rowComparator) {
        super(rowCompareOp, rowComparator);
    }

    @Override
    public void reset() {
        this.filterOutRow = false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        if (this.filterOutRow) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRowKey(byte[] data, int offset, int length) {
        if (this.doCompare(this.compareOp, this.comparator, data, offset, length)) {
            this.filterOutRow = true;
        }
        return this.filterOutRow;
    }

    @Override
    public boolean filterRow() {
        return this.filterOutRow;
    }
}

