/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class TestFilter
extends HBaseTestCase {
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private HRegion region;
    private static final byte[][] ROWS_ONE = new byte[][]{Bytes.toBytes("testRowOne-0"), Bytes.toBytes("testRowOne-1"), Bytes.toBytes("testRowOne-2"), Bytes.toBytes("testRowOne-3")};
    private static final byte[][] ROWS_TWO = new byte[][]{Bytes.toBytes("testRowTwo-0"), Bytes.toBytes("testRowTwo-1"), Bytes.toBytes("testRowTwo-2"), Bytes.toBytes("testRowTwo-3")};
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes("testFamilyOne"), Bytes.toBytes("testFamilyTwo")};
    private static final byte[][] QUALIFIERS_ONE = new byte[][]{Bytes.toBytes("testQualifierOne-0"), Bytes.toBytes("testQualifierOne-1"), Bytes.toBytes("testQualifierOne-2"), Bytes.toBytes("testQualifierOne-3")};
    private static final byte[][] QUALIFIERS_TWO = new byte[][]{Bytes.toBytes("testQualifierTwo-0"), Bytes.toBytes("testQualifierTwo-1"), Bytes.toBytes("testQualifierTwo-2"), Bytes.toBytes("testQualifierTwo-3")};
    private static final byte[][] VALUES = new byte[][]{Bytes.toBytes("testValueOne"), Bytes.toBytes("testValueTwo")};
    private long numRows = ROWS_ONE.length + ROWS_TWO.length;
    private long colsPerRow = FAMILIES.length * QUALIFIERS_ONE.length;

    @Override
    protected void setUp() throws Exception {
        Delete d;
        Put p;
        super.setUp();
        HTableDescriptor htd = new HTableDescriptor(this.getName());
        htd.addFamily(new HColumnDescriptor(FAMILIES[0]));
        htd.addFamily(new HColumnDescriptor(FAMILIES[1]));
        HRegionInfo info = new HRegionInfo(htd, null, null, false);
        this.region = HRegion.createHRegion(info, this.testDir, this.conf);
        for (byte[] ROW : ROWS_ONE) {
            p = new Put(ROW);
            for (byte[] QUALIFIER : QUALIFIERS_ONE) {
                p.add(FAMILIES[0], QUALIFIER, VALUES[0]);
            }
            this.region.put(p);
        }
        for (byte[] ROW : ROWS_TWO) {
            p = new Put(ROW);
            for (byte[] QUALIFIER : QUALIFIERS_TWO) {
                p.add(FAMILIES[1], QUALIFIER, VALUES[1]);
            }
            this.region.put(p);
        }
        this.region.flushcache();
        for (byte[] ROW : ROWS_ONE) {
            p = new Put(ROW);
            for (byte[] QUALIFIER : QUALIFIERS_ONE) {
                p.add(FAMILIES[1], QUALIFIER, VALUES[0]);
            }
            this.region.put(p);
        }
        for (byte[] ROW : ROWS_TWO) {
            p = new Put(ROW);
            for (byte[] QUALIFIER : QUALIFIERS_TWO) {
                p.add(FAMILIES[0], QUALIFIER, VALUES[1]);
            }
            this.region.put(p);
        }
        for (byte[] ROW : ROWS_ONE) {
            d = new Delete(ROW);
            d.deleteColumns(FAMILIES[0], QUALIFIERS_ONE[1]);
            d.deleteColumns(FAMILIES[1], QUALIFIERS_ONE[1]);
            this.region.delete(d, null, false);
        }
        for (byte[] ROW : ROWS_TWO) {
            d = new Delete(ROW);
            d.deleteColumns(FAMILIES[0], QUALIFIERS_TWO[1]);
            d.deleteColumns(FAMILIES[1], QUALIFIERS_TWO[1]);
            this.region.delete(d, null, false);
        }
        this.colsPerRow -= 2L;
        for (byte[] QUALIFIER : QUALIFIERS_ONE) {
            d = new Delete(ROWS_ONE[1]);
            d.deleteColumns(FAMILIES[0], QUALIFIER);
            d.deleteColumns(FAMILIES[1], QUALIFIER);
            this.region.delete(d, null, false);
        }
        for (byte[] QUALIFIER : QUALIFIERS_TWO) {
            d = new Delete(ROWS_TWO[1]);
            d.deleteColumns(FAMILIES[0], QUALIFIER);
            d.deleteColumns(FAMILIES[1], QUALIFIER);
            this.region.delete(d, null, false);
        }
        this.numRows -= 2L;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.region.close();
    }

    public void testNoFilter() throws Exception {
        long expectedRows = this.numRows;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan();
        this.verifyScan(s, expectedRows, expectedKeys);
        s = new Scan();
        s.addFamily(FAMILIES[0]);
        this.verifyScan(s, expectedRows, expectedKeys / 2L);
    }

    public void testPrefixFilter() throws Exception {
        long expectedRows = this.numRows / 2L;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan();
        s.setFilter(new PrefixFilter(Bytes.toBytes("testRowOne")));
        this.verifyScan(s, expectedRows, expectedKeys);
    }

    public void testPageFilter() throws Exception {
        KeyValue[] expectedKVs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        long expectedRows = 6L;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan();
        s.setFilter(new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter(new PageFilter(expectedRows));
        this.verifyScanFull(s, expectedKVs);
        expectedRows = 4L;
        expectedKeys = this.colsPerRow;
        s = new Scan();
        s.setFilter(new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter(new PageFilter(expectedRows));
        this.verifyScanFull(s, Arrays.copyOf(expectedKVs, 24));
        expectedRows = 2L;
        expectedKeys = this.colsPerRow;
        s = new Scan();
        s.setFilter(new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter(new PageFilter(expectedRows));
        this.verifyScanFull(s, Arrays.copyOf(expectedKVs, 12));
        expectedRows = 1L;
        expectedKeys = this.colsPerRow;
        s = new Scan();
        s.setFilter(new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter(new PageFilter(expectedRows));
        this.verifyScanFull(s, Arrays.copyOf(expectedKVs, 6));
    }

    public void testInclusiveStopFilter() throws IOException {
        long expectedRows = this.numRows / 2L - 1L;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan(Bytes.toBytes("testRowOne-0"), Bytes.toBytes("testRowOne-3"));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        s = new Scan(Bytes.toBytes("testRowOne-0"));
        s.setFilter(new InclusiveStopFilter(Bytes.toBytes("testRowOne-3")));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L - 1L;
        expectedKeys = this.colsPerRow;
        s = new Scan(Bytes.toBytes("testRowTwo-0"), Bytes.toBytes("testRowTwo-3"));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        s = new Scan(Bytes.toBytes("testRowTwo-0"));
        s.setFilter(new InclusiveStopFilter(Bytes.toBytes("testRowTwo-3")));
        this.verifyScan(s, expectedRows, expectedKeys);
    }

    public void testQualifierFilter() throws IOException {
        long expectedRows = this.numRows / 2L;
        long expectedKeys = 2L;
        QualifierFilter f = new QualifierFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("testQualifierOne-2")));
        Scan s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 2L;
        f = new QualifierFilter(CompareFilter.CompareOp.LESS, new BinaryComparator(Bytes.toBytes("testQualifierOne-2")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 4L;
        f = new QualifierFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, new BinaryComparator(Bytes.toBytes("testQualifierOne-2")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 4L;
        f = new QualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, new BinaryComparator(Bytes.toBytes("testQualifierOne-2")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes("testRowTwo"));
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 4L;
        f = new QualifierFilter(CompareFilter.CompareOp.GREATER_OR_EQUAL, new BinaryComparator(Bytes.toBytes("testQualifierOne-2")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes("testRowTwo"));
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 2L;
        f = new QualifierFilter(CompareFilter.CompareOp.GREATER, new BinaryComparator(Bytes.toBytes("testQualifierOne-2")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes("testRowTwo"));
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new QualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, new BinaryComparator(QUALIFIERS_ONE[2]));
        s = new Scan();
        s.setFilter(f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
        f = new QualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, new RegexStringComparator("test.+-2"));
        s = new Scan();
        s.setFilter(f);
        kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    public void testRowFilter() throws IOException {
        long expectedRows = 1L;
        long expectedKeys = this.colsPerRow;
        RowFilter f = new RowFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("testRowOne-2")));
        Scan s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 2L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator("testRow.+-2"));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 1L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.LESS, new BinaryComparator(Bytes.toBytes("testRowOne-2")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 2L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, new BinaryComparator(Bytes.toBytes("testRowOne-2")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows - 1L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.NOT_EQUAL, new BinaryComparator(Bytes.toBytes("testRowOne-2")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows - 1L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.GREATER_OR_EQUAL, new BinaryComparator(Bytes.toBytes("testRowOne-2")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows - 2L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.GREATER, new BinaryComparator(Bytes.toBytes("testRowOne-2")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new RowFilter(CompareFilter.CompareOp.NOT_EQUAL, new BinaryComparator(Bytes.toBytes("testRowOne-2")));
        s = new Scan();
        s.setFilter(f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
        f = new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(".+-2"));
        s = new Scan();
        s.setFilter(f);
        kvs = new KeyValue[]{new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    public void testValueFilter() throws IOException {
        long expectedRows = this.numRows / 2L;
        long expectedKeys = this.colsPerRow;
        ValueFilter f = new ValueFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("testValueOne")));
        Scan s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("testValueTwo")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator("testValue((One)|(Two))"));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.LESS, new BinaryComparator(Bytes.toBytes("testValueTwo")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, new BinaryComparator(Bytes.toBytes("testValueTwo")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, new BinaryComparator(Bytes.toBytes("testValueOne")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.NOT_EQUAL, new BinaryComparator(Bytes.toBytes("testValueOne")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.GREATER_OR_EQUAL, new BinaryComparator(Bytes.toBytes("testValueOne")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.GREATER, new BinaryComparator(Bytes.toBytes("testValueOne")));
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new ValueFilter(CompareFilter.CompareOp.NOT_EQUAL, new BinaryComparator(Bytes.toBytes("testValueOne")));
        s = new Scan();
        s.setFilter(f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    public void testSkipFilter() throws IOException {
        SkipFilter f = new SkipFilter(new QualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, new BinaryComparator(Bytes.toBytes("testQualifierOne-2"))));
        Scan s = new Scan();
        s.setFilter(f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    public void testFilterList() throws IOException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(".+-2")));
        filters.add(new QualifierFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(".+-2")));
        filters.add(new ValueFilter(CompareFilter.CompareOp.EQUAL, new SubstringComparator("One")));
        FilterList f = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        Scan s = new Scan();
        s.addFamily(FAMILIES[0]);
        s.setFilter(f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0])};
        this.verifyScanFull(s, kvs);
        filters.clear();
        filters.add(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(".+Two.+")));
        filters.add(new QualifierFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(".+-2")));
        filters.add(new ValueFilter(CompareFilter.CompareOp.EQUAL, new SubstringComparator("One")));
        f = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        s = new Scan();
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, this.numRows, this.colsPerRow);
    }

    public void testFirstKeyOnlyFilter() throws IOException {
        Scan s = new Scan();
        s.setFilter(new FirstKeyOnlyFilter());
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    public void testSingleColumnValueFilter() throws IOException {
        KeyValue[] srcKVs;
        Put p = new Put(ROWS_ONE[2]);
        p.add(FAMILIES[0], QUALIFIERS_ONE[2], VALUES[1]);
        this.region.put(p);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareFilter.CompareOp.EQUAL, VALUES[0]));
        filters.add(new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[2], CompareFilter.CompareOp.EQUAL, VALUES[1]));
        FilterList f = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        Scan s = new Scan(ROWS_ONE[0], ROWS_TWO[0]);
        s.addFamily(FAMILIES[0]);
        s.setFilter(f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[1]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0])};
        this.verifyScanNoEarlyOut(s, 1L, 3L);
        this.verifyScanFull(s, kvs);
        filters = new ArrayList();
        filters.add(new SkipFilter(new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareFilter.CompareOp.EQUAL, VALUES[0])));
        filters.add(new SkipFilter(new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[2], CompareFilter.CompareOp.EQUAL, VALUES[1])));
        f = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        s = new Scan(ROWS_ONE[0], ROWS_TWO[0]);
        s.addFamily(FAMILIES[0]);
        s.setFilter(f);
        this.verifyScanNoEarlyOut(s, 1L, 3L);
        this.verifyScanFull(s, kvs);
        byte[][] ROWS_THREE = new byte[][]{Bytes.toBytes("rowThree-0"), Bytes.toBytes("rowThree-1"), Bytes.toBytes("rowThree-2"), Bytes.toBytes("rowThree-3")};
        for (KeyValue kv : srcKVs = new KeyValue[]{new KeyValue(ROWS_THREE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_THREE[1], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[1]), new KeyValue(ROWS_THREE[2], FAMILIES[0], QUALIFIERS_ONE[1], VALUES[0]), new KeyValue(ROWS_THREE[3], FAMILIES[0], QUALIFIERS_ONE[1], VALUES[1])}) {
            this.region.put(new Put(kv.getRow()).add(kv));
        }
        SingleColumnValueFilter scvf = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareFilter.CompareOp.EQUAL, VALUES[0]);
        s = new Scan(ROWS_THREE[0], Bytes.toBytes("rowThree-4"));
        s.addFamily(FAMILIES[0]);
        s.setFilter(scvf);
        kvs = new KeyValue[]{srcKVs[0], srcKVs[2], srcKVs[3]};
        this.verifyScanFull(s, kvs);
        scvf = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareFilter.CompareOp.EQUAL, VALUES[0]);
        scvf.setFilterIfMissing(true);
        s = new Scan(ROWS_THREE[0], Bytes.toBytes("rowThree-4"));
        s.addFamily(FAMILIES[0]);
        s.setFilter(scvf);
        kvs = new KeyValue[]{srcKVs[0]};
        this.verifyScanFull(s, kvs);
        scvf = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[1], CompareFilter.CompareOp.EQUAL, VALUES[1]);
        scvf.setFilterIfMissing(true);
        s = new Scan(ROWS_THREE[0], Bytes.toBytes("rowThree-4"));
        s.addFamily(FAMILIES[0]);
        s.setFilter(scvf);
        kvs = new KeyValue[]{srcKVs[3]};
        this.verifyScanFull(s, kvs);
        KeyValue kvA = new KeyValue(ROWS_THREE[0], FAMILIES[0], QUALIFIERS_ONE[1], VALUES[0]);
        this.region.put(new Put(kvA.getRow()).add(kvA));
        scvf = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[1], CompareFilter.CompareOp.EQUAL, VALUES[1]);
        scvf.setFilterIfMissing(true);
        s = new Scan(ROWS_THREE[0], Bytes.toBytes("rowThree-4"));
        s.addFamily(FAMILIES[0]);
        s.setFilter(scvf);
        kvs = new KeyValue[]{srcKVs[3]};
        this.verifyScanFull(s, kvs);
    }

    private void verifyScan(Scan s, long expectedRows, long expectedKeys) throws IOException {
        InternalScanner scanner = this.region.getScanner(s);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        int i = 0;
        boolean done = true;
        while (done) {
            done = scanner.next(results);
            Arrays.sort(results.toArray(new KeyValue[results.size()]), KeyValue.COMPARATOR);
            this.LOG.info((Object)("counter=" + i + ", " + results));
            if (results.isEmpty()) break;
            TestFilter.assertTrue((String)("Scanned too many rows! Only expected " + expectedRows + " total but already scanned " + (i + 1)), (expectedRows > (long)i ? 1 : 0) != 0);
            TestFilter.assertEquals((String)("Expected " + expectedKeys + " keys per row but " + "returned " + results.size()), (long)expectedKeys, (long)results.size());
            results.clear();
            ++i;
        }
        TestFilter.assertEquals((String)("Expected " + expectedRows + " rows but scanned " + i + " rows"), (long)expectedRows, (long)i);
    }

    private void verifyScanNoEarlyOut(Scan s, long expectedRows, long expectedKeys) throws IOException {
        InternalScanner scanner = this.region.getScanner(s);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        int i = 0;
        boolean done = true;
        while (done) {
            done = scanner.next(results);
            Arrays.sort(results.toArray(new KeyValue[results.size()]), KeyValue.COMPARATOR);
            this.LOG.info((Object)("counter=" + i + ", " + results));
            if (results.isEmpty()) break;
            TestFilter.assertTrue((String)("Scanned too many rows! Only expected " + expectedRows + " total but already scanned " + (i + 1)), (expectedRows > (long)i ? 1 : 0) != 0);
            TestFilter.assertEquals((String)("Expected " + expectedKeys + " keys per row but " + "returned " + results.size()), (long)expectedKeys, (long)results.size());
            results.clear();
            ++i;
        }
        TestFilter.assertEquals((String)("Expected " + expectedRows + " rows but scanned " + i + " rows"), (long)expectedRows, (long)i);
    }

    private void verifyScanFull(Scan s, KeyValue[] kvs) throws IOException {
        InternalScanner scanner = this.region.getScanner(s);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        int row = 0;
        int idx = 0;
        boolean done = true;
        while (done) {
            done = scanner.next(results);
            Arrays.sort(results.toArray(new KeyValue[results.size()]), KeyValue.COMPARATOR);
            if (results.isEmpty()) break;
            TestFilter.assertTrue((String)("Scanned too many keys! Only expected " + kvs.length + " total but already scanned " + (results.size() + idx) + (results.isEmpty() ? "" : "(" + ((KeyValue)results.get(0)).toString() + ")")), (kvs.length >= idx + results.size() ? 1 : 0) != 0);
            for (KeyValue kv : results) {
                this.LOG.info((Object)("row=" + row + ", result=" + kv.toString() + ", match=" + kvs[idx].toString()));
                TestFilter.assertTrue((String)"Row mismatch", (boolean)Bytes.equals(kv.getRow(), kvs[idx].getRow()));
                TestFilter.assertTrue((String)"Family mismatch", (boolean)Bytes.equals(kv.getFamily(), kvs[idx].getFamily()));
                TestFilter.assertTrue((String)"Qualifier mismatch", (boolean)Bytes.equals(kv.getQualifier(), kvs[idx].getQualifier()));
                TestFilter.assertTrue((String)"Value mismatch", (boolean)Bytes.equals(kv.getValue(), kvs[idx].getValue()));
                ++idx;
            }
            results.clear();
            ++row;
        }
        this.LOG.info((Object)("Looked at " + row + " rows with " + idx + " keys"));
        TestFilter.assertEquals((String)("Expected " + kvs.length + " total keys but scanned " + idx), (int)kvs.length, (int)idx);
    }
}

