/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

public class TestHeapSize
extends TestCase {
    static final Log LOG = LogFactory.getLog(TestHeapSize.class);

    public void testNativeSizes() throws IOException {
        Class cl = null;
        long expected = 0L;
        long actual = 0L;
        cl = ArrayList.class;
        expected = ClassSize.estimateBase(cl, false);
        if (expected != (actual = (long)ClassSize.ARRAYLIST)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ByteBuffer.class, false)) != (actual = (long)ClassSize.BYTE_BUFFER)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = Integer.class, false)) != (actual = (long)ClassSize.INTEGER)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = Object.class, false)) != (actual = (long)ClassSize.OBJECT)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = TreeMap.class, false)) != (actual = (long)ClassSize.TREEMAP)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = String.class, false)) != (actual = (long)ClassSize.STRING)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ConcurrentHashMap.class, false)) != (actual = (long)ClassSize.CONCURRENT_HASHMAP)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ConcurrentSkipListMap.class, false)) != (actual = (long)ClassSize.CONCURRENT_SKIPLISTMAP)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ReentrantReadWriteLock.class, false)) != (actual = (long)ClassSize.REENTRANT_LOCK)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = AtomicLong.class, false)) != (actual = (long)ClassSize.ATOMIC_LONG)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = AtomicInteger.class, false)) != (actual = (long)ClassSize.ATOMIC_INTEGER)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = AtomicBoolean.class, false)) != (actual = (long)ClassSize.ATOMIC_BOOLEAN)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = CopyOnWriteArraySet.class, false)) != (actual = (long)ClassSize.COPYONWRITE_ARRAYSET)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = CopyOnWriteArrayList.class, false)) != (actual = (long)ClassSize.COPYONWRITE_ARRAYLIST)) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
    }

    public void testSizes() throws IOException {
        KeyValue kv;
        Class cl = null;
        long expected = 0L;
        long actual = 0L;
        cl = KeyValue.class;
        expected = ClassSize.estimateBase(cl, false);
        if (expected != (actual = (kv = new KeyValue()).heapSize())) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        cl = Put.class;
        expected = ClassSize.estimateBase(cl, false);
        Put put = new Put(Bytes.toBytes(""));
        actual = put.heapSize();
        if ((expected += (long)ClassSize.TREEMAP) != actual) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        cl = LruBlockCache.class;
        actual = LruBlockCache.CACHE_FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        cl = CachedBlock.class;
        actual = CachedBlock.PER_BLOCK_OVERHEAD;
        expected = ClassSize.estimateBase(cl, false);
        expected += ClassSize.estimateBase(String.class, false);
        if ((expected += ClassSize.estimateBase(ByteBuffer.class, false)) != actual) {
            ClassSize.estimateBase(cl, true);
            ClassSize.estimateBase(String.class, true);
            ClassSize.estimateBase(ByteBuffer.class, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        cl = MemStore.class;
        actual = MemStore.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        actual = MemStore.DEEP_OVERHEAD;
        expected = ClassSize.estimateBase(cl, false);
        expected += ClassSize.estimateBase(ReentrantReadWriteLock.class, false);
        expected += ClassSize.estimateBase(AtomicLong.class, false);
        expected += ClassSize.estimateBase(ConcurrentSkipListMap.class, false);
        expected += ClassSize.estimateBase(ConcurrentSkipListMap.class, false);
        expected += ClassSize.estimateBase(CopyOnWriteArraySet.class, false);
        if ((expected += ClassSize.estimateBase(CopyOnWriteArrayList.class, false)) != actual) {
            ClassSize.estimateBase(cl, true);
            ClassSize.estimateBase(ReentrantReadWriteLock.class, true);
            ClassSize.estimateBase(AtomicLong.class, true);
            ClassSize.estimateBase(ConcurrentSkipListMap.class, true);
            ClassSize.estimateBase(CopyOnWriteArraySet.class, true);
            ClassSize.estimateBase(CopyOnWriteArrayList.class, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        cl = Store.class;
        actual = Store.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
        cl = HRegion.class;
        actual = HRegion.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, true);
            TestHeapSize.assertEquals((long)expected, (long)actual);
        }
    }
}

