/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.mortbay.log.Log;

public class HFileOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, KeyValue> {
    public RecordWriter<ImmutableBytesWritable, KeyValue> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        final Path outputdir = FileOutputFormat.getOutputPath((JobContext)context);
        Configuration conf = context.getConfiguration();
        final FileSystem fs = outputdir.getFileSystem(conf);
        final long maxsize = conf.getLong("hbase.hregion.max.filesize", 0x10000000L);
        final int blocksize = conf.getInt("hfile.min.blocksize.size", 65536);
        final String compression = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        return new RecordWriter<ImmutableBytesWritable, KeyValue>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private byte[] previousRow = HConstants.EMPTY_BYTE_ARRAY;

            public void write(ImmutableBytesWritable row, KeyValue kv) throws IOException {
                long length = kv.getLength();
                byte[] family = kv.getFamily();
                WriterLength wl = this.writers.get(family);
                if (wl == null || length + wl.written >= maxsize && Bytes.compareTo(this.previousRow, 0, this.previousRow.length, kv.getBuffer(), kv.getRowOffset(), kv.getRowLength()) != 0) {
                    Path basedir = new Path(outputdir, Bytes.toString(family));
                    if (wl == null) {
                        wl = new WriterLength();
                        this.writers.put(family, wl);
                        if (this.writers.size() > 1) {
                            throw new IOException("One family only");
                        }
                        if (!fs.exists(basedir)) {
                            fs.mkdirs(basedir);
                        }
                    }
                    wl.writer = this.getNewWriter(wl.writer, basedir);
                    Log.info((String)("Writer=" + wl.writer.getPath() + (wl.written == 0L ? "" : ", wrote=" + wl.written)));
                    wl.written = 0L;
                }
                wl.writer.append(kv);
                wl.written += length;
                this.previousRow = kv.getRow();
            }

            private HFile.Writer getNewWriter(HFile.Writer writer, Path familydir) throws IOException {
                this.close(writer);
                return new HFile.Writer(fs, StoreFile.getUniqueFile(fs, familydir), blocksize, compression, (RawComparator<byte[]>)KeyValue.KEY_COMPARATOR);
            }

            private void close(HFile.Writer w) throws IOException {
                if (w != null) {
                    StoreFile.appendMetadata(w, System.currentTimeMillis(), true);
                    w.close();
                }
            }

            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (Map.Entry<byte[], WriterLength> e : this.writers.entrySet()) {
                    this.close(e.getValue().writer);
                }
            }
        };
    }

    static class WriterLength {
        long written = 0L;
        HFile.Writer writer = null;

        WriterLength() {
        }
    }
}

