/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;

public class TestMinimumServerCount
extends HBaseClusterTestCase {
    static final String TABLE_NAME = "TestTable";

    public TestMinimumServerCount() {
        super(1, true);
    }

    boolean isTableAvailable(String tableName) throws IOException {
        Result result;
        boolean available = true;
        HTable meta = new HTable(this.conf, ".META.");
        ResultScanner scanner = meta.getScanner(HConstants.CATALOG_FAMILY);
        while ((result = scanner.next()) != null) {
            byte[] value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
            if (value != null) continue;
            available = false;
            break;
        }
        return available;
    }

    public void testMinimumServerCount() throws Exception {
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(this.createTableDescriptor(TABLE_NAME));
        admin.disableTable(TABLE_NAME);
        TestMinimumServerCount.assertFalse((boolean)admin.isTableEnabled(TABLE_NAME));
        this.cluster.hbaseCluster.getMaster().getServerManager().setMinimumServerCount(2);
        try {
            admin.enableTable(TABLE_NAME);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Thread.sleep(10000L);
        TestMinimumServerCount.assertFalse((boolean)admin.isTableAvailable(TABLE_NAME));
        this.cluster.startRegionServer();
        Thread.sleep(10000L);
        TestMinimumServerCount.assertTrue((boolean)admin.isTableAvailable(TABLE_NAME));
    }
}

