/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration.nineteen;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Migrate;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class HStoreFileToStoreFile
extends Configured
implements Tool {
    static final Log LOG = LogFactory.getLog(HStoreFileToStoreFile.class);
    public static final String JOBNAME = "hsf2sf";

    HStoreFileToStoreFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInputFiles(HBaseConfiguration conf, FileSystem fs, Path dir) throws IOException {
        if (fs.exists(dir)) {
            LOG.warn((Object)"Input directory already exits. Using content for this MR job.");
            return;
        }
        FSDataOutputStream out = fs.create(new Path(dir, "mapfiles"));
        try {
            HStoreFileToStoreFile.gathermapfiles(conf, fs, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void gathermapfiles(HBaseConfiguration conf, FileSystem fs, FSDataOutputStream out) throws IOException {
        FileStatus[] tableDirs = fs.listStatus(FSUtils.getRootDir(conf), (PathFilter)new FSUtils.DirFilter(fs));
        for (int i = 0; i < tableDirs.length; ++i) {
            Path d = tableDirs[i].getPath();
            if (d.getName().equals(".logs")) continue;
            FileStatus[] regionDirs = fs.listStatus(d, (PathFilter)new FSUtils.DirFilter(fs));
            for (int j = 0; j < regionDirs.length; ++j) {
                Path dd = regionDirs[j].getPath();
                if (dd.getName().equals("compaction.dir")) continue;
                FileStatus[] familyDirs = fs.listStatus(dd, (PathFilter)new FSUtils.DirFilter(fs));
                for (int k = 0; k < familyDirs.length; ++k) {
                    Path family = familyDirs[k].getPath();
                    FileStatus[] infoAndMapfile = fs.listStatus(family);
                    if (infoAndMapfile.length != 2) {
                        LOG.warn((Object)(family.toString() + " has more than just info and mapfile: " + infoAndMapfile.length + ". Continuing..."));
                        continue;
                    }
                    for (int ll = 0; ll < 2; ++ll) {
                        if (infoAndMapfile[ll].getPath().getName().equals("info") || infoAndMapfile[ll].getPath().getName().equals("mapfiles")) continue;
                        LOG.warn((Object)("Unexpected directory name: " + infoAndMapfile[ll].getPath() + ". Continuing..."));
                    }
                    Path mfsdir = new Path(family, "mapfiles");
                    FileStatus[] familyStatus = fs.listStatus(mfsdir);
                    if (familyStatus == null || familyStatus.length > 1) {
                        LOG.warn((Object)(family.toString() + " has " + (familyStatus == null ? "null" : Integer.valueOf(familyStatus.length)) + " files.  Continuing..."));
                        continue;
                    }
                    if (familyStatus.length == 1) {
                        String str = familyStatus[0].getPath().makeQualified(fs).toString();
                        LOG.info((Object)str);
                        out.write(Bytes.toBytes(str + "\n"));
                        continue;
                    }
                    Path infodir = new Path(family, "info");
                    LOG.info((Object)("Removing " + mfsdir + " and " + infodir + " because empty"));
                    fs.delete(mfsdir, true);
                    fs.delete(infodir, true);
                }
            }
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("ERROR: Wrong number of arguments: " + args.length);
            System.err.println("Usage: " + ((Object)((Object)this)).getClass().getSimpleName() + " <inputdir> <outputdir>");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return -1;
        }
        Path input = new Path(args[0]);
        HBaseConfiguration conf = (HBaseConfiguration)this.getConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        HStoreFileToStoreFile.writeInputFiles(conf, fs, input);
        Job job = new Job((Configuration)conf);
        job.setJarByClass(HStoreFileToStoreFile.class);
        job.setJobName(JOBNAME);
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(Map.class);
        job.setNumReduceTasks(0);
        FileInputFormat.addInputPath((Job)job, (Path)input);
        Path output = new Path(args[1]);
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Configuration)new HBaseConfiguration(), (Tool)new HStoreFileToStoreFile(), (String[])args);
        System.exit(exitCode);
    }

    public static class Map
    extends Mapper<LongWritable, Text, LongWritable, LongWritable> {
        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            HBaseConfiguration c = new HBaseConfiguration(context.getConfiguration());
            Path p = new Path(value.toString());
            context.setStatus(key.toString() + " " + p.toString());
            Migrate.rewrite(c, FileSystem.get((Configuration)c), p);
        }
    }
}

