/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;

public class KeyValueScanFixture
implements KeyValueScanner {
    ArrayList<KeyValue> data;
    Iterator<KeyValue> iter = null;
    KeyValue current = null;
    KeyValue.KVComparator comparator;

    public KeyValueScanFixture(KeyValue.KVComparator comparator, KeyValue ... incData) {
        this.comparator = comparator;
        this.data = new ArrayList(incData.length);
        for (int i = 0; i < incData.length; ++i) {
            this.data.add(incData[i]);
        }
        Collections.sort(this.data, this.comparator);
    }

    @Override
    public KeyValue peek() {
        return this.current;
    }

    @Override
    public KeyValue next() {
        KeyValue res = this.current;
        this.current = this.iter.hasNext() ? this.iter.next() : null;
        return res;
    }

    @Override
    public boolean seek(KeyValue key) {
        int cmp;
        this.iter = this.data.iterator();
        KeyValue kv = null;
        do {
            if (this.iter.hasNext()) continue;
            this.current = null;
            return false;
        } while ((cmp = this.comparator.compare(key, kv = this.iter.next())) > 0);
        this.current = kv;
        return true;
    }

    @Override
    public void close() {
    }
}

