/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.regionserver.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.LogRollListener;
import org.apache.hadoop.hbase.util.Bytes;

class LogRoller
extends Thread
implements LogRollListener {
    static final Log LOG = LogFactory.getLog(LogRoller.class);
    private final ReentrantLock rollLock = new ReentrantLock();
    private final AtomicBoolean rollLog = new AtomicBoolean(false);
    private final HRegionServer server;
    private volatile long lastrolltime = System.currentTimeMillis();
    private final long rollperiod;

    public LogRoller(HRegionServer server) {
        this.server = server;
        this.rollperiod = this.server.conf.getLong("hbase.regionserver.logroll.period", 3600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.server.isStopRequested()) {
            long now = System.currentTimeMillis();
            boolean periodic = false;
            if (!this.rollLog.get()) {
                boolean bl = periodic = now - this.lastrolltime > this.rollperiod;
                if (!periodic) {
                    AtomicBoolean atomicBoolean = this.rollLog;
                    synchronized (atomicBoolean) {
                        try {
                            this.rollLog.wait(this.server.threadWakeFrequency);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Hlog roll period " + this.rollperiod + "ms elapsed"));
                }
            }
            this.rollLock.lock();
            try {
                this.lastrolltime = now;
                byte[][] regionsToFlush = this.server.getLog().rollWriter();
                if (regionsToFlush == null) continue;
                for (byte[] r : regionsToFlush) {
                    this.scheduleFlush(r);
                }
            }
            catch (FailedLogCloseException e) {
                LOG.fatal((Object)"Forcing server shutdown", (Throwable)e);
                this.server.checkFileSystem();
                this.server.abort();
            }
            catch (ConnectException e) {
                LOG.fatal((Object)"Forcing server shutdown", (Throwable)e);
                this.server.checkFileSystem();
                this.server.abort();
            }
            catch (IOException ex) {
                LOG.fatal((Object)"Log rolling failed with ioe: ", (Throwable)RemoteExceptionHandler.checkIOException(ex));
                this.server.checkFileSystem();
                this.server.abort();
            }
            catch (Exception ex) {
                LOG.error((Object)"Log rolling failed", (Throwable)ex);
                this.server.checkFileSystem();
            }
            finally {
                this.rollLog.set(false);
                this.rollLock.unlock();
            }
        }
        LOG.info((Object)"LogRoller exiting.");
    }

    private void scheduleFlush(byte[] region) {
        boolean scheduled = false;
        HRegion r = this.server.getOnlineRegion(region);
        FlushRequester requester = null;
        if (r != null && (requester = this.server.getFlushRequester()) != null) {
            requester.request(r);
            scheduled = true;
        }
        if (!scheduled) {
            LOG.warn((Object)("Failed to schedule flush of " + Bytes.toString(region) + "r=" + r + ", requester=" + requester));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logRollRequested() {
        AtomicBoolean atomicBoolean = this.rollLog;
        synchronized (atomicBoolean) {
            this.rollLog.set(true);
            this.rollLog.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptIfNecessary() {
        try {
            this.rollLock.lock();
            this.interrupt();
        }
        finally {
            this.rollLock.unlock();
        }
    }
}

