/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;

class StoreFileScanner
implements KeyValueScanner {
    private HFileScanner hfs;
    private KeyValue cur = null;

    public StoreFileScanner(HFileScanner hfs) {
        this.hfs = hfs;
    }

    public String toString() {
        return "StoreFileScanner[" + this.hfs.toString() + ", cur=" + this.cur + "]";
    }

    @Override
    public KeyValue peek() {
        return this.cur;
    }

    @Override
    public KeyValue next() {
        KeyValue retKey = this.cur;
        this.cur = this.hfs.getKeyValue();
        try {
            if (this.cur != null) {
                this.hfs.next();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return retKey;
    }

    @Override
    public boolean seek(KeyValue key) {
        try {
            if (!StoreFileScanner.seekAtOrAfter(this.hfs, key)) {
                this.close();
                return false;
            }
            this.cur = this.hfs.getKeyValue();
            this.hfs.next();
            return true;
        }
        catch (IOException ioe) {
            this.close();
            return false;
        }
    }

    @Override
    public void close() {
        this.cur = null;
    }

    public static boolean seekAtOrAfter(HFileScanner s, KeyValue k) throws IOException {
        int result = s.seekTo(k.getBuffer(), k.getKeyOffset(), k.getKeyLength());
        if (result < 0) {
            return s.seekTo();
        }
        if (result > 0) {
            return s.next();
        }
        return true;
    }
}

