/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.regionserver.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class TestExplicitColumnTracker
extends HBaseTestCase
implements HConstants {
    private boolean PRINT = false;

    public void testGet_SingleVersion() {
        if (this.PRINT) {
            System.out.println("SingleVersion");
        }
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        byte[] col4 = Bytes.toBytes("col4");
        byte[] col5 = Bytes.toBytes("col5");
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(col2);
        columns.add(col4);
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.DONE);
        int maxVersions = 1;
        ExplicitColumnTracker exp = new ExplicitColumnTracker(columns, maxVersions);
        ArrayList<byte[]> scanner = new ArrayList<byte[]>();
        scanner.add(col1);
        scanner.add(col2);
        scanner.add(col3);
        scanner.add(col4);
        scanner.add(col5);
        ArrayList<QueryMatcher.MatchCode> result = new ArrayList<QueryMatcher.MatchCode>();
        for (byte[] col : scanner) {
            result.add(exp.checkColumn(col, 0, col.length));
        }
        TestExplicitColumnTracker.assertEquals((int)expected.size(), (int)result.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestExplicitColumnTracker.assertEquals(expected.get(i), result.get(i));
            if (!this.PRINT) continue;
            System.out.println("Expected " + expected.get(i) + ", actual " + result.get(i));
        }
    }

    public void testGet_MultiVersion() {
        if (this.PRINT) {
            System.out.println("\nMultiVersion");
        }
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        byte[] col4 = Bytes.toBytes("col4");
        byte[] col5 = Bytes.toBytes("col5");
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(col2);
        columns.add(col4);
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.DONE);
        expected.add(QueryMatcher.MatchCode.DONE);
        expected.add(QueryMatcher.MatchCode.DONE);
        expected.add(QueryMatcher.MatchCode.DONE);
        int maxVersions = 2;
        ExplicitColumnTracker exp = new ExplicitColumnTracker(columns, maxVersions);
        ArrayList<byte[]> scanner = new ArrayList<byte[]>();
        scanner.add(col1);
        scanner.add(col1);
        scanner.add(col1);
        scanner.add(col2);
        scanner.add(col2);
        scanner.add(col2);
        scanner.add(col3);
        scanner.add(col3);
        scanner.add(col3);
        scanner.add(col4);
        scanner.add(col4);
        scanner.add(col4);
        scanner.add(col5);
        scanner.add(col5);
        scanner.add(col5);
        ArrayList<QueryMatcher.MatchCode> result = new ArrayList<QueryMatcher.MatchCode>();
        for (byte[] col : scanner) {
            result.add(exp.checkColumn(col, 0, col.length));
        }
        TestExplicitColumnTracker.assertEquals((int)expected.size(), (int)result.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestExplicitColumnTracker.assertEquals(expected.get(i), result.get(i));
            if (!this.PRINT) continue;
            System.out.println("Expected " + expected.get(i) + ", actual " + result.get(i));
        }
    }
}

