/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class TestKeyValueHeap
extends HBaseTestCase
implements HConstants {
    private final boolean PRINT = false;
    List<Scanner> scanners = new ArrayList<Scanner>();
    private byte[] row1;
    private byte[] fam1;
    private byte[] col1;
    private byte[] data;
    private byte[] row2;
    private byte[] fam2;
    private byte[] col2;
    private byte[] col3;
    private byte[] col4;
    private byte[] col5;

    @Override
    public void setUp() {
        this.data = Bytes.toBytes("data");
        this.row1 = Bytes.toBytes("row1");
        this.fam1 = Bytes.toBytes("fam1");
        this.col1 = Bytes.toBytes("col1");
        this.row2 = Bytes.toBytes("row2");
        this.fam2 = Bytes.toBytes("fam2");
        this.col2 = Bytes.toBytes("col2");
        this.col3 = Bytes.toBytes("col3");
        this.col4 = Bytes.toBytes("col4");
        this.col5 = Bytes.toBytes("col5");
    }

    public void testSorted() {
        int i;
        ArrayList<KeyValue> l1 = new ArrayList<KeyValue>();
        l1.add(new KeyValue(this.row1, this.fam1, this.col5, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l1));
        ArrayList<KeyValue> l2 = new ArrayList<KeyValue>();
        l2.add(new KeyValue(this.row1, this.fam1, this.col1, this.data));
        l2.add(new KeyValue(this.row1, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l2));
        ArrayList<KeyValue> l3 = new ArrayList<KeyValue>();
        l3.add(new KeyValue(this.row1, this.fam1, this.col3, this.data));
        l3.add(new KeyValue(this.row1, this.fam1, this.col4, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        l3.add(new KeyValue(this.row2, this.fam1, this.col3, this.data));
        this.scanners.add(new Scanner(l3));
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue(this.row1, this.fam1, this.col1, this.data));
        expected.add(new KeyValue(this.row1, this.fam1, this.col2, this.data));
        expected.add(new KeyValue(this.row1, this.fam1, this.col3, this.data));
        expected.add(new KeyValue(this.row1, this.fam1, this.col4, this.data));
        expected.add(new KeyValue(this.row1, this.fam1, this.col5, this.data));
        expected.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        expected.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        expected.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        expected.add(new KeyValue(this.row2, this.fam1, this.col2, this.data));
        expected.add(new KeyValue(this.row2, this.fam1, this.col3, this.data));
        KeyValueHeap kvh = new KeyValueHeap(this.scanners.toArray(new Scanner[0]), KeyValue.COMPARATOR);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        while (kvh.peek() != null) {
            actual.add(kvh.next());
        }
        TestKeyValueHeap.assertEquals((int)expected.size(), (int)actual.size());
        for (i = 0; i < expected.size(); ++i) {
            TestKeyValueHeap.assertEquals(expected.get(i), actual.get(i));
        }
        for (i = 0; i < actual.size() - 1; ++i) {
            int ret = KeyValue.COMPARATOR.compare((KeyValue)actual.get(i), (KeyValue)actual.get(i + 1));
            TestKeyValueHeap.assertTrue((ret < 0 ? 1 : 0) != 0);
        }
    }

    public void testSeek() {
        ArrayList<KeyValue> l1 = new ArrayList<KeyValue>();
        l1.add(new KeyValue(this.row1, this.fam1, this.col5, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l1));
        ArrayList<KeyValue> l2 = new ArrayList<KeyValue>();
        l2.add(new KeyValue(this.row1, this.fam1, this.col1, this.data));
        l2.add(new KeyValue(this.row1, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l2));
        ArrayList<KeyValue> l3 = new ArrayList<KeyValue>();
        l3.add(new KeyValue(this.row1, this.fam1, this.col3, this.data));
        l3.add(new KeyValue(this.row1, this.fam1, this.col4, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        l3.add(new KeyValue(this.row2, this.fam1, this.col3, this.data));
        this.scanners.add(new Scanner(l3));
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        KeyValueHeap kvh = new KeyValueHeap(this.scanners.toArray(new Scanner[0]), KeyValue.COMPARATOR);
        KeyValue seekKv = new KeyValue(this.row2, this.fam1, null, null);
        kvh.seek(seekKv);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        actual.add(kvh.peek());
        TestKeyValueHeap.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestKeyValueHeap.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScannerLeak() {
        ArrayList<KeyValue> l1 = new ArrayList<KeyValue>();
        l1.add(new KeyValue(this.row1, this.fam1, this.col5, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l1));
        ArrayList<KeyValue> l2 = new ArrayList<KeyValue>();
        l2.add(new KeyValue(this.row1, this.fam1, this.col1, this.data));
        l2.add(new KeyValue(this.row1, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l2));
        ArrayList<KeyValue> l3 = new ArrayList<KeyValue>();
        l3.add(new KeyValue(this.row1, this.fam1, this.col3, this.data));
        l3.add(new KeyValue(this.row1, this.fam1, this.col4, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        l3.add(new KeyValue(this.row2, this.fam1, this.col3, this.data));
        this.scanners.add(new Scanner(l3));
        ArrayList<KeyValue> l4 = new ArrayList<KeyValue>();
        this.scanners.add(new Scanner(l4));
        KeyValueHeap kvh = new KeyValueHeap(this.scanners.toArray(new Scanner[0]), KeyValue.COMPARATOR);
        while (kvh.next() != null) {
        }
        for (Scanner scanner : this.scanners) {
            TestKeyValueHeap.assertTrue((boolean)scanner.isClosed());
        }
    }

    private class Scanner
    implements KeyValueScanner {
        private Set<KeyValue> scan = new TreeSet<KeyValue>(KeyValue.COMPARATOR);
        private Iterator<KeyValue> iter;
        private KeyValue current;
        private boolean closed = false;

        public Scanner(List<KeyValue> list) {
            Collections.sort(list, KeyValue.COMPARATOR);
            this.iter = list.iterator();
            if (this.iter.hasNext()) {
                this.current = this.iter.next();
            }
        }

        @Override
        public KeyValue peek() {
            return this.current;
        }

        @Override
        public KeyValue next() {
            KeyValue oldCurrent = this.current;
            this.current = this.iter.hasNext() ? this.iter.next() : null;
            return oldCurrent;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean seek(KeyValue seekKv) {
            while (this.iter.hasNext()) {
                KeyValue next = this.iter.next();
                int ret = KeyValue.COMPARATOR.compare(next, seekKv);
                if (ret < 0) continue;
                this.current = next;
                return true;
            }
            return false;
        }
    }
}

