/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HLog;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;

public class TestLogRolling
extends HBaseClusterTestCase {
    private static final Log LOG = LogFactory.getLog(TestLogRolling.class);
    private HRegionServer server;
    private HLog log;
    private String tableName;
    private byte[] value;

    public TestLogRolling() throws Exception {
        try {
            this.server = null;
            this.log = null;
            this.tableName = null;
            this.value = null;
            String className = ((Object)((Object)this)).getClass().getName();
            StringBuilder v = new StringBuilder(className);
            while (v.length() < 1000) {
                v.append(className);
            }
            this.value = Bytes.toBytes(v.toString());
        }
        catch (Exception e) {
            LOG.fatal((Object)"error in constructor", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void preHBaseClusterSetup() {
        this.conf.setLong("hbase.hregion.max.filesize", 786432L);
        this.conf.setInt("hbase.regionserver.maxlogentries", 32);
        this.conf.setInt("hbase.hregion.memstore.optionalflushcount", 2);
        this.conf.setInt("hbase.hregion.memstore.flush.size", 8192);
        this.conf.setInt("hbase.master.lease.period", 10000);
        this.conf.setLong("hbase.client.pause", 15000L);
        this.conf.setInt("hbase.server.thread.wakefrequency", 2000);
    }

    private void startAndWriteData() throws Exception {
        new HTable(this.conf, HConstants.META_TABLE_NAME);
        this.server = this.cluster.getRegionThreads().get(0).getRegionServer();
        this.log = this.server.getLog();
        HTableDescriptor desc = new HTableDescriptor(this.tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(desc);
        HTable table = new HTable(this.conf, this.tableName);
        for (int i = 1; i <= 256; ++i) {
            Put put = new Put(Bytes.toBytes("row" + String.format("%1$04d", i)));
            put.add(HConstants.CATALOG_FAMILY, null, this.value);
            table.put(put);
            if (i % 32 != 0) continue;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void testLogRolling() throws Exception {
        this.tableName = this.getName();
        try {
            this.startAndWriteData();
            LOG.info((Object)("after writing there are " + this.log.getNumLogFiles() + " log files"));
            ArrayList<HRegion> regions = new ArrayList<HRegion>(this.server.getOnlineRegions());
            for (HRegion r : regions) {
                r.flushcache();
            }
            this.log.rollWriter();
            int count = this.log.getNumLogFiles();
            LOG.info((Object)("after flushing all regions and rolling logs there are " + this.log.getNumLogFiles() + " log files"));
            TestLogRolling.assertTrue((String)("actual count: " + count), (count <= 2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.fatal((Object)"unexpected exception", (Throwable)e);
            throw e;
        }
    }
}

