/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class TestMemStore
extends TestCase {
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private MemStore memstore;
    private static final int ROW_COUNT = 10;
    private static final int QUALIFIER_COUNT = 10;
    private static final byte[] FAMILY = Bytes.toBytes("column");
    private static final byte[] CONTENTS_BASIC = Bytes.toBytes("contents:basic");
    private static final String CONTENTSTR = "contentstr";

    public void setUp() throws Exception {
        super.setUp();
        this.memstore = new MemStore();
    }

    public void testPutSameKey() {
        byte[] bytes = Bytes.toBytes(this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        this.memstore.add(kv);
        byte[] other = Bytes.toBytes("somethingelse");
        KeyValue samekey = new KeyValue(bytes, bytes, bytes, other);
        this.memstore.add(samekey);
        KeyValue found = this.memstore.kvset.first();
        TestMemStore.assertEquals((int)1, (int)this.memstore.kvset.size());
        TestMemStore.assertTrue((String)Bytes.toString(found.getValue()), (boolean)Bytes.equals(samekey.getValue(), found.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScanAcrossSnapshot() throws IOException {
        int i;
        int rowCount = this.addRows(this.memstore);
        KeyValueScanner[] memstorescanners = this.memstore.getScanners();
        Scan scan = new Scan();
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        StoreScanner s = new StoreScanner(scan, null, Long.MAX_VALUE, this.memstore.comparator, null, memstorescanners);
        int count = 0;
        try {
            while (s.next(result)) {
                this.LOG.info(result);
                ++count;
                TestMemStore.assertEquals((int)rowCount, (int)result.size());
                result.clear();
            }
        }
        finally {
            s.close();
        }
        TestMemStore.assertEquals((int)rowCount, (int)count);
        for (i = 0; i < memstorescanners.length; ++i) {
            memstorescanners[0].close();
        }
        memstorescanners = this.memstore.getScanners();
        s = new StoreScanner(scan, null, Long.MAX_VALUE, this.memstore.comparator, null, memstorescanners);
        count = 0;
        try {
            while (s.next(result)) {
                this.LOG.info(result);
                TestMemStore.assertTrue((Bytes.compareTo(Bytes.toBytes(count), ((KeyValue)result.get(0)).getRow()) == 0 ? 1 : 0) != 0);
                TestMemStore.assertEquals((int)rowCount, (int)result.size());
                if (++count == 2) {
                    this.memstore.snapshot();
                    this.LOG.info((Object)"Snapshotted");
                }
                result.clear();
            }
        }
        finally {
            s.close();
        }
        TestMemStore.assertEquals((int)rowCount, (int)count);
        for (i = 0; i < memstorescanners.length; ++i) {
            memstorescanners[0].close();
        }
        memstorescanners = this.memstore.getScanners();
        long ts = System.currentTimeMillis();
        s = new StoreScanner(scan, null, Long.MAX_VALUE, this.memstore.comparator, null, memstorescanners);
        count = 0;
        int snapshotIndex = 5;
        try {
            while (s.next(result)) {
                this.LOG.info(result);
                TestMemStore.assertTrue((Bytes.compareTo(Bytes.toBytes(count), ((KeyValue)result.get(0)).getRow()) == 0 ? 1 : 0) != 0);
                TestMemStore.assertEquals((String)("count=" + count + ", result=" + result), (int)rowCount, (int)result.size());
                if (++count == snapshotIndex) {
                    this.memstore.snapshot();
                    this.memstore.clearSnapshot(this.memstore.getSnapshot());
                    this.addRows(this.memstore, ts);
                    this.LOG.info((Object)"Snapshotted, cleared it and then added values");
                }
                result.clear();
            }
        }
        finally {
            s.close();
        }
        TestMemStore.assertEquals((int)rowCount, (int)count);
    }

    public void testSnapshotting() throws IOException {
        int snapshotCount = 5;
        for (int i = 0; i < 5; ++i) {
            this.addRows(this.memstore);
            this.runSnapshot(this.memstore);
            KeyValueSkipListSet ss = this.memstore.getSnapshot();
            TestMemStore.assertEquals((String)"History not being cleared", (int)0, (int)ss.size());
        }
    }

    public void testMultipleVersionsSimple() throws Exception {
        MemStore m = new MemStore(KeyValue.COMPARATOR);
        byte[] row = Bytes.toBytes("testRow");
        byte[] family = Bytes.toBytes("testFamily");
        byte[] qf = Bytes.toBytes("testQualifier");
        long[] stamps = new long[]{1L, 2L, 3L};
        byte[][] values = new byte[][]{Bytes.toBytes("value0"), Bytes.toBytes("value1"), Bytes.toBytes("value2")};
        KeyValue key0 = new KeyValue(row, family, qf, stamps[0], values[0]);
        KeyValue key1 = new KeyValue(row, family, qf, stamps[1], values[1]);
        KeyValue key2 = new KeyValue(row, family, qf, stamps[2], values[2]);
        m.add(key0);
        m.add(key1);
        m.add(key2);
        TestMemStore.assertTrue((String)("Expected memstore to hold 3 values, actually has " + m.kvset.size()), (m.kvset.size() == 3 ? 1 : 0) != 0);
    }

    public void testBinary() throws IOException {
        MemStore mc = new MemStore(KeyValue.ROOT_COMPARATOR);
        int start = 43;
        int end = 46;
        for (int k = 43; k <= 46; ++k) {
            byte[] kk = Bytes.toBytes(k);
            byte[] row = Bytes.toBytes(".META.,table," + Bytes.toString(kk) + ",1," + k);
            KeyValue key = new KeyValue(row, CONTENTS_BASIC, System.currentTimeMillis(), (CONTENTSTR + k).getBytes("UTF-8"));
            mc.add(key);
            System.out.println(key);
        }
        int index = 43;
        for (KeyValue kv : mc.kvset) {
            System.out.println(kv);
            byte[] b = kv.getRow();
            String str = Bytes.toString(b, 13, 4);
            byte[] bb = Bytes.toBytes(index);
            String bbStr = Bytes.toString(bb);
            TestMemStore.assertEquals((String)str, (String)bbStr);
            ++index;
        }
    }

    public void testGetNextRow() throws Exception {
        this.addRows(this.memstore);
        Thread.sleep(1L);
        this.addRows(this.memstore);
        KeyValue closestToEmpty = this.memstore.getNextRow(KeyValue.LOWESTKEY);
        TestMemStore.assertTrue((KeyValue.COMPARATOR.compareRows(closestToEmpty, new KeyValue(Bytes.toBytes(0), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            KeyValue nr = this.memstore.getNextRow(new KeyValue(Bytes.toBytes(i), System.currentTimeMillis()));
            if (i + 1 == 10) {
                TestMemStore.assertEquals((Object)nr, null);
                continue;
            }
            TestMemStore.assertTrue((KeyValue.COMPARATOR.compareRows(nr, new KeyValue(Bytes.toBytes(i + 1), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        }
        for (int startRowId = 0; startRowId < 10; ++startRowId) {
            StoreScanner scanner = new StoreScanner(new Scan(Bytes.toBytes(startRowId)), FAMILY, Integer.MAX_VALUE, this.memstore.comparator, null, new KeyValueScanner[]{this.memstore.getScanners()[0]});
            ArrayList<KeyValue> results = new ArrayList<KeyValue>();
            int i = 0;
            while (scanner.next(results)) {
                int rowId = startRowId + i;
                TestMemStore.assertTrue((String)"Row name", (KeyValue.COMPARATOR.compareRows((KeyValue)results.get(0), Bytes.toBytes(rowId)) == 0 ? 1 : 0) != 0);
                TestMemStore.assertEquals((String)"Count of columns", (int)10, (int)results.size());
                ArrayList<KeyValue> row = new ArrayList<KeyValue>();
                for (KeyValue kv : results) {
                    row.add(kv);
                }
                this.isExpectedRowWithoutTimestamps(rowId, row);
                results.clear();
                ++i;
            }
        }
    }

    public void testGet_Basic_Found() throws IOException {
        byte[] row = Bytes.toBytes("testrow");
        byte[] fam = Bytes.toBytes("testfamily");
        byte[] qf1 = Bytes.toBytes("testqualifier1");
        byte[] qf2 = Bytes.toBytes("testqualifier2");
        byte[] qf3 = Bytes.toBytes("testqualifier3");
        byte[] val = Bytes.toBytes("testval");
        KeyValue add1 = new KeyValue(row, fam, qf1, val);
        KeyValue add2 = new KeyValue(row, fam, qf2, val);
        KeyValue add3 = new KeyValue(row, fam, qf3, val);
        this.memstore.add(add1);
        this.memstore.add(add2);
        this.memstore.add(add3);
        Get get2 = new Get(row);
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(qf2);
        long ttl = Long.MAX_VALUE;
        QueryMatcher matcher = new QueryMatcher(get2, fam, columns, ttl, KeyValue.KEY_COMPARATOR, 1);
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        boolean res = this.memstore.get(matcher, result);
        TestMemStore.assertEquals((boolean)true, (boolean)res);
    }

    public void testGet_Basic_NotFound() throws IOException {
        byte[] row = Bytes.toBytes("testrow");
        byte[] fam = Bytes.toBytes("testfamily");
        byte[] qf1 = Bytes.toBytes("testqualifier1");
        byte[] qf2 = Bytes.toBytes("testqualifier2");
        byte[] qf3 = Bytes.toBytes("testqualifier3");
        byte[] val = Bytes.toBytes("testval");
        KeyValue add1 = new KeyValue(row, fam, qf1, val);
        KeyValue add3 = new KeyValue(row, fam, qf3, val);
        this.memstore.add(add1);
        this.memstore.add(add3);
        Get get2 = new Get(row);
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(qf2);
        long ttl = Long.MAX_VALUE;
        QueryMatcher matcher = new QueryMatcher(get2, fam, columns, ttl, KeyValue.KEY_COMPARATOR, 1);
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        boolean res = this.memstore.get(matcher, result);
        TestMemStore.assertEquals((boolean)false, (boolean)res);
    }

    public void testGet_memstoreAndSnapShot() throws IOException {
        byte[] row = Bytes.toBytes("testrow");
        byte[] fam = Bytes.toBytes("testfamily");
        byte[] qf1 = Bytes.toBytes("testqualifier1");
        byte[] qf2 = Bytes.toBytes("testqualifier2");
        byte[] qf3 = Bytes.toBytes("testqualifier3");
        byte[] qf4 = Bytes.toBytes("testqualifier4");
        byte[] qf5 = Bytes.toBytes("testqualifier5");
        byte[] val = Bytes.toBytes("testval");
        Get get2 = new Get(row);
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(qf2);
        columns.add(qf4);
        long ttl = Long.MAX_VALUE;
        QueryMatcher matcher = new QueryMatcher(get2, fam, columns, ttl, KeyValue.KEY_COMPARATOR, 1);
        this.memstore.add(new KeyValue(row, fam, qf1, val));
        this.memstore.add(new KeyValue(row, fam, qf2, val));
        this.memstore.add(new KeyValue(row, fam, qf3, val));
        this.memstore.snapshot();
        TestMemStore.assertEquals((int)3, (int)this.memstore.snapshot.size());
        TestMemStore.assertEquals((int)0, (int)this.memstore.kvset.size());
        this.memstore.add(new KeyValue(row, fam, qf4, val));
        this.memstore.add(new KeyValue(row, fam, qf5, val));
        TestMemStore.assertEquals((int)2, (int)this.memstore.kvset.size());
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        boolean res = this.memstore.get(matcher, result);
        TestMemStore.assertEquals((boolean)true, (boolean)res);
    }

    public void testGet_SpecificTimeStamp() throws IOException {
        byte[] row = Bytes.toBytes("testrow");
        byte[] fam = Bytes.toBytes("testfamily");
        byte[] qf1 = Bytes.toBytes("testqualifier1");
        byte[] qf2 = Bytes.toBytes("testqualifier2");
        byte[] qf3 = Bytes.toBytes("testqualifier3");
        byte[] val = Bytes.toBytes("testval");
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1++;
        long ts3 = ts2++;
        Get get2 = new Get(row);
        get2.setTimeStamp(ts2);
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(qf1);
        columns.add(qf2);
        columns.add(qf3);
        long ttl = Long.MAX_VALUE;
        QueryMatcher matcher = new QueryMatcher(get2, fam, columns, ttl, KeyValue.KEY_COMPARATOR, 1);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(row, fam, qf1, ts2, val);
        KeyValue kv2 = new KeyValue(row, fam, qf2, ts2, val);
        KeyValue kv3 = new KeyValue(row, fam, qf3, ts2, val);
        expected.add(kv1);
        expected.add(kv2);
        expected.add(kv3);
        this.memstore.add(new KeyValue(row, fam, qf1, ts1, val));
        this.memstore.add(new KeyValue(row, fam, qf2, ts1, val));
        this.memstore.add(new KeyValue(row, fam, qf3, ts1, val));
        this.memstore.add(kv1);
        this.memstore.add(kv2);
        this.memstore.add(kv3);
        this.memstore.add(new KeyValue(row, fam, qf1, ts3, val));
        this.memstore.add(new KeyValue(row, fam, qf2, ts3, val));
        this.memstore.add(new KeyValue(row, fam, qf3, ts3, val));
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        this.memstore.get(matcher, result);
        TestMemStore.assertEquals((int)expected.size(), (int)result.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestMemStore.assertEquals(expected.get(i), result.get(i));
        }
    }

    public void testGetWithDelete() throws IOException {
        byte[] row = Bytes.toBytes("testrow");
        byte[] fam = Bytes.toBytes("testfamily");
        byte[] qf1 = Bytes.toBytes("testqualifier");
        byte[] val = Bytes.toBytes("testval");
        long ts1 = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts1, val);
        long ts2 = ts1 + 1L;
        KeyValue put2 = new KeyValue(row, fam, qf1, ts2, val);
        long ts3 = ts2 + 1L;
        KeyValue put3 = new KeyValue(row, fam, qf1, ts3, val);
        this.memstore.add(put1);
        this.memstore.add(put2);
        this.memstore.add(put3);
        TestMemStore.assertEquals((int)3, (int)this.memstore.kvset.size());
        KeyValue del2 = new KeyValue(row, fam, qf1, ts2, KeyValue.Type.Delete, val);
        this.memstore.delete(del2);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(put3);
        expected.add(del2);
        expected.add(put1);
        TestMemStore.assertEquals((int)3, (int)this.memstore.kvset.size());
        int i = 0;
        for (KeyValue kv : this.memstore.kvset) {
            TestMemStore.assertEquals(expected.get(i++), (Object)kv);
        }
    }

    public void testGetWithDeleteColumn() throws IOException {
        byte[] row = Bytes.toBytes("testrow");
        byte[] fam = Bytes.toBytes("testfamily");
        byte[] qf1 = Bytes.toBytes("testqualifier");
        byte[] val = Bytes.toBytes("testval");
        long ts1 = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts1, val);
        long ts2 = ts1 + 1L;
        KeyValue put2 = new KeyValue(row, fam, qf1, ts2, val);
        long ts3 = ts2 + 1L;
        KeyValue put3 = new KeyValue(row, fam, qf1, ts3, val);
        this.memstore.add(put1);
        this.memstore.add(put2);
        this.memstore.add(put3);
        TestMemStore.assertEquals((int)3, (int)this.memstore.kvset.size());
        KeyValue del2 = new KeyValue(row, fam, qf1, ts2, KeyValue.Type.DeleteColumn, val);
        this.memstore.delete(del2);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(put3);
        expected.add(del2);
        TestMemStore.assertEquals((int)2, (int)this.memstore.kvset.size());
        int i = 0;
        for (KeyValue kv : this.memstore.kvset) {
            TestMemStore.assertEquals(expected.get(i++), (Object)kv);
        }
    }

    public void testGetWithDeleteFamily() throws IOException {
        byte[] row = Bytes.toBytes("testrow");
        byte[] fam = Bytes.toBytes("testfamily");
        byte[] qf1 = Bytes.toBytes("testqualifier1");
        byte[] qf2 = Bytes.toBytes("testqualifier2");
        byte[] qf3 = Bytes.toBytes("testqualifier3");
        byte[] val = Bytes.toBytes("testval");
        long ts = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts, val);
        KeyValue put2 = new KeyValue(row, fam, qf2, ts, val);
        KeyValue put3 = new KeyValue(row, fam, qf3, ts, val);
        KeyValue put4 = new KeyValue(row, fam, qf3, ts + 1L, val);
        this.memstore.add(put1);
        this.memstore.add(put2);
        this.memstore.add(put3);
        this.memstore.add(put4);
        KeyValue del = new KeyValue(row, fam, null, ts, KeyValue.Type.DeleteFamily, val);
        this.memstore.delete(del);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(del);
        expected.add(put4);
        TestMemStore.assertEquals((int)2, (int)this.memstore.kvset.size());
        int i = 0;
        for (KeyValue kv : this.memstore.kvset) {
            TestMemStore.assertEquals(expected.get(i++), (Object)kv);
        }
    }

    public void testKeepDeleteInmemstore() {
        byte[] row = Bytes.toBytes("testrow");
        byte[] fam = Bytes.toBytes("testfamily");
        byte[] qf = Bytes.toBytes("testqualifier");
        byte[] val = Bytes.toBytes("testval");
        long ts = System.nanoTime();
        this.memstore.add(new KeyValue(row, fam, qf, ts, val));
        KeyValue delete = new KeyValue(row, fam, qf, ts, KeyValue.Type.Delete, val);
        this.memstore.delete(delete);
        TestMemStore.assertEquals((int)1, (int)this.memstore.kvset.size());
        TestMemStore.assertEquals((Object)delete, (Object)this.memstore.kvset.first());
    }

    public void testRetainsDeleteVersion() throws IOException {
        this.memstore.add(KeyValueTestUtil.create("row1", "fam", "a", 100L, "dont-care"));
        KeyValue delete = KeyValueTestUtil.create("row1", "fam", "a", 100L, KeyValue.Type.Delete, "dont-care");
        this.memstore.delete(delete);
        TestMemStore.assertEquals((int)1, (int)this.memstore.kvset.size());
        TestMemStore.assertEquals((Object)delete, (Object)this.memstore.kvset.first());
    }

    public void testRetainsDeleteColumn() throws IOException {
        this.memstore.add(KeyValueTestUtil.create("row1", "fam", "a", 100L, "dont-care"));
        KeyValue delete = KeyValueTestUtil.create("row1", "fam", "a", 100L, KeyValue.Type.DeleteColumn, "dont-care");
        this.memstore.delete(delete);
        TestMemStore.assertEquals((int)1, (int)this.memstore.kvset.size());
        TestMemStore.assertEquals((Object)delete, (Object)this.memstore.kvset.first());
    }

    public void testRetainsDeleteFamily() throws IOException {
        this.memstore.add(KeyValueTestUtil.create("row1", "fam", "a", 100L, "dont-care"));
        KeyValue delete = KeyValueTestUtil.create("row1", "fam", "a", 100L, KeyValue.Type.DeleteFamily, "dont-care");
        this.memstore.delete(delete);
        TestMemStore.assertEquals((int)1, (int)this.memstore.kvset.size());
        TestMemStore.assertEquals((Object)delete, (Object)this.memstore.kvset.first());
    }

    private byte[] makeQualifier(int i1, int i2) {
        return Bytes.toBytes(Integer.toString(i1) + ";" + Integer.toString(i2));
    }

    private int addRows(MemStore hmc) {
        return this.addRows(hmc, Long.MAX_VALUE);
    }

    private int addRows(MemStore hmc, long ts) {
        for (int i = 0; i < 10; ++i) {
            long timestamp = ts == Long.MAX_VALUE ? System.currentTimeMillis() : ts;
            for (int ii = 0; ii < 10; ++ii) {
                byte[] row = Bytes.toBytes(i);
                byte[] qf = this.makeQualifier(i, ii);
                hmc.add(new KeyValue(row, FAMILY, qf, timestamp, qf));
            }
        }
        return 10;
    }

    private void runSnapshot(MemStore hmc) throws UnexpectedException {
        int oldHistorySize = hmc.getSnapshot().size();
        hmc.snapshot();
        KeyValueSkipListSet ss = hmc.getSnapshot();
        TestMemStore.assertTrue((String)"History size has not increased", (oldHistorySize < ss.size() ? 1 : 0) != 0);
        hmc.clearSnapshot(ss);
    }

    private void isExpectedRowWithoutTimestamps(int rowIndex, List<KeyValue> kvs) {
        int i = 0;
        for (KeyValue kv : kvs) {
            String expectedColname = Bytes.toString(this.makeQualifier(rowIndex, i++));
            String colnameStr = Bytes.toString(kv.getQualifier());
            TestMemStore.assertEquals((String)"Column name", (String)colnameStr, (String)expectedColname);
            String colvalueStr = Bytes.toString(kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
            TestMemStore.assertEquals((String)"Content", (String)colnameStr, (String)colvalueStr);
        }
    }

    private KeyValue getDeleteKV(byte[] row) {
        return new KeyValue(row, Bytes.toBytes("test_col:"), Long.MAX_VALUE, KeyValue.Type.Delete, null);
    }

    private KeyValue getKV(byte[] row, byte[] value) {
        return new KeyValue(row, Bytes.toBytes("test_col:"), Long.MAX_VALUE, value);
    }
}

