/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class TestQueryMatcher
extends HBaseTestCase
implements HConstants {
    private final boolean PRINT = false;
    private byte[] row1;
    private byte[] row2;
    private byte[] fam1;
    private byte[] fam2;
    private byte[] col1;
    private byte[] col2;
    private byte[] col3;
    private byte[] col4;
    private byte[] col5;
    private byte[] col6;
    private byte[] data;
    private Get get;
    long ttl = Long.MAX_VALUE;
    KeyValue.KeyComparator rowComparator;

    @Override
    public void setUp() {
        this.row1 = Bytes.toBytes("row1");
        this.row2 = Bytes.toBytes("row2");
        this.fam1 = Bytes.toBytes("fam1");
        this.fam2 = Bytes.toBytes("fam2");
        this.col1 = Bytes.toBytes("col1");
        this.col2 = Bytes.toBytes("col2");
        this.col3 = Bytes.toBytes("col3");
        this.col4 = Bytes.toBytes("col4");
        this.col5 = Bytes.toBytes("col5");
        this.col6 = Bytes.toBytes("col6");
        this.data = Bytes.toBytes("data");
        this.get = new Get(this.row1);
        this.get.addFamily(this.fam1);
        this.get.addColumn(this.fam2, this.col2);
        this.get.addColumn(this.fam2, this.col4);
        this.get.addColumn(this.fam2, this.col5);
        this.rowComparator = KeyValue.KEY_COMPARATOR;
    }

    public void testMatch_ExplicitColumns() throws IOException {
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.DONE);
        QueryMatcher qm = new QueryMatcher(this.get, this.fam2, this.get.getFamilyMap().get(this.fam2), this.ttl, this.rowComparator, 1);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        ArrayList<QueryMatcher.MatchCode> actual = new ArrayList<QueryMatcher.MatchCode>();
        for (KeyValue kv : memstore) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestQueryMatcher.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testMatch_Wildcard() throws IOException {
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.NEXT);
        QueryMatcher qm = new QueryMatcher(this.get, this.fam2, null, this.ttl, this.rowComparator, 1);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        ArrayList<QueryMatcher.MatchCode> actual = new ArrayList<QueryMatcher.MatchCode>();
        for (KeyValue kv : memstore) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestQueryMatcher.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testMatch_ExpiredExplicit() throws IOException {
        long testTTL = 1000L;
        QueryMatcher.MatchCode[] expected = new QueryMatcher.MatchCode[]{QueryMatcher.MatchCode.SKIP, QueryMatcher.MatchCode.INCLUDE, QueryMatcher.MatchCode.SKIP, QueryMatcher.MatchCode.INCLUDE, QueryMatcher.MatchCode.SKIP, QueryMatcher.MatchCode.NEXT};
        QueryMatcher qm = new QueryMatcher(this.get, this.fam2, this.get.getFamilyMap().get(this.fam2), testTTL, this.rowComparator, 1);
        long now = System.currentTimeMillis();
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        ArrayList<QueryMatcher.MatchCode> actual = new ArrayList<QueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)((Object)expected[i]), actual.get(i));
        }
    }

    public void testMatch_ExpiredWildcard() throws IOException {
        long testTTL = 1000L;
        QueryMatcher.MatchCode[] expected = new QueryMatcher.MatchCode[]{QueryMatcher.MatchCode.INCLUDE, QueryMatcher.MatchCode.INCLUDE, QueryMatcher.MatchCode.SKIP, QueryMatcher.MatchCode.INCLUDE, QueryMatcher.MatchCode.SKIP, QueryMatcher.MatchCode.NEXT};
        QueryMatcher qm = new QueryMatcher(this.get, this.fam2, null, testTTL, this.rowComparator, 1);
        long now = System.currentTimeMillis();
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        ArrayList<QueryMatcher.MatchCode> actual = new ArrayList<QueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)((Object)expected[i]), actual.get(i));
        }
    }
}

