/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.regionserver.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class TestScanWildcardColumnTracker
extends HBaseTestCase {
    final int VERSIONS = 2;

    public void testCheckColumn_Ok() {
        ScanWildcardColumnTracker tracker = new ScanWildcardColumnTracker(2);
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        qualifiers.add(Bytes.toBytes("qualifer1"));
        qualifiers.add(Bytes.toBytes("qualifer2"));
        qualifiers.add(Bytes.toBytes("qualifer3"));
        qualifiers.add(Bytes.toBytes("qualifer4"));
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        ArrayList<QueryMatcher.MatchCode> actual = new ArrayList<QueryMatcher.MatchCode>();
        for (byte[] qualifier : qualifiers) {
            QueryMatcher.MatchCode mc = tracker.checkColumn(qualifier, 0, qualifier.length);
            actual.add(mc);
        }
        for (int i = 0; i < expected.size(); ++i) {
            TestScanWildcardColumnTracker.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testCheckColumn_EnforceVersions() {
        ScanWildcardColumnTracker tracker = new ScanWildcardColumnTracker(2);
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        qualifiers.add(Bytes.toBytes("qualifer1"));
        qualifiers.add(Bytes.toBytes("qualifer1"));
        qualifiers.add(Bytes.toBytes("qualifer1"));
        qualifiers.add(Bytes.toBytes("qualifer2"));
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.SKIP);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        ArrayList<QueryMatcher.MatchCode> actual = new ArrayList<QueryMatcher.MatchCode>();
        for (byte[] qualifier : qualifiers) {
            QueryMatcher.MatchCode mc = tracker.checkColumn(qualifier, 0, qualifier.length);
            actual.add(mc);
        }
        for (int i = 0; i < expected.size(); ++i) {
            TestScanWildcardColumnTracker.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void DisabledTestCheckColumn_WrongOrder() {
        ScanWildcardColumnTracker tracker = new ScanWildcardColumnTracker(2);
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        qualifiers.add(Bytes.toBytes("qualifer2"));
        qualifiers.add(Bytes.toBytes("qualifer1"));
        boolean ok = false;
        try {
            for (byte[] qualifier : qualifiers) {
                QueryMatcher.MatchCode mc = tracker.checkColumn(qualifier, 0, qualifier.length);
            }
        }
        catch (Exception e) {
            ok = true;
        }
        TestScanWildcardColumnTracker.assertEquals((boolean)true, (boolean)ok);
    }
}

