/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassSize {
    static final Log LOG = LogFactory.getLog(ClassSize.class);
    private static int nrOfRefsPerObj = 2;
    public static int ARRAY = 0;
    public static int ARRAYLIST = 0;
    public static int BYTE_BUFFER = 0;
    public static int INTEGER = 0;
    public static int MAP_ENTRY = 0;
    public static int OBJECT = 0;
    public static int REFERENCE = 0;
    public static int STRING = 0;
    public static int TREEMAP = 0;
    public static int CONCURRENT_HASHMAP = 0;
    public static int CONCURRENT_HASHMAP_ENTRY = 0;
    public static int CONCURRENT_HASHMAP_SEGMENT = 0;
    public static int CONCURRENT_SKIPLISTMAP = 0;
    public static int CONCURRENT_SKIPLISTMAP_ENTRY = 0;
    public static int REENTRANT_LOCK = 0;
    public static int ATOMIC_LONG = 0;
    public static int ATOMIC_INTEGER = 0;
    public static int ATOMIC_BOOLEAN = 0;
    public static int COPYONWRITE_ARRAYSET = 0;
    public static int COPYONWRITE_ARRAYLIST = 0;
    private static final String THIRTY_TWO = "32";

    private static int[] getSizeCoefficients(Class cl, boolean debug) {
        int primitives = 0;
        int arrays = 0;
        int references = nrOfRefsPerObj;
        while (null != cl) {
            Field[] field = cl.getDeclaredFields();
            if (null != field) {
                for (int i = 0; i < field.length; ++i) {
                    if (Modifier.isStatic(field[i].getModifiers())) continue;
                    Class<?> fieldClass = field[i].getType();
                    if (fieldClass.isArray()) {
                        ++arrays;
                        ++references;
                    } else if (!fieldClass.isPrimitive()) {
                        ++references;
                    } else {
                        String name = fieldClass.getName();
                        if (name.equals("int") || name.equals("I")) {
                            primitives += 4;
                        } else if (name.equals("long") || name.equals("J")) {
                            primitives += 8;
                        } else if (name.equals("boolean") || name.equals("Z")) {
                            ++primitives;
                        } else if (name.equals("short") || name.equals("S")) {
                            primitives += 2;
                        } else if (name.equals("byte") || name.equals("B")) {
                            ++primitives;
                        } else if (name.equals("char") || name.equals("C")) {
                            primitives += 2;
                        } else if (name.equals("float") || name.equals("F")) {
                            primitives += 4;
                        } else if (name.equals("double") || name.equals("D")) {
                            primitives += 8;
                        }
                    }
                    if (!debug || !LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)(field[i].getName() + "\n\t" + field[i].getType()));
                }
            }
            cl = cl.getSuperclass();
        }
        return new int[]{primitives, arrays, references};
    }

    private static long estimateBaseFromCoefficients(int[] coeff, boolean debug) {
        long size = coeff[0] + ClassSize.align(coeff[1] * ARRAY) + coeff[2] * REFERENCE;
        size = ClassSize.align(size);
        if (debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Primitives " + coeff[0] + ", arrays " + coeff[1] + ", references(includes " + nrOfRefsPerObj + " for object overhead) " + coeff[2] + ", refSize " + REFERENCE + ", size " + size));
        }
        return size;
    }

    public static long estimateBase(Class cl, boolean debug) {
        return ClassSize.estimateBaseFromCoefficients(ClassSize.getSizeCoefficients(cl, debug), debug);
    }

    public static int align(int num) {
        return (int)ClassSize.align((long)num);
    }

    public static long align(long num) {
        return num + 7L >> 3 << 3;
    }

    static {
        Properties sysProps = System.getProperties();
        String arcModel = sysProps.getProperty("sun.arch.data.model");
        REFERENCE = 8;
        if (arcModel.equals(THIRTY_TWO)) {
            REFERENCE = 4;
        }
        OBJECT = 2 * REFERENCE;
        ARRAY = 3 * REFERENCE;
        ARRAYLIST = ClassSize.align(OBJECT + ClassSize.align(REFERENCE) + ClassSize.align(ARRAY) + 8);
        BYTE_BUFFER = ClassSize.align(OBJECT + ClassSize.align(REFERENCE) + ClassSize.align(ARRAY) + 20 + 3 + 8);
        INTEGER = ClassSize.align(OBJECT + 4);
        MAP_ENTRY = ClassSize.align(OBJECT + 5 * REFERENCE + 1);
        TREEMAP = ClassSize.align(OBJECT + 8 + ClassSize.align(7 * REFERENCE));
        STRING = ClassSize.align(OBJECT + ARRAY + REFERENCE + 12);
        CONCURRENT_HASHMAP = ClassSize.align(8 + ARRAY + 6 * REFERENCE + OBJECT);
        CONCURRENT_HASHMAP_ENTRY = ClassSize.align(REFERENCE + OBJECT + 3 * REFERENCE + 8);
        CONCURRENT_HASHMAP_SEGMENT = ClassSize.align(REFERENCE + OBJECT + 12 + 4 + ARRAY);
        CONCURRENT_SKIPLISTMAP = ClassSize.align(4 + OBJECT + 8 * REFERENCE);
        CONCURRENT_SKIPLISTMAP_ENTRY = ClassSize.align(ClassSize.align(OBJECT + 3 * REFERENCE) + ClassSize.align((OBJECT + 3 * REFERENCE) / 2));
        REENTRANT_LOCK = ClassSize.align(OBJECT + 3 * REFERENCE);
        ATOMIC_LONG = ClassSize.align(OBJECT + 8);
        ATOMIC_INTEGER = ClassSize.align(OBJECT + 4);
        ATOMIC_BOOLEAN = ClassSize.align(OBJECT + 1);
        COPYONWRITE_ARRAYSET = ClassSize.align(OBJECT + REFERENCE);
        COPYONWRITE_ARRAYLIST = ClassSize.align(OBJECT + 2 * REFERENCE + ARRAY);
    }
}

