/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.util.Bytes;

public class TestBytes
extends TestCase {
    public void testNullHashCode() {
        byte[] b = null;
        Exception ee = null;
        try {
            Bytes.hashCode(b);
        }
        catch (Exception e) {
            ee = e;
        }
        TestBytes.assertNotNull((Object)ee);
    }

    public void testSplit() throws Exception {
        int i;
        byte[] lowest = Bytes.toBytes("AAA");
        byte[] middle = Bytes.toBytes("CCC");
        byte[] highest = Bytes.toBytes("EEE");
        byte[][] parts = Bytes.split(lowest, highest, 1);
        for (i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString(parts[i]));
        }
        TestBytes.assertEquals((int)3, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals(parts[1], middle));
        highest = Bytes.toBytes("DDD");
        parts = Bytes.split(lowest, highest, 2);
        for (i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString(parts[i]));
        }
        TestBytes.assertEquals((int)4, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals(parts[2], middle));
    }

    public void testSplit2() throws Exception {
        byte[] lowest = Bytes.toBytes("http://A");
        byte[] highest = Bytes.toBytes("http://z");
        byte[] middle = Bytes.toBytes("http://]");
        byte[][] parts = Bytes.split(lowest, highest, 1);
        for (int i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString(parts[i]));
        }
        TestBytes.assertEquals((int)3, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals(parts[1], middle));
    }

    public void testToChars() throws Exception {
        char[] chars = new char[]{'b', 'l', 'a', 'b', 'l', 'a', 'b', 'l', 'a'};
        byte[] bytes = Bytes.toBytes(chars);
        char[] chars2 = Bytes.toChars(bytes);
        TestBytes.assertTrue((boolean)Arrays.equals(chars, chars2));
    }

    public void testToBigDecimal() throws Exception {
        BigDecimal bd1 = new BigDecimal("3.14");
        byte[] bytes = Bytes.toBytes(bd1);
        BigDecimal bd2 = Bytes.toBigDecimal(bytes);
        TestBytes.assertEquals((Object)bd1, (Object)bd2);
    }

    public void testToChar() throws Exception {
        for (char c = '\u0000'; c < '\uffff'; c = (char)(c + '\u0001')) {
            byte[] b = Bytes.toBytes(c);
            TestBytes.assertEquals((char)c, (char)Bytes.toChar(b));
        }
    }

    public void testToLong() throws Exception {
        long[] longs = new long[]{-1L, 123L, 122232323232L};
        for (int i = 0; i < longs.length; ++i) {
            byte[] b = Bytes.toBytes(longs[i]);
            TestBytes.assertEquals((long)longs[i], (long)Bytes.toLong(b));
        }
    }

    public void testToFloat() throws Exception {
        float[] floats = new float[]{-1.0f, 123.123f, Float.MAX_VALUE};
        for (int i = 0; i < floats.length; ++i) {
            byte[] b = Bytes.toBytes(floats[i]);
            TestBytes.assertEquals((Object)Float.valueOf(floats[i]), (Object)Float.valueOf(Bytes.toFloat(b)));
        }
    }

    public void testToDouble() throws Exception {
        double[] doubles = new double[]{Double.MIN_VALUE, Double.MAX_VALUE};
        for (int i = 0; i < doubles.length; ++i) {
            byte[] b = Bytes.toBytes(doubles[i]);
            TestBytes.assertEquals((Object)doubles[i], (Object)Bytes.toDouble(b));
        }
    }

    public void testBinarySearch() throws Exception {
        byte[][] arr = new byte[][]{{1}, {3}, {5}, {7}, {9}, {11}, {13}, {15}};
        byte[] key1 = new byte[]{3, 1};
        byte[] key2 = new byte[]{4, 9};
        byte[] key2_2 = new byte[]{4};
        byte[] key3 = new byte[]{5, 11};
        TestBytes.assertEquals((int)1, (int)Bytes.binarySearch(arr, key1, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)0, (int)Bytes.binarySearch(arr, key1, 1, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)-3, (int)Arrays.binarySearch(arr, key2_2, Bytes.BYTES_COMPARATOR));
        TestBytes.assertEquals((int)-3, (int)Bytes.binarySearch(arr, key2, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)4, (int)Bytes.binarySearch(arr, key2, 1, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)2, (int)Bytes.binarySearch(arr, key3, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)5, (int)Bytes.binarySearch(arr, key3, 1, 1, Bytes.BYTES_RAWCOMPARATOR));
    }

    public void testIncrementBytes() throws IOException {
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(12L, 123435445L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(124634654L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10005460L, 5005645L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1L, -1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1005435000L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -43657655L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-26L, 5034520L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10657200L, 5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, 45376475L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12L, -34565445L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1546543452L, -34565445L));
    }

    private static boolean checkTestIncrementBytes(long val, long amount) throws IOException {
        byte[] value = Bytes.toBytes(val);
        byte[] testValue = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        if (value[0] > 0) {
            testValue = new byte[8];
        }
        System.arraycopy(value, 0, testValue, testValue.length - value.length, value.length);
        long incrementResult = Bytes.toLong(Bytes.incrementBytes(value, amount));
        return Bytes.toLong(testValue) + amount == incrementResult;
    }
}

