/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.util.Sleeper;

public abstract class Chore
extends Thread {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private final Sleeper sleeper;
    protected volatile AtomicBoolean stop;

    public Chore(int p, AtomicBoolean s) {
        this.sleeper = new Sleeper(p, s);
        this.stop = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean initialChoreComplete = false;
            while (!this.stop.get()) {
                long startTime = System.currentTimeMillis();
                try {
                    if (!initialChoreComplete) {
                        initialChoreComplete = this.initialChore();
                    } else {
                        this.chore();
                    }
                }
                catch (Exception e) {
                    this.LOG.error((Object)"Caught exception", (Throwable)e);
                    if (this.stop.get()) continue;
                }
                this.sleeper.sleep(startTime);
            }
        }
        catch (Throwable t) {
            this.LOG.fatal((Object)"Caught error. Starting shutdown.", t);
            this.stop.set(true);
        }
        finally {
            this.LOG.info((Object)(this.getName() + " exiting"));
        }
    }

    protected boolean initialChore() {
        return true;
    }

    protected abstract void chore();

    protected void sleep() {
        this.sleeper.sleep();
    }
}

