/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.io.Cell;

public class PageRowFilter
implements RowFilterInterface {
    private long pageSize = Long.MAX_VALUE;
    private int rowsAccepted = 0;

    public PageRowFilter() {
    }

    public PageRowFilter(long pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void validate(byte[][] columns) {
    }

    @Override
    public void reset() {
        this.rowsAccepted = 0;
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] rowKey) {
        this.rowProcessed(filtered, rowKey, 0, rowKey.length);
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] key, int offset, int length) {
        if (!filtered) {
            ++this.rowsAccepted;
        }
    }

    @Override
    public boolean processAlways() {
        return false;
    }

    @Override
    public boolean filterAllRemaining() {
        return (long)this.rowsAccepted > this.pageSize;
    }

    @Override
    public boolean filterRowKey(byte[] r) {
        return this.filterRowKey(r, 0, r.length);
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterColumn(byte[] rowKey, byte[] colKey, byte[] data) {
        return this.filterColumn(rowKey, 0, rowKey.length, colKey, 0, colKey.length, data, 0, data.length);
    }

    @Override
    public boolean filterColumn(byte[] rowKey, int roffset, int rlength, byte[] colunmName, int coffset, int clength, byte[] columnValue, int voffset, int vlength) {
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterRow(SortedMap<byte[], Cell> columns) {
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterRow(List<KeyValue> results) {
        return this.filterAllRemaining();
    }

    public void readFields(DataInput in) throws IOException {
        this.pageSize = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.pageSize);
    }
}

