/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class SingleColumnValueFilter
implements Filter {
    static final Log LOG = LogFactory.getLog(SingleColumnValueFilter.class);
    private byte[] columnFamily;
    private byte[] columnQualifier;
    private CompareFilter.CompareOp compareOp;
    private WritableByteArrayComparable comparator;
    private boolean foundColumn = false;
    private boolean matchedColumn = false;
    private boolean filterIfMissing = false;
    private boolean latestVersionOnly = true;

    public SingleColumnValueFilter() {
    }

    public SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value) {
        this(family, qualifier, compareOp, new BinaryComparator(value));
    }

    public SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator) {
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.compareOp = compareOp;
        this.comparator = comparator;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue keyValue) {
        if (this.matchedColumn) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (this.latestVersionOnly && this.foundColumn) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        if (!keyValue.matchingColumn(this.columnFamily, this.columnQualifier)) {
            return Filter.ReturnCode.INCLUDE;
        }
        this.foundColumn = true;
        if (this.filterColumnValue(keyValue.getBuffer(), keyValue.getValueOffset(), keyValue.getValueLength())) {
            return this.latestVersionOnly ? Filter.ReturnCode.NEXT_ROW : Filter.ReturnCode.INCLUDE;
        }
        this.matchedColumn = true;
        return Filter.ReturnCode.INCLUDE;
    }

    private boolean filterColumnValue(byte[] data, int offset, int length) {
        int compareResult = this.comparator.compareTo(Arrays.copyOfRange(data, offset, offset + length));
        LOG.debug((Object)("compareResult=" + compareResult + " " + Bytes.toString(data, offset, length)));
        switch (this.compareOp) {
            case LESS: {
                return compareResult <= 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult < 0;
            }
            case EQUAL: {
                return compareResult != 0;
            }
            case NOT_EQUAL: {
                return compareResult == 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult > 0;
            }
            case GREATER: {
                return compareResult >= 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + this.compareOp.name());
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public boolean filterRow() {
        return this.foundColumn ? !this.matchedColumn : this.filterIfMissing;
    }

    @Override
    public void reset() {
        this.foundColumn = false;
        this.matchedColumn = false;
    }

    public boolean getFilterIfMissing() {
        return this.filterIfMissing;
    }

    public void setFilterIfMissing(boolean filterIfMissing) {
        this.filterIfMissing = filterIfMissing;
    }

    public boolean getLatestVersionOnly() {
        return this.latestVersionOnly;
    }

    public void setLatestVersionOnly(boolean latestVersionOnly) {
        this.latestVersionOnly = latestVersionOnly;
    }

    public void readFields(DataInput in) throws IOException {
        this.columnFamily = Bytes.readByteArray(in);
        if (this.columnFamily.length == 0) {
            this.columnFamily = null;
        }
        this.columnQualifier = Bytes.readByteArray(in);
        if (this.columnQualifier.length == 0) {
            this.columnQualifier = null;
        }
        this.compareOp = CompareFilter.CompareOp.valueOf(in.readUTF());
        this.comparator = (WritableByteArrayComparable)HbaseObjectWritable.readObject(in, null);
        this.foundColumn = in.readBoolean();
        this.matchedColumn = in.readBoolean();
        this.filterIfMissing = in.readBoolean();
        this.latestVersionOnly = in.readBoolean();
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.columnFamily);
        Bytes.writeByteArray(out, this.columnQualifier);
        out.writeUTF(this.compareOp.name());
        HbaseObjectWritable.writeObject(out, this.comparator, WritableByteArrayComparable.class, null);
        out.writeBoolean(this.foundColumn);
        out.writeBoolean(this.matchedColumn);
        out.writeBoolean(this.filterIfMissing);
        out.writeBoolean(this.latestVersionOnly);
    }
}

