/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.mapred.IndexConfiguration;
import org.apache.hadoop.hbase.mapred.LuceneDocumentWrapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

@Deprecated
public class IndexTableReduce
extends MapReduceBase
implements Reducer<ImmutableBytesWritable, RowResult, ImmutableBytesWritable, LuceneDocumentWrapper> {
    private static final Log LOG = LogFactory.getLog(IndexTableReduce.class);
    private IndexConfiguration indexConf;

    public void configure(JobConf job) {
        super.configure(job);
        this.indexConf = new IndexConfiguration();
        String content = job.get("hbase.index.conf");
        if (content != null) {
            this.indexConf.addFromXML(content);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Index conf: " + (Object)((Object)this.indexConf)));
        }
    }

    public void close() throws IOException {
        super.close();
    }

    public void reduce(ImmutableBytesWritable key, Iterator<RowResult> values, OutputCollector<ImmutableBytesWritable, LuceneDocumentWrapper> output, Reporter reporter) throws IOException {
        if (!values.hasNext()) {
            return;
        }
        Document doc = new Document();
        Field keyField = new Field(this.indexConf.getRowkeyName(), Bytes.toString(key.get(), key.getOffset(), key.getLength()), Field.Store.YES, Field.Index.UN_TOKENIZED);
        keyField.setOmitNorms(true);
        doc.add((Fieldable)keyField);
        while (values.hasNext()) {
            RowResult value = values.next();
            for (Map.Entry<byte[], Cell> entry : value.entrySet()) {
                Field.Store store;
                String column = Bytes.toString(entry.getKey());
                byte[] columnValue = entry.getValue().getValue();
                Field.Store store2 = store = this.indexConf.isStore(column) ? Field.Store.YES : Field.Store.NO;
                Field.Index index = this.indexConf.isIndex(column) ? (this.indexConf.isTokenize(column) ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED) : Field.Index.NO;
                Field field = new Field(column, Bytes.toString(columnValue), store, index);
                field.setBoost(this.indexConf.getBoost(column));
                field.setOmitNorms(this.indexConf.isOmitNorms(column));
                doc.add((Fieldable)field);
            }
        }
        output.collect((Object)key, (Object)new LuceneDocumentWrapper(doc));
    }
}

